/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.services.sesv2.model.SuppressionListReason;
import software.amazon.awssdk.services.sesv2.model.SuppressionListReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSuppressedDestinationsRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, ListSuppressedDestinationsRequest> {
    private static final SdkField<List<String>> REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Reasons").getter(ListSuppressedDestinationsRequest.getter(ListSuppressedDestinationsRequest::reasonsAsStrings)).setter(ListSuppressedDestinationsRequest.setter(Builder::reasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Reason").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(ListSuppressedDestinationsRequest.getter(ListSuppressedDestinationsRequest::startDate)).setter(ListSuppressedDestinationsRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(ListSuppressedDestinationsRequest.getter(ListSuppressedDestinationsRequest::endDate)).setter(ListSuppressedDestinationsRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EndDate").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSuppressedDestinationsRequest.getter(ListSuppressedDestinationsRequest::nextToken)).setter(ListSuppressedDestinationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(ListSuppressedDestinationsRequest.getter(ListSuppressedDestinationsRequest::pageSize)).setter(ListSuppressedDestinationsRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASONS_FIELD, START_DATE_FIELD, END_DATE_FIELD, NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSuppressedDestinationsRequest.memberNameToFieldInitializer();
    private final List<String> reasons;
    private final Instant startDate;
    private final Instant endDate;
    private final String nextToken;
    private final Integer pageSize;

    private ListSuppressedDestinationsRequest(BuilderImpl builder) {
        super(builder);
        this.reasons = builder.reasons;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
    }

    public final List<SuppressionListReason> reasons() {
        return SuppressionListReasonsCopier.copyStringToEnum(this.reasons);
    }

    public final boolean hasReasons() {
        return this.reasons != null && !(this.reasons instanceof SdkAutoConstructList);
    }

    public final List<String> reasonsAsStrings() {
        return this.reasons;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasons() ? this.reasonsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuppressedDestinationsRequest)) {
            return false;
        }
        ListSuppressedDestinationsRequest other = (ListSuppressedDestinationsRequest)((Object)obj);
        return this.hasReasons() == other.hasReasons() && Objects.equals(this.reasonsAsStrings(), other.reasonsAsStrings()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public final String toString() {
        return ToString.builder((String)"ListSuppressedDestinationsRequest").add("Reasons", this.hasReasons() ? this.reasonsAsStrings() : null).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("NextToken", (Object)this.nextToken()).add("PageSize", (Object)this.pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Reasons": {
                return Optional.ofNullable(clazz.cast(this.reasonsAsStrings()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Reason", REASONS_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSuppressedDestinationsRequest, T> g) {
        return obj -> g.apply((ListSuppressedDestinationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();
        private Instant startDate;
        private Instant endDate;
        private String nextToken;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuppressedDestinationsRequest model) {
            super(model);
            this.reasonsWithStrings(model.reasons);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.nextToken(model.nextToken);
            this.pageSize(model.pageSize);
        }

        public final Collection<String> getReasons() {
            if (this.reasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reasons;
        }

        public final void setReasons(Collection<String> reasons) {
            this.reasons = SuppressionListReasonsCopier.copy(reasons);
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = SuppressionListReasonsCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String ... reasons) {
            this.reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<SuppressionListReason> reasons) {
            this.reasons = SuppressionListReasonsCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(SuppressionListReason ... reasons) {
            this.reasons(Arrays.asList(reasons));
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSuppressedDestinationsRequest build() {
            return new ListSuppressedDestinationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSuppressedDestinationsRequest> {
        public Builder reasonsWithStrings(Collection<String> var1);

        public Builder reasonsWithStrings(String ... var1);

        public Builder reasons(Collection<SuppressionListReason> var1);

        public Builder reasons(SuppressionListReason ... var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder nextToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

