/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.AdditionalContactEmailAddressesCopier;
import software.amazon.awssdk.services.sesv2.model.ContactLanguage;
import software.amazon.awssdk.services.sesv2.model.MailType;
import software.amazon.awssdk.services.sesv2.model.ReviewDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountDetails> {
    private static final SdkField<String> MAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MailType").getter(AccountDetails.getter(AccountDetails::mailTypeAsString)).setter(AccountDetails.setter(Builder::mailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailType").build()}).build();
    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebsiteURL").getter(AccountDetails.getter(AccountDetails::websiteURL)).setter(AccountDetails.setter(Builder::websiteURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteURL").build()}).build();
    private static final SdkField<String> CONTACT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactLanguage").getter(AccountDetails.getter(AccountDetails::contactLanguageAsString)).setter(AccountDetails.setter(Builder::contactLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactLanguage").build()}).build();
    private static final SdkField<String> USE_CASE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseCaseDescription").getter(AccountDetails.getter(AccountDetails::useCaseDescription)).setter(AccountDetails.setter(Builder::useCaseDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseDescription").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalContactEmailAddresses").getter(AccountDetails.getter(AccountDetails::additionalContactEmailAddresses)).setter(AccountDetails.setter(Builder::additionalContactEmailAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalContactEmailAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReviewDetails> REVIEW_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReviewDetails").getter(AccountDetails.getter(AccountDetails::reviewDetails)).setter(AccountDetails.setter(Builder::reviewDetails)).constructor(ReviewDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAIL_TYPE_FIELD, WEBSITE_URL_FIELD, CONTACT_LANGUAGE_FIELD, USE_CASE_DESCRIPTION_FIELD, ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD, REVIEW_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MailType", MAIL_TYPE_FIELD);
            this.put("WebsiteURL", WEBSITE_URL_FIELD);
            this.put("ContactLanguage", CONTACT_LANGUAGE_FIELD);
            this.put("UseCaseDescription", USE_CASE_DESCRIPTION_FIELD);
            this.put("AdditionalContactEmailAddresses", ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD);
            this.put("ReviewDetails", REVIEW_DETAILS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String mailType;
    private final String websiteURL;
    private final String contactLanguage;
    private final String useCaseDescription;
    private final List<String> additionalContactEmailAddresses;
    private final ReviewDetails reviewDetails;

    private AccountDetails(BuilderImpl builder) {
        this.mailType = builder.mailType;
        this.websiteURL = builder.websiteURL;
        this.contactLanguage = builder.contactLanguage;
        this.useCaseDescription = builder.useCaseDescription;
        this.additionalContactEmailAddresses = builder.additionalContactEmailAddresses;
        this.reviewDetails = builder.reviewDetails;
    }

    public final MailType mailType() {
        return MailType.fromValue(this.mailType);
    }

    public final String mailTypeAsString() {
        return this.mailType;
    }

    public final String websiteURL() {
        return this.websiteURL;
    }

    public final ContactLanguage contactLanguage() {
        return ContactLanguage.fromValue(this.contactLanguage);
    }

    public final String contactLanguageAsString() {
        return this.contactLanguage;
    }

    public final String useCaseDescription() {
        return this.useCaseDescription;
    }

    public final boolean hasAdditionalContactEmailAddresses() {
        return this.additionalContactEmailAddresses != null && !(this.additionalContactEmailAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> additionalContactEmailAddresses() {
        return this.additionalContactEmailAddresses;
    }

    public final ReviewDetails reviewDetails() {
        return this.reviewDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCaseDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalContactEmailAddresses() ? this.additionalContactEmailAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountDetails)) {
            return false;
        }
        AccountDetails other = (AccountDetails)obj;
        return Objects.equals(this.mailTypeAsString(), other.mailTypeAsString()) && Objects.equals(this.websiteURL(), other.websiteURL()) && Objects.equals(this.contactLanguageAsString(), other.contactLanguageAsString()) && Objects.equals(this.useCaseDescription(), other.useCaseDescription()) && this.hasAdditionalContactEmailAddresses() == other.hasAdditionalContactEmailAddresses() && Objects.equals(this.additionalContactEmailAddresses(), other.additionalContactEmailAddresses()) && Objects.equals(this.reviewDetails(), other.reviewDetails());
    }

    public final String toString() {
        return ToString.builder((String)"AccountDetails").add("MailType", (Object)this.mailTypeAsString()).add("WebsiteURL", (Object)(this.websiteURL() == null ? null : "*** Sensitive Data Redacted ***")).add("ContactLanguage", (Object)this.contactLanguageAsString()).add("UseCaseDescription", (Object)(this.useCaseDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("AdditionalContactEmailAddresses", (Object)(this.additionalContactEmailAddresses() == null ? null : "*** Sensitive Data Redacted ***")).add("ReviewDetails", (Object)this.reviewDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MailType": {
                return Optional.ofNullable(clazz.cast(this.mailTypeAsString()));
            }
            case "WebsiteURL": {
                return Optional.ofNullable(clazz.cast(this.websiteURL()));
            }
            case "ContactLanguage": {
                return Optional.ofNullable(clazz.cast(this.contactLanguageAsString()));
            }
            case "UseCaseDescription": {
                return Optional.ofNullable(clazz.cast(this.useCaseDescription()));
            }
            case "AdditionalContactEmailAddresses": {
                return Optional.ofNullable(clazz.cast(this.additionalContactEmailAddresses()));
            }
            case "ReviewDetails": {
                return Optional.ofNullable(clazz.cast(this.reviewDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountDetails, T> g) {
        return obj -> g.apply((AccountDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mailType;
        private String websiteURL;
        private String contactLanguage;
        private String useCaseDescription;
        private List<String> additionalContactEmailAddresses = DefaultSdkAutoConstructList.getInstance();
        private ReviewDetails reviewDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountDetails model) {
            this.mailType(model.mailType);
            this.websiteURL(model.websiteURL);
            this.contactLanguage(model.contactLanguage);
            this.useCaseDescription(model.useCaseDescription);
            this.additionalContactEmailAddresses(model.additionalContactEmailAddresses);
            this.reviewDetails(model.reviewDetails);
        }

        public final String getMailType() {
            return this.mailType;
        }

        public final void setMailType(String mailType) {
            this.mailType = mailType;
        }

        @Override
        public final Builder mailType(String mailType) {
            this.mailType = mailType;
            return this;
        }

        @Override
        public final Builder mailType(MailType mailType) {
            this.mailType(mailType == null ? null : mailType.toString());
            return this;
        }

        public final String getWebsiteURL() {
            return this.websiteURL;
        }

        public final void setWebsiteURL(String websiteURL) {
            this.websiteURL = websiteURL;
        }

        @Override
        public final Builder websiteURL(String websiteURL) {
            this.websiteURL = websiteURL;
            return this;
        }

        public final String getContactLanguage() {
            return this.contactLanguage;
        }

        public final void setContactLanguage(String contactLanguage) {
            this.contactLanguage = contactLanguage;
        }

        @Override
        public final Builder contactLanguage(String contactLanguage) {
            this.contactLanguage = contactLanguage;
            return this;
        }

        @Override
        public final Builder contactLanguage(ContactLanguage contactLanguage) {
            this.contactLanguage(contactLanguage == null ? null : contactLanguage.toString());
            return this;
        }

        public final String getUseCaseDescription() {
            return this.useCaseDescription;
        }

        public final void setUseCaseDescription(String useCaseDescription) {
            this.useCaseDescription = useCaseDescription;
        }

        @Override
        public final Builder useCaseDescription(String useCaseDescription) {
            this.useCaseDescription = useCaseDescription;
            return this;
        }

        public final Collection<String> getAdditionalContactEmailAddresses() {
            if (this.additionalContactEmailAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalContactEmailAddresses;
        }

        public final void setAdditionalContactEmailAddresses(Collection<String> additionalContactEmailAddresses) {
            this.additionalContactEmailAddresses = AdditionalContactEmailAddressesCopier.copy(additionalContactEmailAddresses);
        }

        @Override
        public final Builder additionalContactEmailAddresses(Collection<String> additionalContactEmailAddresses) {
            this.additionalContactEmailAddresses = AdditionalContactEmailAddressesCopier.copy(additionalContactEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalContactEmailAddresses(String ... additionalContactEmailAddresses) {
            this.additionalContactEmailAddresses(Arrays.asList(additionalContactEmailAddresses));
            return this;
        }

        public final ReviewDetails.Builder getReviewDetails() {
            return this.reviewDetails != null ? this.reviewDetails.toBuilder() : null;
        }

        public final void setReviewDetails(ReviewDetails.BuilderImpl reviewDetails) {
            this.reviewDetails = reviewDetails != null ? reviewDetails.build() : null;
        }

        @Override
        public final Builder reviewDetails(ReviewDetails reviewDetails) {
            this.reviewDetails = reviewDetails;
            return this;
        }

        public AccountDetails build() {
            return new AccountDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountDetails> {
        public Builder mailType(String var1);

        public Builder mailType(MailType var1);

        public Builder websiteURL(String var1);

        public Builder contactLanguage(String var1);

        public Builder contactLanguage(ContactLanguage var1);

        public Builder useCaseDescription(String var1);

        public Builder additionalContactEmailAddresses(Collection<String> var1);

        public Builder additionalContactEmailAddresses(String ... var1);

        public Builder reviewDetails(ReviewDetails var1);

        default public Builder reviewDetails(Consumer<ReviewDetails.Builder> reviewDetails) {
            return this.reviewDetails((ReviewDetails)((ReviewDetails.Builder)ReviewDetails.builder().applyMutation(reviewDetails)).build());
        }
    }
}

