/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.Route;
import software.amazon.awssdk.services.sesv2.model.RoutesCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.services.sesv2.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMultiRegionEndpointResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, GetMultiRegionEndpointResponse> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(GetMultiRegionEndpointResponse.getter(GetMultiRegionEndpointResponse::endpointName)).setter(GetMultiRegionEndpointResponse.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(GetMultiRegionEndpointResponse.getter(GetMultiRegionEndpointResponse::endpointId)).setter(GetMultiRegionEndpointResponse.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<List<Route>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(GetMultiRegionEndpointResponse.getter(GetMultiRegionEndpointResponse::routes)).setter(GetMultiRegionEndpointResponse.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetMultiRegionEndpointResponse.getter(GetMultiRegionEndpointResponse::statusAsString)).setter(GetMultiRegionEndpointResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(GetMultiRegionEndpointResponse.getter(GetMultiRegionEndpointResponse::createdTimestamp)).setter(GetMultiRegionEndpointResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(GetMultiRegionEndpointResponse.getter(GetMultiRegionEndpointResponse::lastUpdatedTimestamp)).setter(GetMultiRegionEndpointResponse.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, ENDPOINT_ID_FIELD, ROUTES_FIELD, STATUS_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EndpointName", ENDPOINT_NAME_FIELD);
            this.put("EndpointId", ENDPOINT_ID_FIELD);
            this.put("Routes", ROUTES_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
            this.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        }
    });
    private final String endpointName;
    private final String endpointId;
    private final List<Route> routes;
    private final String status;
    private final Instant createdTimestamp;
    private final Instant lastUpdatedTimestamp;

    private GetMultiRegionEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.endpointId = builder.endpointId;
        this.routes = builder.routes;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<Route> routes() {
        return this.routes;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMultiRegionEndpointResponse)) {
            return false;
        }
        GetMultiRegionEndpointResponse other = (GetMultiRegionEndpointResponse)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.endpointId(), other.endpointId()) && this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetMultiRegionEndpointResponse").add("EndpointName", (Object)this.endpointName()).add("EndpointId", (Object)this.endpointId()).add("Routes", this.hasRoutes() ? this.routes() : null).add("Status", (Object)this.statusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMultiRegionEndpointResponse, T> g) {
        return obj -> g.apply((GetMultiRegionEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private String endpointName;
        private String endpointId;
        private List<Route> routes = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant createdTimestamp;
        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMultiRegionEndpointResponse model) {
            super(model);
            this.endpointName(model.endpointName);
            this.endpointId(model.endpointId);
            this.routes(model.routes);
            this.status(model.status);
            this.createdTimestamp(model.createdTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final List<Route.Builder> getRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<Route.BuilderImpl> routes) {
            this.routes = RoutesCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = RoutesCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<Route.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        @Override
        public GetMultiRegionEndpointResponse build() {
            return new GetMultiRegionEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMultiRegionEndpointResponse> {
        public Builder endpointName(String var1);

        public Builder endpointId(String var1);

        public Builder routes(Collection<Route> var1);

        public Builder routes(Route ... var1);

        public Builder routes(Consumer<Route.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);
    }
}

