/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an email identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityInfo implements SdkPojo, Serializable, ToCopyableBuilder<IdentityInfo.Builder, IdentityInfo> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(IdentityInfo::identityTypeAsString)).setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()).build();

    private static final SdkField<String> IDENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityName").getter(getter(IdentityInfo::identityName)).setter(setter(Builder::identityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityName").build()).build();

    private static final SdkField<Boolean> SENDING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SendingEnabled").getter(getter(IdentityInfo::sendingEnabled)).setter(setter(Builder::sendingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingEnabled").build()).build();

    private static final SdkField<String> VERIFICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerificationStatus").getter(getter(IdentityInfo::verificationStatusAsString))
            .setter(setter(Builder::verificationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD,
            IDENTITY_NAME_FIELD, SENDING_ENABLED_FIELD, VERIFICATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IdentityType", IDENTITY_TYPE_FIELD);
                    put("IdentityName", IDENTITY_NAME_FIELD);
                    put("SendingEnabled", SENDING_ENABLED_FIELD);
                    put("VerificationStatus", VERIFICATION_STATUS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String identityType;

    private final String identityName;

    private final Boolean sendingEnabled;

    private final String verificationStatus;

    private IdentityInfo(BuilderImpl builder) {
        this.identityType = builder.identityType;
        this.identityName = builder.identityName;
        this.sendingEnabled = builder.sendingEnabled;
        this.verificationStatus = builder.verificationStatus;
    }

    /**
     * <p>
     * The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported for email identity types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported for email identity
     *         types.
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported for email identity types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported for email identity
     *         types.
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The address or domain of the identity.
     * </p>
     * 
     * @return The address or domain of the identity.
     */
    public final String identityName() {
        return identityName;
    }

    /**
     * <p>
     * Indicates whether or not you can send email from the identity.
     * </p>
     * <p>
     * An <i>identity</i> is an email address or domain that you send email from. Before you can send email from an
     * identity, you have to demostrate that you own the identity, and that you authorize Amazon SES to send email from
     * that identity.
     * </p>
     * 
     * @return Indicates whether or not you can send email from the identity.</p>
     *         <p>
     *         An <i>identity</i> is an email address or domain that you send email from. Before you can send email from
     *         an identity, you have to demostrate that you own the identity, and that you authorize Amazon SES to send
     *         email from that identity.
     */
    public final Boolean sendingEnabled() {
        return sendingEnabled;
    }

    /**
     * <p>
     * The verification status of the identity. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to verify the
     * identity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – The verification process completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – The verification process failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the verification
     * status of the identity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verificationStatus} will return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #verificationStatusAsString}.
     * </p>
     * 
     * @return The verification status of the identity. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to
     *         verify the identity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – The verification process completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – The verification process failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the
     *         verification status of the identity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
     *         </p>
     *         </li>
     * @see VerificationStatus
     */
    public final VerificationStatus verificationStatus() {
        return VerificationStatus.fromValue(verificationStatus);
    }

    /**
     * <p>
     * The verification status of the identity. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to verify the
     * identity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – The verification process completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – The verification process failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the verification
     * status of the identity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verificationStatus} will return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #verificationStatusAsString}.
     * </p>
     * 
     * @return The verification status of the identity. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to
     *         verify the identity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – The verification process completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – The verification process failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the
     *         verification status of the identity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
     *         </p>
     *         </li>
     * @see VerificationStatus
     */
    public final String verificationStatusAsString() {
        return verificationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityName());
        hashCode = 31 * hashCode + Objects.hashCode(sendingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityInfo)) {
            return false;
        }
        IdentityInfo other = (IdentityInfo) obj;
        return Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(identityName(), other.identityName())
                && Objects.equals(sendingEnabled(), other.sendingEnabled())
                && Objects.equals(verificationStatusAsString(), other.verificationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityInfo").add("IdentityType", identityTypeAsString()).add("IdentityName", identityName())
                .add("SendingEnabled", sendingEnabled()).add("VerificationStatus", verificationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "IdentityName":
            return Optional.ofNullable(clazz.cast(identityName()));
        case "SendingEnabled":
            return Optional.ofNullable(clazz.cast(sendingEnabled()));
        case "VerificationStatus":
            return Optional.ofNullable(clazz.cast(verificationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IdentityInfo, T> g) {
        return obj -> g.apply((IdentityInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityInfo> {
        /**
         * <p>
         * The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported for email identity
         * types.
         * </p>
         * 
         * @param identityType
         *        The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported for email
         *        identity types.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported for email identity
         * types.
         * </p>
         * 
         * @param identityType
         *        The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported for email
         *        identity types.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The address or domain of the identity.
         * </p>
         * 
         * @param identityName
         *        The address or domain of the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityName(String identityName);

        /**
         * <p>
         * Indicates whether or not you can send email from the identity.
         * </p>
         * <p>
         * An <i>identity</i> is an email address or domain that you send email from. Before you can send email from an
         * identity, you have to demostrate that you own the identity, and that you authorize Amazon SES to send email
         * from that identity.
         * </p>
         * 
         * @param sendingEnabled
         *        Indicates whether or not you can send email from the identity.</p>
         *        <p>
         *        An <i>identity</i> is an email address or domain that you send email from. Before you can send email
         *        from an identity, you have to demostrate that you own the identity, and that you authorize Amazon SES
         *        to send email from that identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingEnabled(Boolean sendingEnabled);

        /**
         * <p>
         * The verification status of the identity. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to verify
         * the identity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – The verification process completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – The verification process failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the verification
         * status of the identity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param verificationStatus
         *        The verification status of the identity. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to
         *        verify the identity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – The verification process completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – The verification process failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the
         *        verification status of the identity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
         *        </p>
         *        </li>
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder verificationStatus(String verificationStatus);

        /**
         * <p>
         * The verification status of the identity. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to verify
         * the identity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – The verification process completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – The verification process failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the verification
         * status of the identity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param verificationStatus
         *        The verification status of the identity. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet been able to
         *        verify the identity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – The verification process completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – The verification process failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the
         *        verification status of the identity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_STARTED</code> – The verification process hasn't been initiated for the identity.
         *        </p>
         *        </li>
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder verificationStatus(VerificationStatus verificationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String identityType;

        private String identityName;

        private Boolean sendingEnabled;

        private String verificationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityInfo model) {
            identityType(model.identityType);
            identityName(model.identityName);
            sendingEnabled(model.sendingEnabled);
            verificationStatus(model.verificationStatus);
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final String getIdentityName() {
            return identityName;
        }

        public final void setIdentityName(String identityName) {
            this.identityName = identityName;
        }

        @Override
        public final Builder identityName(String identityName) {
            this.identityName = identityName;
            return this;
        }

        public final Boolean getSendingEnabled() {
            return sendingEnabled;
        }

        public final void setSendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
        }

        @Override
        public final Builder sendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
            return this;
        }

        public final String getVerificationStatus() {
            return verificationStatus;
        }

        public final void setVerificationStatus(String verificationStatus) {
            this.verificationStatus = verificationStatus;
        }

        @Override
        public final Builder verificationStatus(String verificationStatus) {
            this.verificationStatus = verificationStatus;
            return this;
        }

        @Override
        public final Builder verificationStatus(VerificationStatus verificationStatus) {
            this.verificationStatus(verificationStatus == null ? null : verificationStatus.toString());
            return this;
        }

        @Override
        public IdentityInfo build() {
            return new IdentityInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
