/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing additional settings for your VDM configuration as applicable to the Guardian.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardianAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardianAttributes.Builder, GuardianAttributes> {
    private static final SdkField<String> OPTIMIZED_SHARED_DELIVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizedSharedDelivery").getter(getter(GuardianAttributes::optimizedSharedDeliveryAsString))
            .setter(setter(Builder::optimizedSharedDelivery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizedSharedDelivery").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(OPTIMIZED_SHARED_DELIVERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("OptimizedSharedDelivery", OPTIMIZED_SHARED_DELIVERY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String optimizedSharedDelivery;

    private GuardianAttributes(BuilderImpl builder) {
        this.optimizedSharedDelivery = builder.optimizedSharedDelivery;
    }

    /**
     * <p>
     * Specifies the status of your VDM optimized shared delivery. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – Amazon SES enables optimized shared delivery for your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – Amazon SES disables optimized shared delivery for your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizedSharedDelivery} will return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizedSharedDeliveryAsString}.
     * </p>
     * 
     * @return Specifies the status of your VDM optimized shared delivery. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – Amazon SES enables optimized shared delivery for your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – Amazon SES disables optimized shared delivery for your account.
     *         </p>
     *         </li>
     * @see FeatureStatus
     */
    public final FeatureStatus optimizedSharedDelivery() {
        return FeatureStatus.fromValue(optimizedSharedDelivery);
    }

    /**
     * <p>
     * Specifies the status of your VDM optimized shared delivery. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – Amazon SES enables optimized shared delivery for your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – Amazon SES disables optimized shared delivery for your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizedSharedDelivery} will return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizedSharedDeliveryAsString}.
     * </p>
     * 
     * @return Specifies the status of your VDM optimized shared delivery. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – Amazon SES enables optimized shared delivery for your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – Amazon SES disables optimized shared delivery for your account.
     *         </p>
     *         </li>
     * @see FeatureStatus
     */
    public final String optimizedSharedDeliveryAsString() {
        return optimizedSharedDelivery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optimizedSharedDeliveryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardianAttributes)) {
            return false;
        }
        GuardianAttributes other = (GuardianAttributes) obj;
        return Objects.equals(optimizedSharedDeliveryAsString(), other.optimizedSharedDeliveryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardianAttributes").add("OptimizedSharedDelivery", optimizedSharedDeliveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptimizedSharedDelivery":
            return Optional.ofNullable(clazz.cast(optimizedSharedDeliveryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardianAttributes, T> g) {
        return obj -> g.apply((GuardianAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardianAttributes> {
        /**
         * <p>
         * Specifies the status of your VDM optimized shared delivery. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – Amazon SES enables optimized shared delivery for your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – Amazon SES disables optimized shared delivery for your account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param optimizedSharedDelivery
         *        Specifies the status of your VDM optimized shared delivery. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – Amazon SES enables optimized shared delivery for your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – Amazon SES disables optimized shared delivery for your account.
         *        </p>
         *        </li>
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder optimizedSharedDelivery(String optimizedSharedDelivery);

        /**
         * <p>
         * Specifies the status of your VDM optimized shared delivery. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – Amazon SES enables optimized shared delivery for your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – Amazon SES disables optimized shared delivery for your account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param optimizedSharedDelivery
         *        Specifies the status of your VDM optimized shared delivery. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – Amazon SES enables optimized shared delivery for your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – Amazon SES disables optimized shared delivery for your account.
         *        </p>
         *        </li>
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder optimizedSharedDelivery(FeatureStatus optimizedSharedDelivery);
    }

    static final class BuilderImpl implements Builder {
        private String optimizedSharedDelivery;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardianAttributes model) {
            optimizedSharedDelivery(model.optimizedSharedDelivery);
        }

        public final String getOptimizedSharedDelivery() {
            return optimizedSharedDelivery;
        }

        public final void setOptimizedSharedDelivery(String optimizedSharedDelivery) {
            this.optimizedSharedDelivery = optimizedSharedDelivery;
        }

        @Override
        public final Builder optimizedSharedDelivery(String optimizedSharedDelivery) {
            this.optimizedSharedDelivery = optimizedSharedDelivery;
            return this;
        }

        @Override
        public final Builder optimizedSharedDelivery(FeatureStatus optimizedSharedDelivery) {
            this.optimizedSharedDelivery(optimizedSharedDelivery == null ? null : optimizedSharedDelivery.toString());
            return this;
        }

        @Override
        public GuardianAttributes build() {
            return new GuardianAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
