/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains a mapping between a <code>Metric</code> and <code>MetricAggregation</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportMetric implements SdkPojo, Serializable, ToCopyableBuilder<ExportMetric.Builder, ExportMetric> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ExportMetric::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> AGGREGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Aggregation").getter(getter(ExportMetric::aggregationAsString)).setter(setter(Builder::aggregation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NAME_FIELD, AGGREGATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Aggregation", AGGREGATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String aggregation;

    private ExportMetric(BuilderImpl builder) {
        this.name = builder.name;
        this.aggregation = builder.aggregation;
    }

    /**
     * Returns the value of the Name property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link Metric#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The value of the Name property for this object.
     * @see Metric
     */
    public final Metric name() {
        return Metric.fromValue(name);
    }

    /**
     * Returns the value of the Name property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link Metric#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The value of the Name property for this object.
     * @see Metric
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * Returns the value of the Aggregation property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link MetricAggregation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The value of the Aggregation property for this object.
     * @see MetricAggregation
     */
    public final MetricAggregation aggregation() {
        return MetricAggregation.fromValue(aggregation);
    }

    /**
     * Returns the value of the Aggregation property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregation} will
     * return {@link MetricAggregation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aggregationAsString}.
     * </p>
     * 
     * @return The value of the Aggregation property for this object.
     * @see MetricAggregation
     */
    public final String aggregationAsString() {
        return aggregation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportMetric)) {
            return false;
        }
        ExportMetric other = (ExportMetric) obj;
        return Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(aggregationAsString(), other.aggregationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportMetric").add("Name", nameAsString()).add("Aggregation", aggregationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Aggregation":
            return Optional.ofNullable(clazz.cast(aggregationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExportMetric, T> g) {
        return obj -> g.apply((ExportMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportMetric> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @see Metric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Metric
         */
        Builder name(String name);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @see Metric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Metric
         */
        Builder name(Metric name);

        /**
         * Sets the value of the Aggregation property for this object.
         *
         * @param aggregation
         *        The new value for the Aggregation property for this object.
         * @see MetricAggregation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricAggregation
         */
        Builder aggregation(String aggregation);

        /**
         * Sets the value of the Aggregation property for this object.
         *
         * @param aggregation
         *        The new value for the Aggregation property for this object.
         * @see MetricAggregation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricAggregation
         */
        Builder aggregation(MetricAggregation aggregation);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String aggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportMetric model) {
            name(model.name);
            aggregation(model.aggregation);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(Metric name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getAggregation() {
            return aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(MetricAggregation aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        @Override
        public ExportMetric build() {
            return new ExportMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
