/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse;

public class GetDedicatedIpsPublisher
implements SdkPublisher<GetDedicatedIpsResponse> {
    private final SesV2AsyncClient client;
    private final GetDedicatedIpsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDedicatedIpsPublisher(SesV2AsyncClient client, GetDedicatedIpsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDedicatedIpsPublisher(SesV2AsyncClient client, GetDedicatedIpsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDedicatedIpsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDedicatedIpsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetDedicatedIpsResponseFetcher
    implements AsyncPageFetcher<GetDedicatedIpsResponse> {
        private GetDedicatedIpsResponseFetcher() {
        }

        public boolean hasNextPage(GetDedicatedIpsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetDedicatedIpsResponse> nextPage(GetDedicatedIpsResponse previousPage) {
            if (previousPage == null) {
                return GetDedicatedIpsPublisher.this.client.getDedicatedIps(GetDedicatedIpsPublisher.this.firstRequest);
            }
            return GetDedicatedIpsPublisher.this.client.getDedicatedIps((GetDedicatedIpsRequest)((Object)GetDedicatedIpsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

