/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BulkEmailEntry implements SdkPojo, Serializable, ToCopyableBuilder<BulkEmailEntry.Builder, BulkEmailEntry> {
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("Destination").getter(getter(BulkEmailEntry::destination)).setter(setter(Builder::destination))
            .constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<List<MessageTag>> REPLACEMENT_TAGS_FIELD = SdkField
            .<List<MessageTag>> builder(MarshallingType.LIST)
            .memberName("ReplacementTags")
            .getter(getter(BulkEmailEntry::replacementTags))
            .setter(setter(Builder::replacementTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ReplacementEmailContent> REPLACEMENT_EMAIL_CONTENT_FIELD = SdkField
            .<ReplacementEmailContent> builder(MarshallingType.SDK_POJO).memberName("ReplacementEmailContent")
            .getter(getter(BulkEmailEntry::replacementEmailContent)).setter(setter(Builder::replacementEmailContent))
            .constructor(ReplacementEmailContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementEmailContent").build())
            .build();

    private static final SdkField<List<MessageHeader>> REPLACEMENT_HEADERS_FIELD = SdkField
            .<List<MessageHeader>> builder(MarshallingType.LIST)
            .memberName("ReplacementHeaders")
            .getter(getter(BulkEmailEntry::replacementHeaders))
            .setter(setter(Builder::replacementHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            REPLACEMENT_TAGS_FIELD, REPLACEMENT_EMAIL_CONTENT_FIELD, REPLACEMENT_HEADERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Destination destination;

    private final List<MessageTag> replacementTags;

    private final ReplacementEmailContent replacementEmailContent;

    private final List<MessageHeader> replacementHeaders;

    private BulkEmailEntry(BuilderImpl builder) {
        this.destination = builder.destination;
        this.replacementTags = builder.replacementTags;
        this.replacementEmailContent = builder.replacementEmailContent;
        this.replacementHeaders = builder.replacementHeaders;
    }

    /**
     * <p>
     * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
     * </p>
     * <note>
     * <p>
     * Amazon SES does not support the SMTPUTF8 extension, as described in <a
     * href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a destination email
     * address (the part of the email address that precedes the @ sign) may only contain <a
     * href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the domain part of
     * an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as
     * described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.
     * </p>
     * </note>
     * 
     * @return Represents the destination of the message, consisting of To:, CC:, and BCC: fields.</p> <note>
     *         <p>
     *         Amazon SES does not support the SMTPUTF8 extension, as described in <a
     *         href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a destination
     *         email address (the part of the email address that precedes the @ sign) may only contain <a
     *         href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the domain
     *         part of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using
     *         Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.
     *         </p>
     */
    public final Destination destination() {
        return destination;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplacementTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplacementTags() {
        return replacementTags != null && !(replacementTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
     * <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you define,
     * so that you can publish email sending events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplacementTags} method.
     * </p>
     * 
     * @return A list of tags, in the form of name/value pairs, to apply to an email that you send using the
     *         <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you
     *         define, so that you can publish email sending events.
     */
    public final List<MessageTag> replacementTags() {
        return replacementTags;
    }

    /**
     * <p>
     * The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.
     * </p>
     * 
     * @return The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.
     */
    public final ReplacementEmailContent replacementEmailContent() {
        return replacementEmailContent;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplacementHeaders property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplacementHeaders() {
        return replacementHeaders != null && !(replacementHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of message headers associated with the <code>BulkEmailEntry</code> data type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Headers Not Present in <code>BulkEmailEntry</code>: If a header is specified in <a
     * href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code> </a> but
     * not in <code>BulkEmailEntry</code>, the header from <code>Template</code> will be added to the outgoing email.
     * </p>
     * </li>
     * <li>
     * <p>
     * Headers Present in <code>BulkEmailEntry</code>: If a header is specified in <code>BulkEmailEntry</code>, it takes
     * precedence over any header of the same name specified in <a
     * href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code> </a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the header is also defined within <code>Template</code>, the value from <code>BulkEmailEntry</code> will
     * replace the header's value in the email.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the header is not defined within <code>Template</code>, it will simply be added to the email as specified in
     * <code>BulkEmailEntry</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplacementHeaders} method.
     * </p>
     * 
     * @return The list of message headers associated with the <code>BulkEmailEntry</code> data type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Headers Not Present in <code>BulkEmailEntry</code>: If a header is specified in <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code>
     *         </a> but not in <code>BulkEmailEntry</code>, the header from <code>Template</code> will be added to the
     *         outgoing email.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Headers Present in <code>BulkEmailEntry</code>: If a header is specified in <code>BulkEmailEntry</code>,
     *         it takes precedence over any header of the same name specified in <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code>
     *         </a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the header is also defined within <code>Template</code>, the value from <code>BulkEmailEntry</code>
     *         will replace the header's value in the email.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the header is not defined within <code>Template</code>, it will simply be added to the email as
     *         specified in <code>BulkEmailEntry</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final List<MessageHeader> replacementHeaders() {
        return replacementHeaders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplacementTags() ? replacementTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replacementEmailContent());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplacementHeaders() ? replacementHeaders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailEntry)) {
            return false;
        }
        BulkEmailEntry other = (BulkEmailEntry) obj;
        return Objects.equals(destination(), other.destination()) && hasReplacementTags() == other.hasReplacementTags()
                && Objects.equals(replacementTags(), other.replacementTags())
                && Objects.equals(replacementEmailContent(), other.replacementEmailContent())
                && hasReplacementHeaders() == other.hasReplacementHeaders()
                && Objects.equals(replacementHeaders(), other.replacementHeaders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BulkEmailEntry").add("Destination", destination())
                .add("ReplacementTags", hasReplacementTags() ? replacementTags() : null)
                .add("ReplacementEmailContent", replacementEmailContent())
                .add("ReplacementHeaders", hasReplacementHeaders() ? replacementHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "ReplacementTags":
            return Optional.ofNullable(clazz.cast(replacementTags()));
        case "ReplacementEmailContent":
            return Optional.ofNullable(clazz.cast(replacementEmailContent()));
        case "ReplacementHeaders":
            return Optional.ofNullable(clazz.cast(replacementHeaders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkEmailEntry, T> g) {
        return obj -> g.apply((BulkEmailEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BulkEmailEntry> {
        /**
         * <p>
         * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
         * </p>
         * <note>
         * <p>
         * Amazon SES does not support the SMTPUTF8 extension, as described in <a
         * href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a destination
         * email address (the part of the email address that precedes the @ sign) may only contain <a
         * href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the domain part
         * of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode,
         * as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.
         * </p>
         * </note>
         * 
         * @param destination
         *        Represents the destination of the message, consisting of To:, CC:, and BCC: fields.</p> <note>
         *        <p>
         *        Amazon SES does not support the SMTPUTF8 extension, as described in <a
         *        href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a
         *        destination email address (the part of the email address that precedes the @ sign) may only contain <a
         *        href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the
         *        domain part of an address (the part after the @ sign) contains non-ASCII characters, they must be
         *        encoded using Punycode, as described in <a
         *        href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
         * </p>
         * <note>
         * <p>
         * Amazon SES does not support the SMTPUTF8 extension, as described in <a
         * href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a destination
         * email address (the part of the email address that precedes the @ sign) may only contain <a
         * href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the domain part
         * of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode,
         * as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the
         * need to create one manually via {@link Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         * <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you
         * define, so that you can publish email sending events.
         * </p>
         * 
         * @param replacementTags
         *        A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         *        <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that
         *        you define, so that you can publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTags(Collection<MessageTag> replacementTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         * <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you
         * define, so that you can publish email sending events.
         * </p>
         * 
         * @param replacementTags
         *        A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         *        <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that
         *        you define, so that you can publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTags(MessageTag... replacementTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         * <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you
         * define, so that you can publish email sending events.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.MessageTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.MessageTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.MessageTag.Builder#build()} is called immediately and its
         * result is passed to {@link #replacementTags(List<MessageTag>)}.
         * 
         * @param replacementTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.MessageTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replacementTags(java.util.Collection<MessageTag>)
         */
        Builder replacementTags(Consumer<MessageTag.Builder>... replacementTags);

        /**
         * <p>
         * The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.
         * </p>
         * 
         * @param replacementEmailContent
         *        The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementEmailContent(ReplacementEmailContent replacementEmailContent);

        /**
         * <p>
         * The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplacementEmailContent.Builder} avoiding
         * the need to create one manually via {@link ReplacementEmailContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplacementEmailContent.Builder#build()} is called immediately
         * and its result is passed to {@link #replacementEmailContent(ReplacementEmailContent)}.
         * 
         * @param replacementEmailContent
         *        a consumer that will call methods on {@link ReplacementEmailContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replacementEmailContent(ReplacementEmailContent)
         */
        default Builder replacementEmailContent(Consumer<ReplacementEmailContent.Builder> replacementEmailContent) {
            return replacementEmailContent(ReplacementEmailContent.builder().applyMutation(replacementEmailContent).build());
        }

        /**
         * <p>
         * The list of message headers associated with the <code>BulkEmailEntry</code> data type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Headers Not Present in <code>BulkEmailEntry</code>: If a header is specified in <a
         * href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code> </a>
         * but not in <code>BulkEmailEntry</code>, the header from <code>Template</code> will be added to the outgoing
         * email.
         * </p>
         * </li>
         * <li>
         * <p>
         * Headers Present in <code>BulkEmailEntry</code>: If a header is specified in <code>BulkEmailEntry</code>, it
         * takes precedence over any header of the same name specified in <a
         * href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code> </a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the header is also defined within <code>Template</code>, the value from <code>BulkEmailEntry</code> will
         * replace the header's value in the email.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the header is not defined within <code>Template</code>, it will simply be added to the email as specified
         * in <code>BulkEmailEntry</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param replacementHeaders
         *        The list of message headers associated with the <code>BulkEmailEntry</code> data type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Headers Not Present in <code>BulkEmailEntry</code>: If a header is specified in <a
         *        href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code>
         *        </a> but not in <code>BulkEmailEntry</code>, the header from <code>Template</code> will be added to
         *        the outgoing email.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Headers Present in <code>BulkEmailEntry</code>: If a header is specified in
         *        <code>BulkEmailEntry</code>, it takes precedence over any header of the same name specified in <a
         *        href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code>
         *        </a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the header is also defined within <code>Template</code>, the value from <code>BulkEmailEntry</code>
         *        will replace the header's value in the email.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the header is not defined within <code>Template</code>, it will simply be added to the email as
         *        specified in <code>BulkEmailEntry</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementHeaders(Collection<MessageHeader> replacementHeaders);

        /**
         * <p>
         * The list of message headers associated with the <code>BulkEmailEntry</code> data type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Headers Not Present in <code>BulkEmailEntry</code>: If a header is specified in <a
         * href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code> </a>
         * but not in <code>BulkEmailEntry</code>, the header from <code>Template</code> will be added to the outgoing
         * email.
         * </p>
         * </li>
         * <li>
         * <p>
         * Headers Present in <code>BulkEmailEntry</code>: If a header is specified in <code>BulkEmailEntry</code>, it
         * takes precedence over any header of the same name specified in <a
         * href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code> </a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the header is also defined within <code>Template</code>, the value from <code>BulkEmailEntry</code> will
         * replace the header's value in the email.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the header is not defined within <code>Template</code>, it will simply be added to the email as specified
         * in <code>BulkEmailEntry</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param replacementHeaders
         *        The list of message headers associated with the <code>BulkEmailEntry</code> data type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Headers Not Present in <code>BulkEmailEntry</code>: If a header is specified in <a
         *        href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code>
         *        </a> but not in <code>BulkEmailEntry</code>, the header from <code>Template</code> will be added to
         *        the outgoing email.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Headers Present in <code>BulkEmailEntry</code>: If a header is specified in
         *        <code>BulkEmailEntry</code>, it takes precedence over any header of the same name specified in <a
         *        href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code>
         *        </a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the header is also defined within <code>Template</code>, the value from <code>BulkEmailEntry</code>
         *        will replace the header's value in the email.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the header is not defined within <code>Template</code>, it will simply be added to the email as
         *        specified in <code>BulkEmailEntry</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementHeaders(MessageHeader... replacementHeaders);

        /**
         * <p>
         * The list of message headers associated with the <code>BulkEmailEntry</code> data type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Headers Not Present in <code>BulkEmailEntry</code>: If a header is specified in <a
         * href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code> </a>
         * but not in <code>BulkEmailEntry</code>, the header from <code>Template</code> will be added to the outgoing
         * email.
         * </p>
         * </li>
         * <li>
         * <p>
         * Headers Present in <code>BulkEmailEntry</code>: If a header is specified in <code>BulkEmailEntry</code>, it
         * takes precedence over any header of the same name specified in <a
         * href="https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html"> <code>Template</code> </a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the header is also defined within <code>Template</code>, the value from <code>BulkEmailEntry</code> will
         * replace the header's value in the email.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the header is not defined within <code>Template</code>, it will simply be added to the email as specified
         * in <code>BulkEmailEntry</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.MessageHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.MessageHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.MessageHeader.Builder#build()} is called immediately and
         * its result is passed to {@link #replacementHeaders(List<MessageHeader>)}.
         * 
         * @param replacementHeaders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.MessageHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replacementHeaders(java.util.Collection<MessageHeader>)
         */
        Builder replacementHeaders(Consumer<MessageHeader.Builder>... replacementHeaders);
    }

    static final class BuilderImpl implements Builder {
        private Destination destination;

        private List<MessageTag> replacementTags = DefaultSdkAutoConstructList.getInstance();

        private ReplacementEmailContent replacementEmailContent;

        private List<MessageHeader> replacementHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BulkEmailEntry model) {
            destination(model.destination);
            replacementTags(model.replacementTags);
            replacementEmailContent(model.replacementEmailContent);
            replacementHeaders(model.replacementHeaders);
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final List<MessageTag.Builder> getReplacementTags() {
            List<MessageTag.Builder> result = MessageTagListCopier.copyToBuilder(this.replacementTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplacementTags(Collection<MessageTag.BuilderImpl> replacementTags) {
            this.replacementTags = MessageTagListCopier.copyFromBuilder(replacementTags);
        }

        @Override
        public final Builder replacementTags(Collection<MessageTag> replacementTags) {
            this.replacementTags = MessageTagListCopier.copy(replacementTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementTags(MessageTag... replacementTags) {
            replacementTags(Arrays.asList(replacementTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementTags(Consumer<MessageTag.Builder>... replacementTags) {
            replacementTags(Stream.of(replacementTags).map(c -> MessageTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ReplacementEmailContent.Builder getReplacementEmailContent() {
            return replacementEmailContent != null ? replacementEmailContent.toBuilder() : null;
        }

        public final void setReplacementEmailContent(ReplacementEmailContent.BuilderImpl replacementEmailContent) {
            this.replacementEmailContent = replacementEmailContent != null ? replacementEmailContent.build() : null;
        }

        @Override
        public final Builder replacementEmailContent(ReplacementEmailContent replacementEmailContent) {
            this.replacementEmailContent = replacementEmailContent;
            return this;
        }

        public final List<MessageHeader.Builder> getReplacementHeaders() {
            List<MessageHeader.Builder> result = MessageHeaderListCopier.copyToBuilder(this.replacementHeaders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplacementHeaders(Collection<MessageHeader.BuilderImpl> replacementHeaders) {
            this.replacementHeaders = MessageHeaderListCopier.copyFromBuilder(replacementHeaders);
        }

        @Override
        public final Builder replacementHeaders(Collection<MessageHeader> replacementHeaders) {
            this.replacementHeaders = MessageHeaderListCopier.copy(replacementHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementHeaders(MessageHeader... replacementHeaders) {
            replacementHeaders(Arrays.asList(replacementHeaders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementHeaders(Consumer<MessageHeader.Builder>... replacementHeaders) {
            replacementHeaders(Stream.of(replacementHeaders).map(c -> MessageHeader.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BulkEmailEntry build() {
            return new BulkEmailEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
