/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommendationType {
    DKIM("DKIM"),
    DMARC("DMARC"),
    SPF("SPF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommendationType> VALUE_MAP;
    private final String value;

    private RecommendationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationType> knownValues() {
        EnumSet<RecommendationType> knownValues = EnumSet.allOf(RecommendationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommendationType.class, RecommendationType::toString);
    }
}

