/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to move a dedicated IP address to a dedicated IP pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDedicatedIpInPoolRequest extends SesV2Request implements
        ToCopyableBuilder<PutDedicatedIpInPoolRequest.Builder, PutDedicatedIpInPoolRequest> {
    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ip")
            .getter(getter(PutDedicatedIpInPoolRequest::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IP").build()).build();

    private static final SdkField<String> DESTINATION_POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPoolName").getter(getter(PutDedicatedIpInPoolRequest::destinationPoolName))
            .setter(setter(Builder::destinationPoolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPoolName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD,
            DESTINATION_POOL_NAME_FIELD));

    private final String ip;

    private final String destinationPoolName;

    private PutDedicatedIpInPoolRequest(BuilderImpl builder) {
        super(builder);
        this.ip = builder.ip;
        this.destinationPoolName = builder.destinationPoolName;
    }

    /**
     * <p>
     * The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP
     * address that's associated with your Amazon Web Services account.
     * </p>
     * 
     * @return The IP address that you want to move to the dedicated IP pool. The value you specify has to be a
     *         dedicated IP address that's associated with your Amazon Web Services account.
     */
    public final String ip() {
        return ip;
    }

    /**
     * <p>
     * The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that
     * already exists.
     * </p>
     * 
     * @return The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool
     *         that already exists.
     */
    public final String destinationPoolName() {
        return destinationPoolName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPoolName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDedicatedIpInPoolRequest)) {
            return false;
        }
        PutDedicatedIpInPoolRequest other = (PutDedicatedIpInPoolRequest) obj;
        return Objects.equals(ip(), other.ip()) && Objects.equals(destinationPoolName(), other.destinationPoolName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDedicatedIpInPoolRequest").add("Ip", ip()).add("DestinationPoolName", destinationPoolName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "DestinationPoolName":
            return Optional.ofNullable(clazz.cast(destinationPoolName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDedicatedIpInPoolRequest, T> g) {
        return obj -> g.apply((PutDedicatedIpInPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, PutDedicatedIpInPoolRequest> {
        /**
         * <p>
         * The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP
         * address that's associated with your Amazon Web Services account.
         * </p>
         * 
         * @param ip
         *        The IP address that you want to move to the dedicated IP pool. The value you specify has to be a
         *        dedicated IP address that's associated with your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * <p>
         * The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that
         * already exists.
         * </p>
         * 
         * @param destinationPoolName
         *        The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP
         *        pool that already exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPoolName(String destinationPoolName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String ip;

        private String destinationPoolName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDedicatedIpInPoolRequest model) {
            super(model);
            ip(model.ip);
            destinationPoolName(model.destinationPoolName);
        }

        public final String getIp() {
            return ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        @Transient
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final String getDestinationPoolName() {
            return destinationPoolName;
        }

        public final void setDestinationPoolName(String destinationPoolName) {
            this.destinationPoolName = destinationPoolName;
        }

        @Override
        @Transient
        public final Builder destinationPoolName(String destinationPoolName) {
            this.destinationPoolName = destinationPoolName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDedicatedIpInPoolRequest build() {
            return new PutDedicatedIpInPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
