/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MailType {
    MARKETING("MARKETING"),
    TRANSACTIONAL("TRANSACTIONAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MailType> VALUE_MAP;
    private final String value;

    private MailType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MailType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MailType> knownValues() {
        EnumSet<MailType> knownValues = EnumSet.allOf(MailType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MailType.class, MailType::toString);
    }
}

