/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.TopicPreference;
import software.amazon.awssdk.services.sesv2.model.TopicPreferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Contact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Contact> {
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(Contact.getter(Contact::emailAddress)).setter(Contact.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<List<TopicPreference>> TOPIC_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopicPreferences").getter(Contact.getter(Contact::topicPreferences)).setter(Contact.setter(Builder::topicPreferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicPreferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TopicPreference>> TOPIC_DEFAULT_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopicDefaultPreferences").getter(Contact.getter(Contact::topicDefaultPreferences)).setter(Contact.setter(Builder::topicDefaultPreferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicDefaultPreferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> UNSUBSCRIBE_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UnsubscribeAll").getter(Contact.getter(Contact::unsubscribeAll)).setter(Contact.setter(Builder::unsubscribeAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsubscribeAll").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(Contact.getter(Contact::lastUpdatedTimestamp)).setter(Contact.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_FIELD, TOPIC_PREFERENCES_FIELD, TOPIC_DEFAULT_PREFERENCES_FIELD, UNSUBSCRIBE_ALL_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String emailAddress;
    private final List<TopicPreference> topicPreferences;
    private final List<TopicPreference> topicDefaultPreferences;
    private final Boolean unsubscribeAll;
    private final Instant lastUpdatedTimestamp;

    private Contact(BuilderImpl builder) {
        this.emailAddress = builder.emailAddress;
        this.topicPreferences = builder.topicPreferences;
        this.topicDefaultPreferences = builder.topicDefaultPreferences;
        this.unsubscribeAll = builder.unsubscribeAll;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final boolean hasTopicPreferences() {
        return this.topicPreferences != null && !(this.topicPreferences instanceof SdkAutoConstructList);
    }

    public final List<TopicPreference> topicPreferences() {
        return this.topicPreferences;
    }

    public final boolean hasTopicDefaultPreferences() {
        return this.topicDefaultPreferences != null && !(this.topicDefaultPreferences instanceof SdkAutoConstructList);
    }

    public final List<TopicPreference> topicDefaultPreferences() {
        return this.topicDefaultPreferences;
    }

    public final Boolean unsubscribeAll() {
        return this.unsubscribeAll;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicPreferences() ? this.topicPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicDefaultPreferences() ? this.topicDefaultPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.unsubscribeAll());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Contact)) {
            return false;
        }
        Contact other = (Contact)obj;
        return Objects.equals(this.emailAddress(), other.emailAddress()) && this.hasTopicPreferences() == other.hasTopicPreferences() && Objects.equals(this.topicPreferences(), other.topicPreferences()) && this.hasTopicDefaultPreferences() == other.hasTopicDefaultPreferences() && Objects.equals(this.topicDefaultPreferences(), other.topicDefaultPreferences()) && Objects.equals(this.unsubscribeAll(), other.unsubscribeAll()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"Contact").add("EmailAddress", (Object)this.emailAddress()).add("TopicPreferences", this.hasTopicPreferences() ? this.topicPreferences() : null).add("TopicDefaultPreferences", this.hasTopicDefaultPreferences() ? this.topicDefaultPreferences() : null).add("UnsubscribeAll", (Object)this.unsubscribeAll()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "TopicPreferences": {
                return Optional.ofNullable(clazz.cast(this.topicPreferences()));
            }
            case "TopicDefaultPreferences": {
                return Optional.ofNullable(clazz.cast(this.topicDefaultPreferences()));
            }
            case "UnsubscribeAll": {
                return Optional.ofNullable(clazz.cast(this.unsubscribeAll()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Contact, T> g) {
        return obj -> g.apply((Contact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String emailAddress;
        private List<TopicPreference> topicPreferences = DefaultSdkAutoConstructList.getInstance();
        private List<TopicPreference> topicDefaultPreferences = DefaultSdkAutoConstructList.getInstance();
        private Boolean unsubscribeAll;
        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Contact model) {
            this.emailAddress(model.emailAddress);
            this.topicPreferences(model.topicPreferences);
            this.topicDefaultPreferences(model.topicDefaultPreferences);
            this.unsubscribeAll(model.unsubscribeAll);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        @Transient
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final List<TopicPreference.Builder> getTopicPreferences() {
            List<TopicPreference.Builder> result = TopicPreferenceListCopier.copyToBuilder(this.topicPreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicPreferences(Collection<TopicPreference.BuilderImpl> topicPreferences) {
            this.topicPreferences = TopicPreferenceListCopier.copyFromBuilder(topicPreferences);
        }

        @Override
        @Transient
        public final Builder topicPreferences(Collection<TopicPreference> topicPreferences) {
            this.topicPreferences = TopicPreferenceListCopier.copy(topicPreferences);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder topicPreferences(TopicPreference ... topicPreferences) {
            this.topicPreferences(Arrays.asList(topicPreferences));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder topicPreferences(Consumer<TopicPreference.Builder> ... topicPreferences) {
            this.topicPreferences(Stream.of(topicPreferences).map(c -> (TopicPreference)((TopicPreference.Builder)TopicPreference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TopicPreference.Builder> getTopicDefaultPreferences() {
            List<TopicPreference.Builder> result = TopicPreferenceListCopier.copyToBuilder(this.topicDefaultPreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicDefaultPreferences(Collection<TopicPreference.BuilderImpl> topicDefaultPreferences) {
            this.topicDefaultPreferences = TopicPreferenceListCopier.copyFromBuilder(topicDefaultPreferences);
        }

        @Override
        @Transient
        public final Builder topicDefaultPreferences(Collection<TopicPreference> topicDefaultPreferences) {
            this.topicDefaultPreferences = TopicPreferenceListCopier.copy(topicDefaultPreferences);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder topicDefaultPreferences(TopicPreference ... topicDefaultPreferences) {
            this.topicDefaultPreferences(Arrays.asList(topicDefaultPreferences));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder topicDefaultPreferences(Consumer<TopicPreference.Builder> ... topicDefaultPreferences) {
            this.topicDefaultPreferences(Stream.of(topicDefaultPreferences).map(c -> (TopicPreference)((TopicPreference.Builder)TopicPreference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getUnsubscribeAll() {
            return this.unsubscribeAll;
        }

        public final void setUnsubscribeAll(Boolean unsubscribeAll) {
            this.unsubscribeAll = unsubscribeAll;
        }

        @Override
        @Transient
        public final Builder unsubscribeAll(Boolean unsubscribeAll) {
            this.unsubscribeAll = unsubscribeAll;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public Contact build() {
            return new Contact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Contact> {
        public Builder emailAddress(String var1);

        public Builder topicPreferences(Collection<TopicPreference> var1);

        public Builder topicPreferences(TopicPreference ... var1);

        public Builder topicPreferences(Consumer<TopicPreference.Builder> ... var1);

        public Builder topicDefaultPreferences(Collection<TopicPreference> var1);

        public Builder topicDefaultPreferences(TopicPreference ... var1);

        public Builder topicDefaultPreferences(Consumer<TopicPreference.Builder> ... var1);

        public Builder unsubscribeAll(Boolean var1);

        public Builder lastUpdatedTimestamp(Instant var1);
    }
}

