/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The following data is returned in JSON format by the service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendBulkEmailResponse extends SesV2Response implements
        ToCopyableBuilder<SendBulkEmailResponse.Builder, SendBulkEmailResponse> {
    private static final SdkField<List<BulkEmailEntryResult>> BULK_EMAIL_ENTRY_RESULTS_FIELD = SdkField
            .<List<BulkEmailEntryResult>> builder(MarshallingType.LIST)
            .memberName("BulkEmailEntryResults")
            .getter(getter(SendBulkEmailResponse::bulkEmailEntryResults))
            .setter(setter(Builder::bulkEmailEntryResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkEmailEntryResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BulkEmailEntryResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(BulkEmailEntryResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BULK_EMAIL_ENTRY_RESULTS_FIELD));

    private final List<BulkEmailEntryResult> bulkEmailEntryResults;

    private SendBulkEmailResponse(BuilderImpl builder) {
        super(builder);
        this.bulkEmailEntryResults = builder.bulkEmailEntryResults;
    }

    /**
     * Returns true if the BulkEmailEntryResults property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBulkEmailEntryResults() {
        return bulkEmailEntryResults != null && !(bulkEmailEntryResults instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the BulkEmailEntryResults property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBulkEmailEntryResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the BulkEmailEntryResults property for this object.
     */
    public final List<BulkEmailEntryResult> bulkEmailEntryResults() {
        return bulkEmailEntryResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBulkEmailEntryResults() ? bulkEmailEntryResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBulkEmailResponse)) {
            return false;
        }
        SendBulkEmailResponse other = (SendBulkEmailResponse) obj;
        return hasBulkEmailEntryResults() == other.hasBulkEmailEntryResults()
                && Objects.equals(bulkEmailEntryResults(), other.bulkEmailEntryResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendBulkEmailResponse")
                .add("BulkEmailEntryResults", hasBulkEmailEntryResults() ? bulkEmailEntryResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BulkEmailEntryResults":
            return Optional.ofNullable(clazz.cast(bulkEmailEntryResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendBulkEmailResponse, T> g) {
        return obj -> g.apply((SendBulkEmailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, SendBulkEmailResponse> {
        /**
         * Sets the value of the BulkEmailEntryResults property for this object.
         *
         * @param bulkEmailEntryResults
         *        The new value for the BulkEmailEntryResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkEmailEntryResults(Collection<BulkEmailEntryResult> bulkEmailEntryResults);

        /**
         * Sets the value of the BulkEmailEntryResults property for this object.
         *
         * @param bulkEmailEntryResults
         *        The new value for the BulkEmailEntryResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkEmailEntryResults(BulkEmailEntryResult... bulkEmailEntryResults);

        /**
         * Sets the value of the BulkEmailEntryResults property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<BulkEmailEntryResult>.Builder} avoiding the
         * need to create one manually via {@link List<BulkEmailEntryResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BulkEmailEntryResult>.Builder#build()} is called immediately
         * and its result is passed to {@link #bulkEmailEntryResults(List<BulkEmailEntryResult>)}.
         * 
         * @param bulkEmailEntryResults
         *        a consumer that will call methods on {@link List<BulkEmailEntryResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bulkEmailEntryResults(List<BulkEmailEntryResult>)
         */
        Builder bulkEmailEntryResults(Consumer<BulkEmailEntryResult.Builder>... bulkEmailEntryResults);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<BulkEmailEntryResult> bulkEmailEntryResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendBulkEmailResponse model) {
            super(model);
            bulkEmailEntryResults(model.bulkEmailEntryResults);
        }

        public final Collection<BulkEmailEntryResult.Builder> getBulkEmailEntryResults() {
            if (bulkEmailEntryResults instanceof SdkAutoConstructList) {
                return null;
            }
            return bulkEmailEntryResults != null ? bulkEmailEntryResults.stream().map(BulkEmailEntryResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bulkEmailEntryResults(Collection<BulkEmailEntryResult> bulkEmailEntryResults) {
            this.bulkEmailEntryResults = BulkEmailEntryResultListCopier.copy(bulkEmailEntryResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bulkEmailEntryResults(BulkEmailEntryResult... bulkEmailEntryResults) {
            bulkEmailEntryResults(Arrays.asList(bulkEmailEntryResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bulkEmailEntryResults(Consumer<BulkEmailEntryResult.Builder>... bulkEmailEntryResults) {
            bulkEmailEntryResults(Stream.of(bulkEmailEntryResults)
                    .map(c -> BulkEmailEntryResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBulkEmailEntryResults(Collection<BulkEmailEntryResult.BuilderImpl> bulkEmailEntryResults) {
            this.bulkEmailEntryResults = BulkEmailEntryResultListCopier.copyFromBuilder(bulkEmailEntryResults);
        }

        @Override
        public SendBulkEmailResponse build() {
            return new SendBulkEmailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
