/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the predictive inbox placement test that you created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeliverabilityTestReportResponse extends SesV2Response implements
        ToCopyableBuilder<CreateDeliverabilityTestReportResponse.Builder, CreateDeliverabilityTestReportResponse> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportId").getter(getter(CreateDeliverabilityTestReportResponse::reportId))
            .setter(setter(Builder::reportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId").build()).build();

    private static final SdkField<String> DELIVERABILITY_TEST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliverabilityTestStatus")
            .getter(getter(CreateDeliverabilityTestReportResponse::deliverabilityTestStatusAsString))
            .setter(setter(Builder::deliverabilityTestStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverabilityTestStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD,
            DELIVERABILITY_TEST_STATUS_FIELD));

    private final String reportId;

    private final String deliverabilityTestStatus;

    private CreateDeliverabilityTestReportResponse(BuilderImpl builder) {
        super(builder);
        this.reportId = builder.reportId;
        this.deliverabilityTestStatus = builder.deliverabilityTestStatus;
    }

    /**
     * <p>
     * A unique string that identifies the predictive inbox placement test.
     * </p>
     * 
     * @return A unique string that identifies the predictive inbox placement test.
     */
    public final String reportId() {
        return reportId;
    }

    /**
     * <p>
     * The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive
     * inbox placement test is currently running. Predictive inbox placement tests are usually complete within 24 hours
     * of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use the
     * <code>GetDeliverabilityTestReport</code> to view the results of the test.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliverabilityTestStatus} will return {@link DeliverabilityTestStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deliverabilityTestStatusAsString}.
     * </p>
     * 
     * @return The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
     *         predictive inbox placement test is currently running. Predictive inbox placement tests are usually
     *         complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is
     *         finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.
     * @see DeliverabilityTestStatus
     */
    public final DeliverabilityTestStatus deliverabilityTestStatus() {
        return DeliverabilityTestStatus.fromValue(deliverabilityTestStatus);
    }

    /**
     * <p>
     * The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive
     * inbox placement test is currently running. Predictive inbox placement tests are usually complete within 24 hours
     * of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use the
     * <code>GetDeliverabilityTestReport</code> to view the results of the test.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliverabilityTestStatus} will return {@link DeliverabilityTestStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deliverabilityTestStatusAsString}.
     * </p>
     * 
     * @return The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
     *         predictive inbox placement test is currently running. Predictive inbox placement tests are usually
     *         complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is
     *         finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.
     * @see DeliverabilityTestStatus
     */
    public final String deliverabilityTestStatusAsString() {
        return deliverabilityTestStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportId());
        hashCode = 31 * hashCode + Objects.hashCode(deliverabilityTestStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliverabilityTestReportResponse)) {
            return false;
        }
        CreateDeliverabilityTestReportResponse other = (CreateDeliverabilityTestReportResponse) obj;
        return Objects.equals(reportId(), other.reportId())
                && Objects.equals(deliverabilityTestStatusAsString(), other.deliverabilityTestStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeliverabilityTestReportResponse").add("ReportId", reportId())
                .add("DeliverabilityTestStatus", deliverabilityTestStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportId":
            return Optional.ofNullable(clazz.cast(reportId()));
        case "DeliverabilityTestStatus":
            return Optional.ofNullable(clazz.cast(deliverabilityTestStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeliverabilityTestReportResponse, T> g) {
        return obj -> g.apply((CreateDeliverabilityTestReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDeliverabilityTestReportResponse> {
        /**
         * <p>
         * A unique string that identifies the predictive inbox placement test.
         * </p>
         * 
         * @param reportId
         *        A unique string that identifies the predictive inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportId(String reportId);

        /**
         * <p>
         * The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
         * predictive inbox placement test is currently running. Predictive inbox placement tests are usually complete
         * within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and
         * you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.
         * </p>
         * 
         * @param deliverabilityTestStatus
         *        The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
         *        predictive inbox placement test is currently running. Predictive inbox placement tests are usually
         *        complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test
         *        is finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the
         *        test.
         * @see DeliverabilityTestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliverabilityTestStatus
         */
        Builder deliverabilityTestStatus(String deliverabilityTestStatus);

        /**
         * <p>
         * The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
         * predictive inbox placement test is currently running. Predictive inbox placement tests are usually complete
         * within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and
         * you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.
         * </p>
         * 
         * @param deliverabilityTestStatus
         *        The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the
         *        predictive inbox placement test is currently running. Predictive inbox placement tests are usually
         *        complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test
         *        is finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the
         *        test.
         * @see DeliverabilityTestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliverabilityTestStatus
         */
        Builder deliverabilityTestStatus(DeliverabilityTestStatus deliverabilityTestStatus);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String reportId;

        private String deliverabilityTestStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliverabilityTestReportResponse model) {
            super(model);
            reportId(model.reportId);
            deliverabilityTestStatus(model.deliverabilityTestStatus);
        }

        public final String getReportId() {
            return reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        public final String getDeliverabilityTestStatus() {
            return deliverabilityTestStatus;
        }

        @Override
        public final Builder deliverabilityTestStatus(String deliverabilityTestStatus) {
            this.deliverabilityTestStatus = deliverabilityTestStatus;
            return this;
        }

        @Override
        public final Builder deliverabilityTestStatus(DeliverabilityTestStatus deliverabilityTestStatus) {
            this.deliverabilityTestStatus(deliverabilityTestStatus == null ? null : deliverabilityTestStatus.toString());
            return this;
        }

        public final void setDeliverabilityTestStatus(String deliverabilityTestStatus) {
            this.deliverabilityTestStatus = deliverabilityTestStatus;
        }

        @Override
        public CreateDeliverabilityTestReportResponse build() {
            return new CreateDeliverabilityTestReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
