/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactRequest extends SesV2Request implements
        ToCopyableBuilder<CreateContactRequest.Builder, CreateContactRequest> {
    private static final SdkField<String> CONTACT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactListName").getter(getter(CreateContactRequest::contactListName))
            .setter(setter(Builder::contactListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactListName").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(CreateContactRequest::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<List<TopicPreference>> TOPIC_PREFERENCES_FIELD = SdkField
            .<List<TopicPreference>> builder(MarshallingType.LIST)
            .memberName("TopicPreferences")
            .getter(getter(CreateContactRequest::topicPreferences))
            .setter(setter(Builder::topicPreferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicPreferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicPreference> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicPreference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> UNSUBSCRIBE_ALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UnsubscribeAll").getter(getter(CreateContactRequest::unsubscribeAll))
            .setter(setter(Builder::unsubscribeAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsubscribeAll").build()).build();

    private static final SdkField<String> ATTRIBUTES_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributesData").getter(getter(CreateContactRequest::attributesData))
            .setter(setter(Builder::attributesData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_NAME_FIELD,
            EMAIL_ADDRESS_FIELD, TOPIC_PREFERENCES_FIELD, UNSUBSCRIBE_ALL_FIELD, ATTRIBUTES_DATA_FIELD));

    private final String contactListName;

    private final String emailAddress;

    private final List<TopicPreference> topicPreferences;

    private final Boolean unsubscribeAll;

    private final String attributesData;

    private CreateContactRequest(BuilderImpl builder) {
        super(builder);
        this.contactListName = builder.contactListName;
        this.emailAddress = builder.emailAddress;
        this.topicPreferences = builder.topicPreferences;
        this.unsubscribeAll = builder.unsubscribeAll;
        this.attributesData = builder.attributesData;
    }

    /**
     * <p>
     * The name of the contact list to which the contact should be added.
     * </p>
     * 
     * @return The name of the contact list to which the contact should be added.
     */
    public final String contactListName() {
        return contactListName;
    }

    /**
     * <p>
     * The contact's email address.
     * </p>
     * 
     * @return The contact's email address.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * Returns true if the TopicPreferences property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTopicPreferences() {
        return topicPreferences != null && !(topicPreferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contact's preferences for being opted-in to or opted-out of topics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTopicPreferences()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The contact's preferences for being opted-in to or opted-out of topics.
     */
    public final List<TopicPreference> topicPreferences() {
        return topicPreferences;
    }

    /**
     * <p>
     * A boolean value status noting if the contact is unsubscribed from all contact list topics.
     * </p>
     * 
     * @return A boolean value status noting if the contact is unsubscribed from all contact list topics.
     */
    public final Boolean unsubscribeAll() {
        return unsubscribeAll;
    }

    /**
     * <p>
     * The attribute data attached to a contact.
     * </p>
     * 
     * @return The attribute data attached to a contact.
     */
    public final String attributesData() {
        return attributesData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactListName());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasTopicPreferences() ? topicPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(unsubscribeAll());
        hashCode = 31 * hashCode + Objects.hashCode(attributesData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactRequest)) {
            return false;
        }
        CreateContactRequest other = (CreateContactRequest) obj;
        return Objects.equals(contactListName(), other.contactListName()) && Objects.equals(emailAddress(), other.emailAddress())
                && hasTopicPreferences() == other.hasTopicPreferences()
                && Objects.equals(topicPreferences(), other.topicPreferences())
                && Objects.equals(unsubscribeAll(), other.unsubscribeAll())
                && Objects.equals(attributesData(), other.attributesData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactRequest").add("ContactListName", contactListName())
                .add("EmailAddress", emailAddress()).add("TopicPreferences", hasTopicPreferences() ? topicPreferences() : null)
                .add("UnsubscribeAll", unsubscribeAll()).add("AttributesData", attributesData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactListName":
            return Optional.ofNullable(clazz.cast(contactListName()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "TopicPreferences":
            return Optional.ofNullable(clazz.cast(topicPreferences()));
        case "UnsubscribeAll":
            return Optional.ofNullable(clazz.cast(unsubscribeAll()));
        case "AttributesData":
            return Optional.ofNullable(clazz.cast(attributesData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactRequest, T> g) {
        return obj -> g.apply((CreateContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateContactRequest> {
        /**
         * <p>
         * The name of the contact list to which the contact should be added.
         * </p>
         * 
         * @param contactListName
         *        The name of the contact list to which the contact should be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactListName(String contactListName);

        /**
         * <p>
         * The contact's email address.
         * </p>
         * 
         * @param emailAddress
         *        The contact's email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The contact's preferences for being opted-in to or opted-out of topics.
         * </p>
         * 
         * @param topicPreferences
         *        The contact's preferences for being opted-in to or opted-out of topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPreferences(Collection<TopicPreference> topicPreferences);

        /**
         * <p>
         * The contact's preferences for being opted-in to or opted-out of topics.
         * </p>
         * 
         * @param topicPreferences
         *        The contact's preferences for being opted-in to or opted-out of topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPreferences(TopicPreference... topicPreferences);

        /**
         * <p>
         * The contact's preferences for being opted-in to or opted-out of topics.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TopicPreference>.Builder} avoiding the need
         * to create one manually via {@link List<TopicPreference>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TopicPreference>.Builder#build()} is called immediately and
         * its result is passed to {@link #topicPreferences(List<TopicPreference>)}.
         * 
         * @param topicPreferences
         *        a consumer that will call methods on {@link List<TopicPreference>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicPreferences(List<TopicPreference>)
         */
        Builder topicPreferences(Consumer<TopicPreference.Builder>... topicPreferences);

        /**
         * <p>
         * A boolean value status noting if the contact is unsubscribed from all contact list topics.
         * </p>
         * 
         * @param unsubscribeAll
         *        A boolean value status noting if the contact is unsubscribed from all contact list topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsubscribeAll(Boolean unsubscribeAll);

        /**
         * <p>
         * The attribute data attached to a contact.
         * </p>
         * 
         * @param attributesData
         *        The attribute data attached to a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesData(String attributesData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String contactListName;

        private String emailAddress;

        private List<TopicPreference> topicPreferences = DefaultSdkAutoConstructList.getInstance();

        private Boolean unsubscribeAll;

        private String attributesData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactRequest model) {
            super(model);
            contactListName(model.contactListName);
            emailAddress(model.emailAddress);
            topicPreferences(model.topicPreferences);
            unsubscribeAll(model.unsubscribeAll);
            attributesData(model.attributesData);
        }

        public final String getContactListName() {
            return contactListName;
        }

        @Override
        public final Builder contactListName(String contactListName) {
            this.contactListName = contactListName;
            return this;
        }

        public final void setContactListName(String contactListName) {
            this.contactListName = contactListName;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final Collection<TopicPreference.Builder> getTopicPreferences() {
            if (topicPreferences instanceof SdkAutoConstructList) {
                return null;
            }
            return topicPreferences != null ? topicPreferences.stream().map(TopicPreference::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topicPreferences(Collection<TopicPreference> topicPreferences) {
            this.topicPreferences = TopicPreferenceListCopier.copy(topicPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicPreferences(TopicPreference... topicPreferences) {
            topicPreferences(Arrays.asList(topicPreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicPreferences(Consumer<TopicPreference.Builder>... topicPreferences) {
            topicPreferences(Stream.of(topicPreferences).map(c -> TopicPreference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTopicPreferences(Collection<TopicPreference.BuilderImpl> topicPreferences) {
            this.topicPreferences = TopicPreferenceListCopier.copyFromBuilder(topicPreferences);
        }

        public final Boolean getUnsubscribeAll() {
            return unsubscribeAll;
        }

        @Override
        public final Builder unsubscribeAll(Boolean unsubscribeAll) {
            this.unsubscribeAll = unsubscribeAll;
            return this;
        }

        public final void setUnsubscribeAll(Boolean unsubscribeAll) {
            this.unsubscribeAll = unsubscribeAll;
        }

        public final String getAttributesData() {
            return attributesData;
        }

        @Override
        public final Builder attributesData(String attributesData) {
            this.attributesData = attributesData;
            return this;
        }

        public final void setAttributesData(String attributesData) {
            this.attributesData = attributesData;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactRequest build() {
            return new CreateContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
