/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.DeliverabilityTestReport;
import software.amazon.awssdk.services.sesv2.model.DeliverabilityTestReportsCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeliverabilityTestReportsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListDeliverabilityTestReportsResponse> {
    private static final SdkField<List<DeliverabilityTestReport>> DELIVERABILITY_TEST_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDeliverabilityTestReportsResponse.getter(ListDeliverabilityTestReportsResponse::deliverabilityTestReports)).setter(ListDeliverabilityTestReportsResponse.setter(Builder::deliverabilityTestReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverabilityTestReports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeliverabilityTestReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDeliverabilityTestReportsResponse.getter(ListDeliverabilityTestReportsResponse::nextToken)).setter(ListDeliverabilityTestReportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERABILITY_TEST_REPORTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DeliverabilityTestReport> deliverabilityTestReports;
    private final String nextToken;

    private ListDeliverabilityTestReportsResponse(BuilderImpl builder) {
        super(builder);
        this.deliverabilityTestReports = builder.deliverabilityTestReports;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDeliverabilityTestReports() {
        return this.deliverabilityTestReports != null && !(this.deliverabilityTestReports instanceof SdkAutoConstructList);
    }

    public List<DeliverabilityTestReport> deliverabilityTestReports() {
        return this.deliverabilityTestReports;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverabilityTestReports());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliverabilityTestReportsResponse)) {
            return false;
        }
        ListDeliverabilityTestReportsResponse other = (ListDeliverabilityTestReportsResponse)((Object)obj);
        return Objects.equals(this.deliverabilityTestReports(), other.deliverabilityTestReports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeliverabilityTestReportsResponse").add("DeliverabilityTestReports", this.deliverabilityTestReports()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliverabilityTestReports": {
                return Optional.ofNullable(clazz.cast(this.deliverabilityTestReports()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeliverabilityTestReportsResponse, T> g) {
        return obj -> g.apply((ListDeliverabilityTestReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<DeliverabilityTestReport> deliverabilityTestReports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliverabilityTestReportsResponse model) {
            super(model);
            this.deliverabilityTestReports(model.deliverabilityTestReports);
            this.nextToken(model.nextToken);
        }

        public final Collection<DeliverabilityTestReport.Builder> getDeliverabilityTestReports() {
            return this.deliverabilityTestReports != null ? (Collection)this.deliverabilityTestReports.stream().map(DeliverabilityTestReport::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deliverabilityTestReports(Collection<DeliverabilityTestReport> deliverabilityTestReports) {
            this.deliverabilityTestReports = DeliverabilityTestReportsCopier.copy(deliverabilityTestReports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliverabilityTestReports(DeliverabilityTestReport ... deliverabilityTestReports) {
            this.deliverabilityTestReports(Arrays.asList(deliverabilityTestReports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliverabilityTestReports(Consumer<DeliverabilityTestReport.Builder> ... deliverabilityTestReports) {
            this.deliverabilityTestReports(Stream.of(deliverabilityTestReports).map(c -> (DeliverabilityTestReport)((DeliverabilityTestReport.Builder)DeliverabilityTestReport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeliverabilityTestReports(Collection<DeliverabilityTestReport.BuilderImpl> deliverabilityTestReports) {
            this.deliverabilityTestReports = DeliverabilityTestReportsCopier.copyFromBuilder(deliverabilityTestReports);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeliverabilityTestReportsResponse build() {
            return new ListDeliverabilityTestReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeliverabilityTestReportsResponse> {
        public Builder deliverabilityTestReports(Collection<DeliverabilityTestReport> var1);

        public Builder deliverabilityTestReports(DeliverabilityTestReport ... var1);

        public Builder deliverabilityTestReports(Consumer<DeliverabilityTestReport.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

