/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * The reason that the address was added to the suppression list for your account. The value can be one of the
 * following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>COMPLAINT</code> – Amazon SES added an email address to the suppression list for your account because a message
 * sent to that address results in a complaint.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>BOUNCE</code> – Amazon SES added an email address to the suppression list for your account because a message
 * sent to that address results in a hard bounce.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum SuppressionListReason {
    BOUNCE("BOUNCE"),

    COMPLAINT("COMPLAINT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SuppressionListReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SuppressionListReason corresponding to the value
     */
    public static SuppressionListReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SuppressionListReason.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SuppressionListReason}s
     */
    public static Set<SuppressionListReason> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
