/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about the email address suppression preferences for your account in the current
 * AWS Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuppressionAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<SuppressionAttributes.Builder, SuppressionAttributes> {
    private static final SdkField<List<String>> SUPPRESSED_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SuppressionAttributes::suppressedReasonsAsStrings))
            .setter(setter(Builder::suppressedReasonsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressedReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPRESSED_REASONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> suppressedReasons;

    private SuppressionAttributes(BuilderImpl builder) {
        this.suppressedReasons = builder.suppressedReasons;
    }

    /**
     * <p>
     * A list that contains the reasons that email addresses will be automatically added to the suppression list for
     * your account. This list can contain any or all of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a complaint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a hard bounce.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuppressedReasons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains the reasons that email addresses will be automatically added to the suppression list
     *         for your account. This list can contain any or all of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a complaint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a hard bounce.
     *         </p>
     *         </li>
     */
    public List<SuppressionListReason> suppressedReasons() {
        return SuppressionListReasonsCopier.copyStringToEnum(suppressedReasons);
    }

    /**
     * Returns true if the SuppressedReasons property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSuppressedReasons() {
        return suppressedReasons != null && !(suppressedReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains the reasons that email addresses will be automatically added to the suppression list for
     * your account. This list can contain any or all of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a complaint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a hard bounce.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuppressedReasons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains the reasons that email addresses will be automatically added to the suppression list
     *         for your account. This list can contain any or all of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a complaint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a hard bounce.
     *         </p>
     *         </li>
     */
    public List<String> suppressedReasonsAsStrings() {
        return suppressedReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suppressedReasonsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuppressionAttributes)) {
            return false;
        }
        SuppressionAttributes other = (SuppressionAttributes) obj;
        return Objects.equals(suppressedReasonsAsStrings(), other.suppressedReasonsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SuppressionAttributes").add("SuppressedReasons", suppressedReasonsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuppressedReasons":
            return Optional.ofNullable(clazz.cast(suppressedReasonsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuppressionAttributes, T> g) {
        return obj -> g.apply((SuppressionAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuppressionAttributes> {
        /**
         * <p>
         * A list that contains the reasons that email addresses will be automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses will be automatically added to the suppression
         *        list for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasonsWithStrings(Collection<String> suppressedReasons);

        /**
         * <p>
         * A list that contains the reasons that email addresses will be automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses will be automatically added to the suppression
         *        list for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasonsWithStrings(String... suppressedReasons);

        /**
         * <p>
         * A list that contains the reasons that email addresses will be automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses will be automatically added to the suppression
         *        list for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasons(Collection<SuppressionListReason> suppressedReasons);

        /**
         * <p>
         * A list that contains the reasons that email addresses will be automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses will be automatically added to the suppression
         *        list for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasons(SuppressionListReason... suppressedReasons);
    }

    static final class BuilderImpl implements Builder {
        private List<String> suppressedReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuppressionAttributes model) {
            suppressedReasonsWithStrings(model.suppressedReasons);
        }

        public final Collection<String> getSuppressedReasons() {
            return suppressedReasons;
        }

        @Override
        public final Builder suppressedReasonsWithStrings(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasonsWithStrings(String... suppressedReasons) {
            suppressedReasonsWithStrings(Arrays.asList(suppressedReasons));
            return this;
        }

        @Override
        public final Builder suppressedReasons(Collection<SuppressionListReason> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copyEnumToString(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasons(SuppressionListReason... suppressedReasons) {
            suppressedReasons(Arrays.asList(suppressedReasons));
            return this;
        }

        public final void setSuppressedReasons(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
        }

        @Override
        public SuppressionAttributes build() {
            return new SuppressionAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
