/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to add an email destination to the suppression list for your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSuppressedDestinationRequest extends SesV2Request implements
        ToCopyableBuilder<PutSuppressedDestinationRequest.Builder, PutSuppressedDestinationRequest> {
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutSuppressedDestinationRequest::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutSuppressedDestinationRequest::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_FIELD,
            REASON_FIELD));

    private final String emailAddress;

    private final String reason;

    private PutSuppressedDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.emailAddress = builder.emailAddress;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The email address that should be added to the suppression list for your account.
     * </p>
     * 
     * @return The email address that should be added to the suppression list for your account.
     */
    public String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The factors that should cause the email address to be added to the suppression list for your account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link SuppressionListReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The factors that should cause the email address to be added to the suppression list for your account.
     * @see SuppressionListReason
     */
    public SuppressionListReason reason() {
        return SuppressionListReason.fromValue(reason);
    }

    /**
     * <p>
     * The factors that should cause the email address to be added to the suppression list for your account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link SuppressionListReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The factors that should cause the email address to be added to the suppression list for your account.
     * @see SuppressionListReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSuppressedDestinationRequest)) {
            return false;
        }
        PutSuppressedDestinationRequest other = (PutSuppressedDestinationRequest) obj;
        return Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(reasonAsString(), other.reasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutSuppressedDestinationRequest").add("EmailAddress", emailAddress())
                .add("Reason", reasonAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSuppressedDestinationRequest, T> g) {
        return obj -> g.apply((PutSuppressedDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, PutSuppressedDestinationRequest> {
        /**
         * <p>
         * The email address that should be added to the suppression list for your account.
         * </p>
         * 
         * @param emailAddress
         *        The email address that should be added to the suppression list for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The factors that should cause the email address to be added to the suppression list for your account.
         * </p>
         * 
         * @param reason
         *        The factors that should cause the email address to be added to the suppression list for your account.
         * @see SuppressionListReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionListReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The factors that should cause the email address to be added to the suppression list for your account.
         * </p>
         * 
         * @param reason
         *        The factors that should cause the email address to be added to the suppression list for your account.
         * @see SuppressionListReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionListReason
         */
        Builder reason(SuppressionListReason reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String emailAddress;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSuppressedDestinationRequest model) {
            super(model);
            emailAddress(model.emailAddress);
            reason(model.reason);
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(SuppressionListReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSuppressedDestinationRequest build() {
            return new PutSuppressedDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
