/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to change the DKIM attributes for an email identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEmailIdentityDkimSigningAttributesRequest extends SesV2Request implements
        ToCopyableBuilder<PutEmailIdentityDkimSigningAttributesRequest.Builder, PutEmailIdentityDkimSigningAttributesRequest> {
    private static final SdkField<String> EMAIL_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEmailIdentityDkimSigningAttributesRequest::emailIdentity)).setter(setter(Builder::emailIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailIdentity").build()).build();

    private static final SdkField<String> SIGNING_ATTRIBUTES_ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEmailIdentityDkimSigningAttributesRequest::signingAttributesOriginAsString))
            .setter(setter(Builder::signingAttributesOrigin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAttributesOrigin").build())
            .build();

    private static final SdkField<DkimSigningAttributes> SIGNING_ATTRIBUTES_FIELD = SdkField
            .<DkimSigningAttributes> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutEmailIdentityDkimSigningAttributesRequest::signingAttributes))
            .setter(setter(Builder::signingAttributes)).constructor(DkimSigningAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITY_FIELD,
            SIGNING_ATTRIBUTES_ORIGIN_FIELD, SIGNING_ATTRIBUTES_FIELD));

    private final String emailIdentity;

    private final String signingAttributesOrigin;

    private final DkimSigningAttributes signingAttributes;

    private PutEmailIdentityDkimSigningAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.emailIdentity = builder.emailIdentity;
        this.signingAttributesOrigin = builder.signingAttributesOrigin;
        this.signingAttributes = builder.signingAttributes;
    }

    /**
     * <p>
     * The email identity that you want to configure DKIM for.
     * </p>
     * 
     * @return The email identity that you want to configure DKIM for.
     */
    public String emailIdentity() {
        return emailIdentity;
    }

    /**
     * <p>
     * The method that you want to use to configure DKIM for the identity. There are two possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_SES</code> – Configure DKIM for the identity by using <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #signingAttributesOrigin} will return {@link DkimSigningAttributesOrigin#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #signingAttributesOriginAsString}.
     * </p>
     * 
     * @return The method that you want to use to configure DKIM for the identity. There are two possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_SES</code> – Configure DKIM for the identity by using <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).
     *         </p>
     *         </li>
     * @see DkimSigningAttributesOrigin
     */
    public DkimSigningAttributesOrigin signingAttributesOrigin() {
        return DkimSigningAttributesOrigin.fromValue(signingAttributesOrigin);
    }

    /**
     * <p>
     * The method that you want to use to configure DKIM for the identity. There are two possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_SES</code> – Configure DKIM for the identity by using <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #signingAttributesOrigin} will return {@link DkimSigningAttributesOrigin#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #signingAttributesOriginAsString}.
     * </p>
     * 
     * @return The method that you want to use to configure DKIM for the identity. There are two possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_SES</code> – Configure DKIM for the identity by using <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).
     *         </p>
     *         </li>
     * @see DkimSigningAttributesOrigin
     */
    public String signingAttributesOriginAsString() {
        return signingAttributesOrigin;
    }

    /**
     * <p>
     * An object that contains information about the private key and selector that you want to use to configure DKIM for
     * the identity. This object is only required if you want to configure Bring Your Own DKIM (BYODKIM) for the
     * identity.
     * </p>
     * 
     * @return An object that contains information about the private key and selector that you want to use to configure
     *         DKIM for the identity. This object is only required if you want to configure Bring Your Own DKIM
     *         (BYODKIM) for the identity.
     */
    public DkimSigningAttributes signingAttributes() {
        return signingAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(signingAttributesOriginAsString());
        hashCode = 31 * hashCode + Objects.hashCode(signingAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEmailIdentityDkimSigningAttributesRequest)) {
            return false;
        }
        PutEmailIdentityDkimSigningAttributesRequest other = (PutEmailIdentityDkimSigningAttributesRequest) obj;
        return Objects.equals(emailIdentity(), other.emailIdentity())
                && Objects.equals(signingAttributesOriginAsString(), other.signingAttributesOriginAsString())
                && Objects.equals(signingAttributes(), other.signingAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutEmailIdentityDkimSigningAttributesRequest").add("EmailIdentity", emailIdentity())
                .add("SigningAttributesOrigin", signingAttributesOriginAsString()).add("SigningAttributes", signingAttributes())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailIdentity":
            return Optional.ofNullable(clazz.cast(emailIdentity()));
        case "SigningAttributesOrigin":
            return Optional.ofNullable(clazz.cast(signingAttributesOriginAsString()));
        case "SigningAttributes":
            return Optional.ofNullable(clazz.cast(signingAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEmailIdentityDkimSigningAttributesRequest, T> g) {
        return obj -> g.apply((PutEmailIdentityDkimSigningAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutEmailIdentityDkimSigningAttributesRequest> {
        /**
         * <p>
         * The email identity that you want to configure DKIM for.
         * </p>
         * 
         * @param emailIdentity
         *        The email identity that you want to configure DKIM for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailIdentity(String emailIdentity);

        /**
         * <p>
         * The method that you want to use to configure DKIM for the identity. There are two possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_SES</code> – Configure DKIM for the identity by using <a
         * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).
         * </p>
         * </li>
         * </ul>
         * 
         * @param signingAttributesOrigin
         *        The method that you want to use to configure DKIM for the identity. There are two possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_SES</code> – Configure DKIM for the identity by using <a
         *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).
         *        </p>
         *        </li>
         * @see DkimSigningAttributesOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DkimSigningAttributesOrigin
         */
        Builder signingAttributesOrigin(String signingAttributesOrigin);

        /**
         * <p>
         * The method that you want to use to configure DKIM for the identity. There are two possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_SES</code> – Configure DKIM for the identity by using <a
         * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).
         * </p>
         * </li>
         * </ul>
         * 
         * @param signingAttributesOrigin
         *        The method that you want to use to configure DKIM for the identity. There are two possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_SES</code> – Configure DKIM for the identity by using <a
         *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).
         *        </p>
         *        </li>
         * @see DkimSigningAttributesOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DkimSigningAttributesOrigin
         */
        Builder signingAttributesOrigin(DkimSigningAttributesOrigin signingAttributesOrigin);

        /**
         * <p>
         * An object that contains information about the private key and selector that you want to use to configure DKIM
         * for the identity. This object is only required if you want to configure Bring Your Own DKIM (BYODKIM) for the
         * identity.
         * </p>
         * 
         * @param signingAttributes
         *        An object that contains information about the private key and selector that you want to use to
         *        configure DKIM for the identity. This object is only required if you want to configure Bring Your Own
         *        DKIM (BYODKIM) for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingAttributes(DkimSigningAttributes signingAttributes);

        /**
         * <p>
         * An object that contains information about the private key and selector that you want to use to configure DKIM
         * for the identity. This object is only required if you want to configure Bring Your Own DKIM (BYODKIM) for the
         * identity.
         * </p>
         * This is a convenience that creates an instance of the {@link DkimSigningAttributes.Builder} avoiding the need
         * to create one manually via {@link DkimSigningAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link DkimSigningAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #signingAttributes(DkimSigningAttributes)}.
         * 
         * @param signingAttributes
         *        a consumer that will call methods on {@link DkimSigningAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingAttributes(DkimSigningAttributes)
         */
        default Builder signingAttributes(Consumer<DkimSigningAttributes.Builder> signingAttributes) {
            return signingAttributes(DkimSigningAttributes.builder().applyMutation(signingAttributes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String emailIdentity;

        private String signingAttributesOrigin;

        private DkimSigningAttributes signingAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEmailIdentityDkimSigningAttributesRequest model) {
            super(model);
            emailIdentity(model.emailIdentity);
            signingAttributesOrigin(model.signingAttributesOrigin);
            signingAttributes(model.signingAttributes);
        }

        public final String getEmailIdentity() {
            return emailIdentity;
        }

        @Override
        public final Builder emailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        public final void setEmailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
        }

        public final String getSigningAttributesOrigin() {
            return signingAttributesOrigin;
        }

        @Override
        public final Builder signingAttributesOrigin(String signingAttributesOrigin) {
            this.signingAttributesOrigin = signingAttributesOrigin;
            return this;
        }

        @Override
        public final Builder signingAttributesOrigin(DkimSigningAttributesOrigin signingAttributesOrigin) {
            this.signingAttributesOrigin(signingAttributesOrigin == null ? null : signingAttributesOrigin.toString());
            return this;
        }

        public final void setSigningAttributesOrigin(String signingAttributesOrigin) {
            this.signingAttributesOrigin = signingAttributesOrigin;
        }

        public final DkimSigningAttributes.Builder getSigningAttributes() {
            return signingAttributes != null ? signingAttributes.toBuilder() : null;
        }

        @Override
        public final Builder signingAttributes(DkimSigningAttributes signingAttributes) {
            this.signingAttributes = signingAttributes;
            return this;
        }

        public final void setSigningAttributes(DkimSigningAttributes.BuilderImpl signingAttributes) {
            this.signingAttributes = signingAttributes != null ? signingAttributes.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEmailIdentityDkimSigningAttributesRequest build() {
            return new PutEmailIdentityDkimSigningAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
