/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * The status of the MAIL FROM domain. This status can have the following values:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>PENDING</code> – Amazon SES hasn't started searching for the MX record yet.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>FAILED</code> – Amazon SES can't find the required MX record, or the record no longer exists.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from determining the status
 * of the MAIL FROM domain.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum MailFromDomainStatus {
    PENDING("PENDING"),

    SUCCESS("SUCCESS"),

    FAILED("FAILED"),

    TEMPORARY_FAILURE("TEMPORARY_FAILURE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MailFromDomainStatus(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MailFromDomainStatus corresponding to the value
     */
    public static MailFromDomainStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MailFromDomainStatus.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MailFromDomainStatus}s
     */
    public static Set<MailFromDomainStatus> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
