/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.model.AccountSuspendedException;
import software.amazon.awssdk.services.sesv2.model.AlreadyExistsException;
import software.amazon.awssdk.services.sesv2.model.BadRequestException;
import software.amazon.awssdk.services.sesv2.model.ConcurrentModificationException;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.GetAccountRequest;
import software.amazon.awssdk.services.sesv2.model.GetAccountResponse;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.InvalidNextTokenException;
import software.amazon.awssdk.services.sesv2.model.LimitExceededException;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sesv2.model.MailFromDomainNotVerifiedException;
import software.amazon.awssdk.services.sesv2.model.MessageRejectedException;
import software.amazon.awssdk.services.sesv2.model.NotFoundException;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSuppressionAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSuppressionOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.SendEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendEmailResponse;
import software.amazon.awssdk.services.sesv2.model.SendingPausedException;
import software.amazon.awssdk.services.sesv2.model.SesV2Exception;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.services.sesv2.model.TagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.TagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.TooManyRequestsException;
import software.amazon.awssdk.services.sesv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesIterable;
import software.amazon.awssdk.services.sesv2.paginators.ListSuppressedDestinationsIterable;
import software.amazon.awssdk.services.sesv2.transform.CreateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.CreateEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteDedicatedIpPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.DeleteSuppressedDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetBlacklistReportsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetConfigurationSetEventDestinationsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDedicatedIpRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDedicatedIpsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDeliverabilityDashboardOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDeliverabilityTestReportRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDomainDeliverabilityCampaignRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetDomainStatisticsReportRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetEmailIdentityRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.GetSuppressedDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListConfigurationSetsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListDedicatedIpPoolsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListDeliverabilityTestReportsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListDomainDeliverabilityCampaignsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListEmailIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListSuppressedDestinationsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountSendingAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutAccountSuppressionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetDeliveryOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetReputationOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetSendingOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetSuppressionOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDedicatedIpInPoolRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDedicatedIpWarmupAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutDeliverabilityDashboardOptionRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityDkimAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityDkimSigningAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityFeedbackAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutEmailIdentityMailFromAttributesRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.PutSuppressedDestinationRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.SendEmailRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.sesv2.transform.UpdateConfigurationSetEventDestinationRequestMarshaller;

@SdkInternalApi
final class DefaultSesV2Client
implements SesV2Client {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSesV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "ses";
    }

    @Override
    public CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest) throws AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetRequest).withMarshaller((Marshaller)new CreateConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) throws NotFoundException, AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetEventDestinationRequest).withMarshaller((Marshaller)new CreateConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDedicatedIpPoolResponse createDedicatedIpPool(CreateDedicatedIpPoolRequest createDedicatedIpPoolRequest) throws AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDedicatedIpPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDedicatedIpPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDedicatedIpPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDedicatedIpPoolRequest).withMarshaller((Marshaller)new CreateDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDeliverabilityTestReportResponse createDeliverabilityTestReport(CreateDeliverabilityTestReportRequest createDeliverabilityTestReportRequest) throws AccountSuspendedException, SendingPausedException, MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeliverabilityTestReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDeliverabilityTestReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDeliverabilityTestReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDeliverabilityTestReportRequest).withMarshaller((Marshaller)new CreateDeliverabilityTestReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateEmailIdentityResponse createEmailIdentity(CreateEmailIdentityRequest createEmailIdentityRequest) throws AlreadyExistsException, LimitExceededException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEmailIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEmailIdentityRequest).withMarshaller((Marshaller)new CreateEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetRequest).withMarshaller((Marshaller)new DeleteConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetEventDestinationRequest).withMarshaller((Marshaller)new DeleteConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDedicatedIpPoolResponse deleteDedicatedIpPool(DeleteDedicatedIpPoolRequest deleteDedicatedIpPoolRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDedicatedIpPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDedicatedIpPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDedicatedIpPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDedicatedIpPoolRequest).withMarshaller((Marshaller)new DeleteDedicatedIpPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteEmailIdentityResponse deleteEmailIdentity(DeleteEmailIdentityRequest deleteEmailIdentityRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, ConcurrentModificationException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEmailIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEmailIdentityRequest).withMarshaller((Marshaller)new DeleteEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteSuppressedDestinationResponse deleteSuppressedDestination(DeleteSuppressedDestinationRequest deleteSuppressedDestinationRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSuppressedDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteSuppressedDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSuppressedDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSuppressedDestinationRequest).withMarshaller((Marshaller)new DeleteSuppressedDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetAccountResponse getAccount(GetAccountRequest getAccountRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountRequest).withMarshaller((Marshaller)new GetAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBlacklistReportsResponse getBlacklistReports(GetBlacklistReportsRequest getBlacklistReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlacklistReportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetBlacklistReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlacklistReports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBlacklistReportsRequest).withMarshaller((Marshaller)new GetBlacklistReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetConfigurationSetResponse getConfigurationSet(GetConfigurationSetRequest getConfigurationSetRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConfigurationSetRequest).withMarshaller((Marshaller)new GetConfigurationSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetConfigurationSetEventDestinationsResponse getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigurationSetEventDestinationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetConfigurationSetEventDestinationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfigurationSetEventDestinations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConfigurationSetEventDestinationsRequest).withMarshaller((Marshaller)new GetConfigurationSetEventDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDedicatedIpResponse getDedicatedIp(GetDedicatedIpRequest getDedicatedIpRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDedicatedIpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDedicatedIpRequest).withMarshaller((Marshaller)new GetDedicatedIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDedicatedIpsResponse getDedicatedIps(GetDedicatedIpsRequest getDedicatedIpsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDedicatedIpsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDedicatedIpsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDedicatedIps").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDedicatedIpsRequest).withMarshaller((Marshaller)new GetDedicatedIpsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDedicatedIpsIterable getDedicatedIpsPaginator(GetDedicatedIpsRequest getDedicatedIpsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new GetDedicatedIpsIterable(this, this.applyPaginatorUserAgent(getDedicatedIpsRequest));
    }

    @Override
    public GetDeliverabilityDashboardOptionsResponse getDeliverabilityDashboardOptions(GetDeliverabilityDashboardOptionsRequest getDeliverabilityDashboardOptionsRequest) throws TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverabilityDashboardOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDeliverabilityDashboardOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverabilityDashboardOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDeliverabilityDashboardOptionsRequest).withMarshaller((Marshaller)new GetDeliverabilityDashboardOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDeliverabilityTestReportResponse getDeliverabilityTestReport(GetDeliverabilityTestReportRequest getDeliverabilityTestReportRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeliverabilityTestReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDeliverabilityTestReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDeliverabilityTestReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDeliverabilityTestReportRequest).withMarshaller((Marshaller)new GetDeliverabilityTestReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDomainDeliverabilityCampaignResponse getDomainDeliverabilityCampaign(GetDomainDeliverabilityCampaignRequest getDomainDeliverabilityCampaignRequest) throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainDeliverabilityCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDomainDeliverabilityCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainDeliverabilityCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDomainDeliverabilityCampaignRequest).withMarshaller((Marshaller)new GetDomainDeliverabilityCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDomainStatisticsReportResponse getDomainStatisticsReport(GetDomainStatisticsReportRequest getDomainStatisticsReportRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainStatisticsReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDomainStatisticsReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainStatisticsReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDomainStatisticsReportRequest).withMarshaller((Marshaller)new GetDomainStatisticsReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetEmailIdentityResponse getEmailIdentity(GetEmailIdentityRequest getEmailIdentityRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEmailIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEmailIdentityRequest).withMarshaller((Marshaller)new GetEmailIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetSuppressedDestinationResponse getSuppressedDestination(GetSuppressedDestinationRequest getSuppressedDestinationRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSuppressedDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetSuppressedDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSuppressedDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSuppressedDestinationRequest).withMarshaller((Marshaller)new GetSuppressedDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListConfigurationSetsResponse listConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConfigurationSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListConfigurationSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigurationSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConfigurationSetsRequest).withMarshaller((Marshaller)new ListConfigurationSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListConfigurationSetsIterable listConfigurationSetsPaginator(ListConfigurationSetsRequest listConfigurationSetsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListConfigurationSetsIterable(this, this.applyPaginatorUserAgent(listConfigurationSetsRequest));
    }

    @Override
    public ListDedicatedIpPoolsResponse listDedicatedIpPools(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDedicatedIpPoolsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDedicatedIpPoolsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDedicatedIpPools").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDedicatedIpPoolsRequest).withMarshaller((Marshaller)new ListDedicatedIpPoolsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDedicatedIpPoolsIterable listDedicatedIpPoolsPaginator(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListDedicatedIpPoolsIterable(this, this.applyPaginatorUserAgent(listDedicatedIpPoolsRequest));
    }

    @Override
    public ListDeliverabilityTestReportsResponse listDeliverabilityTestReports(ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeliverabilityTestReportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDeliverabilityTestReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeliverabilityTestReports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDeliverabilityTestReportsRequest).withMarshaller((Marshaller)new ListDeliverabilityTestReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDeliverabilityTestReportsIterable listDeliverabilityTestReportsPaginator(ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) throws TooManyRequestsException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListDeliverabilityTestReportsIterable(this, this.applyPaginatorUserAgent(listDeliverabilityTestReportsRequest));
    }

    @Override
    public ListDomainDeliverabilityCampaignsResponse listDomainDeliverabilityCampaigns(ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainDeliverabilityCampaignsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDomainDeliverabilityCampaignsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainDeliverabilityCampaigns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDomainDeliverabilityCampaignsRequest).withMarshaller((Marshaller)new ListDomainDeliverabilityCampaignsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDomainDeliverabilityCampaignsIterable listDomainDeliverabilityCampaignsPaginator(ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) throws TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListDomainDeliverabilityCampaignsIterable(this, this.applyPaginatorUserAgent(listDomainDeliverabilityCampaignsRequest));
    }

    @Override
    public ListEmailIdentitiesResponse listEmailIdentities(ListEmailIdentitiesRequest listEmailIdentitiesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEmailIdentitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListEmailIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEmailIdentities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEmailIdentitiesRequest).withMarshaller((Marshaller)new ListEmailIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListEmailIdentitiesIterable listEmailIdentitiesPaginator(ListEmailIdentitiesRequest listEmailIdentitiesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListEmailIdentitiesIterable(this, this.applyPaginatorUserAgent(listEmailIdentitiesRequest));
    }

    @Override
    public ListSuppressedDestinationsResponse listSuppressedDestinations(ListSuppressedDestinationsRequest listSuppressedDestinationsRequest) throws BadRequestException, TooManyRequestsException, InvalidNextTokenException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSuppressedDestinationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListSuppressedDestinationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSuppressedDestinations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSuppressedDestinationsRequest).withMarshaller((Marshaller)new ListSuppressedDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListSuppressedDestinationsIterable listSuppressedDestinationsPaginator(ListSuppressedDestinationsRequest listSuppressedDestinationsRequest) throws BadRequestException, TooManyRequestsException, InvalidNextTokenException, AwsServiceException, SdkClientException, SesV2Exception {
        return new ListSuppressedDestinationsIterable(this, this.applyPaginatorUserAgent(listSuppressedDestinationsRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutAccountDedicatedIpWarmupAttributesResponse putAccountDedicatedIpWarmupAttributes(PutAccountDedicatedIpWarmupAttributesRequest putAccountDedicatedIpWarmupAttributesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountDedicatedIpWarmupAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutAccountDedicatedIpWarmupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountDedicatedIpWarmupAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAccountDedicatedIpWarmupAttributesRequest).withMarshaller((Marshaller)new PutAccountDedicatedIpWarmupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutAccountSendingAttributesResponse putAccountSendingAttributes(PutAccountSendingAttributesRequest putAccountSendingAttributesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSendingAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutAccountSendingAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSendingAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAccountSendingAttributesRequest).withMarshaller((Marshaller)new PutAccountSendingAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutAccountSuppressionAttributesResponse putAccountSuppressionAttributes(PutAccountSuppressionAttributesRequest putAccountSuppressionAttributesRequest) throws TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountSuppressionAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutAccountSuppressionAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountSuppressionAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAccountSuppressionAttributesRequest).withMarshaller((Marshaller)new PutAccountSuppressionAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutConfigurationSetDeliveryOptionsResponse putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetDeliveryOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutConfigurationSetDeliveryOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetDeliveryOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetDeliveryOptionsRequest).withMarshaller((Marshaller)new PutConfigurationSetDeliveryOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutConfigurationSetReputationOptionsResponse putConfigurationSetReputationOptions(PutConfigurationSetReputationOptionsRequest putConfigurationSetReputationOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetReputationOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutConfigurationSetReputationOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetReputationOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetReputationOptionsRequest).withMarshaller((Marshaller)new PutConfigurationSetReputationOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutConfigurationSetSendingOptionsResponse putConfigurationSetSendingOptions(PutConfigurationSetSendingOptionsRequest putConfigurationSetSendingOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetSendingOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutConfigurationSetSendingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetSendingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetSendingOptionsRequest).withMarshaller((Marshaller)new PutConfigurationSetSendingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutConfigurationSetSuppressionOptionsResponse putConfigurationSetSuppressionOptions(PutConfigurationSetSuppressionOptionsRequest putConfigurationSetSuppressionOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetSuppressionOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutConfigurationSetSuppressionOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetSuppressionOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetSuppressionOptionsRequest).withMarshaller((Marshaller)new PutConfigurationSetSuppressionOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutConfigurationSetTrackingOptionsResponse putConfigurationSetTrackingOptions(PutConfigurationSetTrackingOptionsRequest putConfigurationSetTrackingOptionsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfigurationSetTrackingOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutConfigurationSetTrackingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfigurationSetTrackingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationSetTrackingOptionsRequest).withMarshaller((Marshaller)new PutConfigurationSetTrackingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutDedicatedIpInPoolResponse putDedicatedIpInPool(PutDedicatedIpInPoolRequest putDedicatedIpInPoolRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpInPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutDedicatedIpInPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpInPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDedicatedIpInPoolRequest).withMarshaller((Marshaller)new PutDedicatedIpInPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutDedicatedIpWarmupAttributesResponse putDedicatedIpWarmupAttributes(PutDedicatedIpWarmupAttributesRequest putDedicatedIpWarmupAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDedicatedIpWarmupAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutDedicatedIpWarmupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDedicatedIpWarmupAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDedicatedIpWarmupAttributesRequest).withMarshaller((Marshaller)new PutDedicatedIpWarmupAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutDeliverabilityDashboardOptionResponse putDeliverabilityDashboardOption(PutDeliverabilityDashboardOptionRequest putDeliverabilityDashboardOptionRequest) throws AlreadyExistsException, NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDeliverabilityDashboardOptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutDeliverabilityDashboardOptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDeliverabilityDashboardOption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDeliverabilityDashboardOptionRequest).withMarshaller((Marshaller)new PutDeliverabilityDashboardOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutEmailIdentityDkimAttributesResponse putEmailIdentityDkimAttributes(PutEmailIdentityDkimAttributesRequest putEmailIdentityDkimAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityDkimAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutEmailIdentityDkimAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityDkimAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEmailIdentityDkimAttributesRequest).withMarshaller((Marshaller)new PutEmailIdentityDkimAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutEmailIdentityDkimSigningAttributesResponse putEmailIdentityDkimSigningAttributes(PutEmailIdentityDkimSigningAttributesRequest putEmailIdentityDkimSigningAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityDkimSigningAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutEmailIdentityDkimSigningAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityDkimSigningAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEmailIdentityDkimSigningAttributesRequest).withMarshaller((Marshaller)new PutEmailIdentityDkimSigningAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutEmailIdentityFeedbackAttributesResponse putEmailIdentityFeedbackAttributes(PutEmailIdentityFeedbackAttributesRequest putEmailIdentityFeedbackAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityFeedbackAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutEmailIdentityFeedbackAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityFeedbackAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEmailIdentityFeedbackAttributesRequest).withMarshaller((Marshaller)new PutEmailIdentityFeedbackAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutEmailIdentityMailFromAttributesResponse putEmailIdentityMailFromAttributes(PutEmailIdentityMailFromAttributesRequest putEmailIdentityMailFromAttributesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEmailIdentityMailFromAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutEmailIdentityMailFromAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEmailIdentityMailFromAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEmailIdentityMailFromAttributesRequest).withMarshaller((Marshaller)new PutEmailIdentityMailFromAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutSuppressedDestinationResponse putSuppressedDestination(PutSuppressedDestinationRequest putSuppressedDestinationRequest) throws BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSuppressedDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutSuppressedDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSuppressedDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putSuppressedDestinationRequest).withMarshaller((Marshaller)new PutSuppressedDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SendEmailResponse sendEmail(SendEmailRequest sendEmailRequest) throws TooManyRequestsException, LimitExceededException, AccountSuspendedException, SendingPausedException, MessageRejectedException, MailFromDomainNotVerifiedException, NotFoundException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendEmailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SendEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendEmailRequest).withMarshaller((Marshaller)new SendEmailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, ConcurrentModificationException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, SesV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetEventDestinationRequest).withMarshaller((Marshaller)new UpdateConfigurationSetEventDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SesV2Exception::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MessageRejected").exceptionBuilderSupplier(MessageRejectedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SendingPausedException").exceptionBuilderSupplier(SendingPausedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountSuspendedException").exceptionBuilderSupplier(AccountSuspendedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SesV2Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.18").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SesV2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

