/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to send an email message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendEmailRequest extends SesV2Request implements ToCopyableBuilder<SendEmailRequest.Builder, SendEmailRequest> {
    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendEmailRequest::fromEmailAddress)).setter(setter(Builder::fromEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()).build();

    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .getter(getter(SendEmailRequest::destination)).setter(setter(Builder::destination)).constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<List<String>> REPLY_TO_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SendEmailRequest::replyToAddresses))
            .setter(setter(Builder::replyToAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FEEDBACK_FORWARDING_EMAIL_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SendEmailRequest::feedbackForwardingEmailAddress))
            .setter(setter(Builder::feedbackForwardingEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingEmailAddress")
                    .build()).build();

    private static final SdkField<EmailContent> CONTENT_FIELD = SdkField.<EmailContent> builder(MarshallingType.SDK_POJO)
            .getter(getter(SendEmailRequest::content)).setter(setter(Builder::content)).constructor(EmailContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<List<MessageTag>> EMAIL_TAGS_FIELD = SdkField
            .<List<MessageTag>> builder(MarshallingType.LIST)
            .getter(getter(SendEmailRequest::emailTags))
            .setter(setter(Builder::emailTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendEmailRequest::configurationSetName)).setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_EMAIL_ADDRESS_FIELD,
            DESTINATION_FIELD, REPLY_TO_ADDRESSES_FIELD, FEEDBACK_FORWARDING_EMAIL_ADDRESS_FIELD, CONTENT_FIELD,
            EMAIL_TAGS_FIELD, CONFIGURATION_SET_NAME_FIELD));

    private final String fromEmailAddress;

    private final Destination destination;

    private final List<String> replyToAddresses;

    private final String feedbackForwardingEmailAddress;

    private final EmailContent content;

    private final List<MessageTag> emailTags;

    private final String configurationSetName;

    private SendEmailRequest(BuilderImpl builder) {
        super(builder);
        this.fromEmailAddress = builder.fromEmailAddress;
        this.destination = builder.destination;
        this.replyToAddresses = builder.replyToAddresses;
        this.feedbackForwardingEmailAddress = builder.feedbackForwardingEmailAddress;
        this.content = builder.content;
        this.emailTags = builder.emailTags;
        this.configurationSetName = builder.configurationSetName;
    }

    /**
     * <p>
     * The email address that you want to use as the "From" address for the email. The address that you specify has to
     * be verified.
     * </p>
     * 
     * @return The email address that you want to use as the "From" address for the email. The address that you specify
     *         has to be verified.
     */
    public String fromEmailAddress() {
        return fromEmailAddress;
    }

    /**
     * <p>
     * An object that contains the recipients of the email message.
     * </p>
     * 
     * @return An object that contains the recipients of the email message.
     */
    public Destination destination() {
        return destination;
    }

    /**
     * Returns true if the ReplyToAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReplyToAddresses() {
        return replyToAddresses != null && !(replyToAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address
     * receives the reply.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplyToAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to
     *         address receives the reply.
     */
    public List<String> replyToAddresses() {
        return replyToAddresses;
    }

    /**
     * <p>
     * The address that you want bounce and complaint notifications to be sent to.
     * </p>
     * 
     * @return The address that you want bounce and complaint notifications to be sent to.
     */
    public String feedbackForwardingEmailAddress() {
        return feedbackForwardingEmailAddress;
    }

    /**
     * <p>
     * An object that contains the body of the message. You can send either a Simple message or a Raw message.
     * </p>
     * 
     * @return An object that contains the body of the message. You can send either a Simple message or a Raw message.
     */
    public EmailContent content() {
        return content;
    }

    /**
     * Returns true if the EmailTags property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEmailTags() {
        return emailTags != null && !(emailTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
     * <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you
     * can publish email sending events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEmailTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags, in the form of name/value pairs, to apply to an email that you send using the
     *         <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so
     *         that you can publish email sending events.
     */
    public List<MessageTag> emailTags() {
        return emailTags;
    }

    /**
     * <p>
     * The name of the configuration set that you want to use when sending the email.
     * </p>
     * 
     * @return The name of the configuration set that you want to use when sending the email.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(replyToAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackForwardingEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(emailTags());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendEmailRequest)) {
            return false;
        }
        SendEmailRequest other = (SendEmailRequest) obj;
        return Objects.equals(fromEmailAddress(), other.fromEmailAddress()) && Objects.equals(destination(), other.destination())
                && Objects.equals(replyToAddresses(), other.replyToAddresses())
                && Objects.equals(feedbackForwardingEmailAddress(), other.feedbackForwardingEmailAddress())
                && Objects.equals(content(), other.content()) && Objects.equals(emailTags(), other.emailTags())
                && Objects.equals(configurationSetName(), other.configurationSetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SendEmailRequest").add("FromEmailAddress", fromEmailAddress()).add("Destination", destination())
                .add("ReplyToAddresses", replyToAddresses())
                .add("FeedbackForwardingEmailAddress", feedbackForwardingEmailAddress()).add("Content", content())
                .add("EmailTags", emailTags()).add("ConfigurationSetName", configurationSetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromEmailAddress":
            return Optional.ofNullable(clazz.cast(fromEmailAddress()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "ReplyToAddresses":
            return Optional.ofNullable(clazz.cast(replyToAddresses()));
        case "FeedbackForwardingEmailAddress":
            return Optional.ofNullable(clazz.cast(feedbackForwardingEmailAddress()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "EmailTags":
            return Optional.ofNullable(clazz.cast(emailTags()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendEmailRequest, T> g) {
        return obj -> g.apply((SendEmailRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, SendEmailRequest> {
        /**
         * <p>
         * The email address that you want to use as the "From" address for the email. The address that you specify has
         * to be verified.
         * </p>
         * 
         * @param fromEmailAddress
         *        The email address that you want to use as the "From" address for the email. The address that you
         *        specify has to be verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromEmailAddress(String fromEmailAddress);

        /**
         * <p>
         * An object that contains the recipients of the email message.
         * </p>
         * 
         * @param destination
         *        An object that contains the recipients of the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * An object that contains the recipients of the email message.
         * </p>
         * This is a convenience that creates an instance of the {@link Destination.Builder} avoiding the need to create
         * one manually via {@link Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to
         * address receives the reply.
         * </p>
         * 
         * @param replyToAddresses
         *        The "Reply-to" email addresses for the message. When the recipient replies to the message, each
         *        Reply-to address receives the reply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replyToAddresses(Collection<String> replyToAddresses);

        /**
         * <p>
         * The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to
         * address receives the reply.
         * </p>
         * 
         * @param replyToAddresses
         *        The "Reply-to" email addresses for the message. When the recipient replies to the message, each
         *        Reply-to address receives the reply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replyToAddresses(String... replyToAddresses);

        /**
         * <p>
         * The address that you want bounce and complaint notifications to be sent to.
         * </p>
         * 
         * @param feedbackForwardingEmailAddress
         *        The address that you want bounce and complaint notifications to be sent to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackForwardingEmailAddress(String feedbackForwardingEmailAddress);

        /**
         * <p>
         * An object that contains the body of the message. You can send either a Simple message or a Raw message.
         * </p>
         * 
         * @param content
         *        An object that contains the body of the message. You can send either a Simple message or a Raw
         *        message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(EmailContent content);

        /**
         * <p>
         * An object that contains the body of the message. You can send either a Simple message or a Raw message.
         * </p>
         * This is a convenience that creates an instance of the {@link EmailContent.Builder} avoiding the need to
         * create one manually via {@link EmailContent#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmailContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(EmailContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link EmailContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(EmailContent)
         */
        default Builder content(Consumer<EmailContent.Builder> content) {
            return content(EmailContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         * <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that
         * you can publish email sending events.
         * </p>
         * 
         * @param emailTags
         *        A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         *        <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so
         *        that you can publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailTags(Collection<MessageTag> emailTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         * <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that
         * you can publish email sending events.
         * </p>
         * 
         * @param emailTags
         *        A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         *        <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so
         *        that you can publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailTags(MessageTag... emailTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         * <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that
         * you can publish email sending events.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MessageTag>.Builder} avoiding the need to
         * create one manually via {@link List<MessageTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MessageTag>.Builder#build()} is called immediately and its
         * result is passed to {@link #emailTags(List<MessageTag>)}.
         * 
         * @param emailTags
         *        a consumer that will call methods on {@link List<MessageTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailTags(List<MessageTag>)
         */
        Builder emailTags(Consumer<MessageTag.Builder>... emailTags);

        /**
         * <p>
         * The name of the configuration set that you want to use when sending the email.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set that you want to use when sending the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String fromEmailAddress;

        private Destination destination;

        private List<String> replyToAddresses = DefaultSdkAutoConstructList.getInstance();

        private String feedbackForwardingEmailAddress;

        private EmailContent content;

        private List<MessageTag> emailTags = DefaultSdkAutoConstructList.getInstance();

        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendEmailRequest model) {
            super(model);
            fromEmailAddress(model.fromEmailAddress);
            destination(model.destination);
            replyToAddresses(model.replyToAddresses);
            feedbackForwardingEmailAddress(model.feedbackForwardingEmailAddress);
            content(model.content);
            emailTags(model.emailTags);
            configurationSetName(model.configurationSetName);
        }

        public final String getFromEmailAddress() {
            return fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Collection<String> getReplyToAddresses() {
            return replyToAddresses;
        }

        @Override
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = EmailAddressListCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replyToAddresses(String... replyToAddresses) {
            replyToAddresses(Arrays.asList(replyToAddresses));
            return this;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = EmailAddressListCopier.copy(replyToAddresses);
        }

        public final String getFeedbackForwardingEmailAddress() {
            return feedbackForwardingEmailAddress;
        }

        @Override
        public final Builder feedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
            this.feedbackForwardingEmailAddress = feedbackForwardingEmailAddress;
            return this;
        }

        public final void setFeedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
            this.feedbackForwardingEmailAddress = feedbackForwardingEmailAddress;
        }

        public final EmailContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        @Override
        public final Builder content(EmailContent content) {
            this.content = content;
            return this;
        }

        public final void setContent(EmailContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        public final Collection<MessageTag.Builder> getEmailTags() {
            return emailTags != null ? emailTags.stream().map(MessageTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder emailTags(Collection<MessageTag> emailTags) {
            this.emailTags = MessageTagListCopier.copy(emailTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailTags(MessageTag... emailTags) {
            emailTags(Arrays.asList(emailTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailTags(Consumer<MessageTag.Builder>... emailTags) {
            emailTags(Stream.of(emailTags).map(c -> MessageTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEmailTags(Collection<MessageTag.BuilderImpl> emailTags) {
            this.emailTags = MessageTagListCopier.copyFromBuilder(emailTags);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendEmailRequest build() {
            return new SendEmailRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
