/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If the action is successful, the service sends back an HTTP 200 response.
 * </p>
 * <p>
 * The following data is returned in JSON format by the service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEmailIdentityDkimSigningAttributesResponse extends SesV2Response implements
        ToCopyableBuilder<PutEmailIdentityDkimSigningAttributesResponse.Builder, PutEmailIdentityDkimSigningAttributesResponse> {
    private static final SdkField<String> DKIM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEmailIdentityDkimSigningAttributesResponse::dkimStatusAsString))
            .setter(setter(Builder::dkimStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimStatus").build()).build();

    private static final SdkField<List<String>> DKIM_TOKENS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PutEmailIdentityDkimSigningAttributesResponse::dkimTokens))
            .setter(setter(Builder::dkimTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimTokens").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DKIM_STATUS_FIELD,
            DKIM_TOKENS_FIELD));

    private final String dkimStatus;

    private final List<String> dkimTokens;

    private PutEmailIdentityDkimSigningAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.dkimStatus = builder.dkimStatus;
        this.dkimTokens = builder.dkimTokens;
    }

    /**
     * <p>
     * The DKIM authentication status of the identity. Amazon SES determines the authentication status by searching for
     * specific records in the DNS configuration for your domain. If you used <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up DKIM
     * authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your domain.
     * </p>
     * <p>
     * If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that uses the
     * selector that you specified. The value of the TXT record must be a public key that's paired with the private key
     * that you specified in the process of creating the identity.
     * </p>
     * <p>
     * The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet detected the DKIM
     * records in the DNS configuration for the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – The verification process completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to find the
     * DKIM records in the DNS configuration of the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM
     * authentication status of the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_STARTED</code> – The DKIM verification process hasn't been initiated for the domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dkimStatus} will
     * return {@link DkimStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dkimStatusAsString}.
     * </p>
     * 
     * @return The DKIM authentication status of the identity. Amazon SES determines the authentication status by
     *         searching for specific records in the DNS configuration for your domain. If you used <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up DKIM
     *         authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your
     *         domain.</p>
     *         <p>
     *         If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that
     *         uses the selector that you specified. The value of the TXT record must be a public key that's paired with
     *         the private key that you specified in the process of creating the identity.
     *         </p>
     *         <p>
     *         The status can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet detected the
     *         DKIM records in the DNS configuration for the domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – The verification process completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to
     *         find the DKIM records in the DNS configuration of the domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM
     *         authentication status of the domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_STARTED</code> – The DKIM verification process hasn't been initiated for the domain.
     *         </p>
     *         </li>
     * @see DkimStatus
     */
    public DkimStatus dkimStatus() {
        return DkimStatus.fromValue(dkimStatus);
    }

    /**
     * <p>
     * The DKIM authentication status of the identity. Amazon SES determines the authentication status by searching for
     * specific records in the DNS configuration for your domain. If you used <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up DKIM
     * authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your domain.
     * </p>
     * <p>
     * If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that uses the
     * selector that you specified. The value of the TXT record must be a public key that's paired with the private key
     * that you specified in the process of creating the identity.
     * </p>
     * <p>
     * The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet detected the DKIM
     * records in the DNS configuration for the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – The verification process completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to find the
     * DKIM records in the DNS configuration of the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM
     * authentication status of the domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_STARTED</code> – The DKIM verification process hasn't been initiated for the domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dkimStatus} will
     * return {@link DkimStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dkimStatusAsString}.
     * </p>
     * 
     * @return The DKIM authentication status of the identity. Amazon SES determines the authentication status by
     *         searching for specific records in the DNS configuration for your domain. If you used <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up DKIM
     *         authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your
     *         domain.</p>
     *         <p>
     *         If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that
     *         uses the selector that you specified. The value of the TXT record must be a public key that's paired with
     *         the private key that you specified in the process of creating the identity.
     *         </p>
     *         <p>
     *         The status can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet detected the
     *         DKIM records in the DNS configuration for the domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – The verification process completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to
     *         find the DKIM records in the DNS configuration of the domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM
     *         authentication status of the domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_STARTED</code> – The DKIM verification process hasn't been initiated for the domain.
     *         </p>
     *         </li>
     * @see DkimStatus
     */
    public String dkimStatusAsString() {
        return dkimStatus;
    }

    /**
     * Returns true if the DkimTokens property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDkimTokens() {
        return dkimTokens != null && !(dkimTokens instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to
     * configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to
     * create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects
     * these records in the DNS configuration for your domain, the DKIM authentication process is complete.
     * </p>
     * <p>
     * If you configured DKIM authentication for the domain by providing your own public-private key pair, then this
     * object contains the selector that's associated with your public key.
     * </p>
     * <p>
     * Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in the DNS
     * configuration of the domain for up to 72 hours.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDkimTokens()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>
     *         to configure DKIM authentication for the domain, then this object contains a set of unique strings that
     *         you use to create a set of CNAME records that you add to the DNS configuration for your domain. When
     *         Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication
     *         process is complete.</p>
     *         <p>
     *         If you configured DKIM authentication for the domain by providing your own public-private key pair, then
     *         this object contains the selector that's associated with your public key.
     *         </p>
     *         <p>
     *         Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in
     *         the DNS configuration of the domain for up to 72 hours.
     */
    public List<String> dkimTokens() {
        return dkimTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dkimStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dkimTokens());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEmailIdentityDkimSigningAttributesResponse)) {
            return false;
        }
        PutEmailIdentityDkimSigningAttributesResponse other = (PutEmailIdentityDkimSigningAttributesResponse) obj;
        return Objects.equals(dkimStatusAsString(), other.dkimStatusAsString())
                && Objects.equals(dkimTokens(), other.dkimTokens());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutEmailIdentityDkimSigningAttributesResponse").add("DkimStatus", dkimStatusAsString())
                .add("DkimTokens", dkimTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DkimStatus":
            return Optional.ofNullable(clazz.cast(dkimStatusAsString()));
        case "DkimTokens":
            return Optional.ofNullable(clazz.cast(dkimTokens()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEmailIdentityDkimSigningAttributesResponse, T> g) {
        return obj -> g.apply((PutEmailIdentityDkimSigningAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, PutEmailIdentityDkimSigningAttributesResponse> {
        /**
         * <p>
         * The DKIM authentication status of the identity. Amazon SES determines the authentication status by searching
         * for specific records in the DNS configuration for your domain. If you used <a
         * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up DKIM
         * authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your domain.
         * </p>
         * <p>
         * If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that uses
         * the selector that you specified. The value of the TXT record must be a public key that's paired with the
         * private key that you specified in the process of creating the identity.
         * </p>
         * <p>
         * The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet detected the DKIM
         * records in the DNS configuration for the domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – The verification process completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to find
         * the DKIM records in the DNS configuration of the domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM
         * authentication status of the domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_STARTED</code> – The DKIM verification process hasn't been initiated for the domain.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dkimStatus
         *        The DKIM authentication status of the identity. Amazon SES determines the authentication status by
         *        searching for specific records in the DNS configuration for your domain. If you used <a
         *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up
         *        DKIM authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for
         *        your domain.</p>
         *        <p>
         *        If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record
         *        that uses the selector that you specified. The value of the TXT record must be a public key that's
         *        paired with the private key that you specified in the process of creating the identity.
         *        </p>
         *        <p>
         *        The status can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet detected the
         *        DKIM records in the DNS configuration for the domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – The verification process completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to
         *        find the DKIM records in the DNS configuration of the domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM
         *        authentication status of the domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_STARTED</code> – The DKIM verification process hasn't been initiated for the domain.
         *        </p>
         *        </li>
         * @see DkimStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DkimStatus
         */
        Builder dkimStatus(String dkimStatus);

        /**
         * <p>
         * The DKIM authentication status of the identity. Amazon SES determines the authentication status by searching
         * for specific records in the DNS configuration for your domain. If you used <a
         * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up DKIM
         * authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your domain.
         * </p>
         * <p>
         * If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that uses
         * the selector that you specified. The value of the TXT record must be a public key that's paired with the
         * private key that you specified in the process of creating the identity.
         * </p>
         * <p>
         * The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet detected the DKIM
         * records in the DNS configuration for the domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – The verification process completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to find
         * the DKIM records in the DNS configuration of the domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM
         * authentication status of the domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_STARTED</code> – The DKIM verification process hasn't been initiated for the domain.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dkimStatus
         *        The DKIM authentication status of the identity. Amazon SES determines the authentication status by
         *        searching for specific records in the DNS configuration for your domain. If you used <a
         *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up
         *        DKIM authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for
         *        your domain.</p>
         *        <p>
         *        If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record
         *        that uses the selector that you specified. The value of the TXT record must be a public key that's
         *        paired with the private key that you specified in the process of creating the identity.
         *        </p>
         *        <p>
         *        The status can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet detected the
         *        DKIM records in the DNS configuration for the domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – The verification process completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to
         *        find the DKIM records in the DNS configuration of the domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM
         *        authentication status of the domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_STARTED</code> – The DKIM verification process hasn't been initiated for the domain.
         *        </p>
         *        </li>
         * @see DkimStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DkimStatus
         */
        Builder dkimStatus(DkimStatus dkimStatus);

        /**
         * <p>
         * If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to
         * configure DKIM authentication for the domain, then this object contains a set of unique strings that you use
         * to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES
         * detects these records in the DNS configuration for your domain, the DKIM authentication process is complete.
         * </p>
         * <p>
         * If you configured DKIM authentication for the domain by providing your own public-private key pair, then this
         * object contains the selector that's associated with your public key.
         * </p>
         * <p>
         * Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in the
         * DNS configuration of the domain for up to 72 hours.
         * </p>
         * 
         * @param dkimTokens
         *        If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy
         *        DKIM</a> to configure DKIM authentication for the domain, then this object contains a set of unique
         *        strings that you use to create a set of CNAME records that you add to the DNS configuration for your
         *        domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM
         *        authentication process is complete.</p>
         *        <p>
         *        If you configured DKIM authentication for the domain by providing your own public-private key pair,
         *        then this object contains the selector that's associated with your public key.
         *        </p>
         *        <p>
         *        Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records
         *        in the DNS configuration of the domain for up to 72 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimTokens(Collection<String> dkimTokens);

        /**
         * <p>
         * If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to
         * configure DKIM authentication for the domain, then this object contains a set of unique strings that you use
         * to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES
         * detects these records in the DNS configuration for your domain, the DKIM authentication process is complete.
         * </p>
         * <p>
         * If you configured DKIM authentication for the domain by providing your own public-private key pair, then this
         * object contains the selector that's associated with your public key.
         * </p>
         * <p>
         * Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in the
         * DNS configuration of the domain for up to 72 hours.
         * </p>
         * 
         * @param dkimTokens
         *        If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy
         *        DKIM</a> to configure DKIM authentication for the domain, then this object contains a set of unique
         *        strings that you use to create a set of CNAME records that you add to the DNS configuration for your
         *        domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM
         *        authentication process is complete.</p>
         *        <p>
         *        If you configured DKIM authentication for the domain by providing your own public-private key pair,
         *        then this object contains the selector that's associated with your public key.
         *        </p>
         *        <p>
         *        Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records
         *        in the DNS configuration of the domain for up to 72 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimTokens(String... dkimTokens);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String dkimStatus;

        private List<String> dkimTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEmailIdentityDkimSigningAttributesResponse model) {
            super(model);
            dkimStatus(model.dkimStatus);
            dkimTokens(model.dkimTokens);
        }

        public final String getDkimStatusAsString() {
            return dkimStatus;
        }

        @Override
        public final Builder dkimStatus(String dkimStatus) {
            this.dkimStatus = dkimStatus;
            return this;
        }

        @Override
        public final Builder dkimStatus(DkimStatus dkimStatus) {
            this.dkimStatus(dkimStatus == null ? null : dkimStatus.toString());
            return this;
        }

        public final void setDkimStatus(String dkimStatus) {
            this.dkimStatus = dkimStatus;
        }

        public final Collection<String> getDkimTokens() {
            return dkimTokens;
        }

        @Override
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = DnsTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dkimTokens(String... dkimTokens) {
            dkimTokens(Arrays.asList(dkimTokens));
            return this;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = DnsTokenListCopier.copy(dkimTokens);
        }

        @Override
        public PutEmailIdentityDkimSigningAttributesResponse build() {
            return new PutEmailIdentityDkimSigningAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
