/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to change the ability of your account to send email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountSendingAttributesRequest extends SesV2Request implements
        ToCopyableBuilder<PutAccountSendingAttributesRequest.Builder, PutAccountSendingAttributesRequest> {
    private static final SdkField<Boolean> SENDING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutAccountSendingAttributesRequest::sendingEnabled)).setter(setter(Builder::sendingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDING_ENABLED_FIELD));

    private final Boolean sendingEnabled;

    private PutAccountSendingAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.sendingEnabled = builder.sendingEnabled;
    }

    /**
     * <p>
     * Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or
     * set to <code>false</code> to disable email sending.
     * </p>
     * <note>
     * <p>
     * If AWS paused your account's ability to send email, you can't use this operation to resume your account's ability
     * to send email.
     * </p>
     * </note>
     * 
     * @return Enables or disables your account's ability to send email. Set to <code>true</code> to enable email
     *         sending, or set to <code>false</code> to disable email sending.</p> <note>
     *         <p>
     *         If AWS paused your account's ability to send email, you can't use this operation to resume your account's
     *         ability to send email.
     *         </p>
     */
    public Boolean sendingEnabled() {
        return sendingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sendingEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountSendingAttributesRequest)) {
            return false;
        }
        PutAccountSendingAttributesRequest other = (PutAccountSendingAttributesRequest) obj;
        return Objects.equals(sendingEnabled(), other.sendingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutAccountSendingAttributesRequest").add("SendingEnabled", sendingEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SendingEnabled":
            return Optional.ofNullable(clazz.cast(sendingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountSendingAttributesRequest, T> g) {
        return obj -> g.apply((PutAccountSendingAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, PutAccountSendingAttributesRequest> {
        /**
         * <p>
         * Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending,
         * or set to <code>false</code> to disable email sending.
         * </p>
         * <note>
         * <p>
         * If AWS paused your account's ability to send email, you can't use this operation to resume your account's
         * ability to send email.
         * </p>
         * </note>
         * 
         * @param sendingEnabled
         *        Enables or disables your account's ability to send email. Set to <code>true</code> to enable email
         *        sending, or set to <code>false</code> to disable email sending.</p> <note>
         *        <p>
         *        If AWS paused your account's ability to send email, you can't use this operation to resume your
         *        account's ability to send email.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingEnabled(Boolean sendingEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private Boolean sendingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountSendingAttributesRequest model) {
            super(model);
            sendingEnabled(model.sendingEnabled);
        }

        public final Boolean getSendingEnabled() {
            return sendingEnabled;
        }

        @Override
        public final Builder sendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
            return this;
        }

        public final void setSendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountSendingAttributesRequest build() {
            return new PutAccountSendingAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
