/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of attributes that are associated with a MAIL FROM domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MailFromAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<MailFromAttributes.Builder, MailFromAttributes> {
    private static final SdkField<String> MAIL_FROM_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MailFromAttributes::mailFromDomain)).setter(setter(Builder::mailFromDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomain").build()).build();

    private static final SdkField<String> MAIL_FROM_DOMAIN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MailFromAttributes::mailFromDomainStatusAsString)).setter(setter(Builder::mailFromDomainStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomainStatus").build())
            .build();

    private static final SdkField<String> BEHAVIOR_ON_MX_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MailFromAttributes::behaviorOnMxFailureAsString)).setter(setter(Builder::behaviorOnMxFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BehaviorOnMxFailure").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAIL_FROM_DOMAIN_FIELD,
            MAIL_FROM_DOMAIN_STATUS_FIELD, BEHAVIOR_ON_MX_FAILURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mailFromDomain;

    private final String mailFromDomainStatus;

    private final String behaviorOnMxFailure;

    private MailFromAttributes(BuilderImpl builder) {
        this.mailFromDomain = builder.mailFromDomain;
        this.mailFromDomainStatus = builder.mailFromDomainStatus;
        this.behaviorOnMxFailure = builder.behaviorOnMxFailure;
    }

    /**
     * <p>
     * The name of a domain that an email identity uses as a custom MAIL FROM domain.
     * </p>
     * 
     * @return The name of a domain that an email identity uses as a custom MAIL FROM domain.
     */
    public String mailFromDomain() {
        return mailFromDomain;
    }

    /**
     * <p>
     * The status of the MAIL FROM domain. This status can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – Amazon SES hasn't started searching for the MX record yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – Amazon SES can't find the required MX record, or the record no longer exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from determining the
     * status of the MAIL FROM domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mailFromDomainStatus} will return {@link MailFromDomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mailFromDomainStatusAsString}.
     * </p>
     * 
     * @return The status of the MAIL FROM domain. This status can have the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – Amazon SES hasn't started searching for the MX record yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – Amazon SES can't find the required MX record, or the record no longer exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from determining
     *         the status of the MAIL FROM domain.
     *         </p>
     *         </li>
     * @see MailFromDomainStatus
     */
    public MailFromDomainStatus mailFromDomainStatus() {
        return MailFromDomainStatus.fromValue(mailFromDomainStatus);
    }

    /**
     * <p>
     * The status of the MAIL FROM domain. This status can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – Amazon SES hasn't started searching for the MX record yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – Amazon SES can't find the required MX record, or the record no longer exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from determining the
     * status of the MAIL FROM domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mailFromDomainStatus} will return {@link MailFromDomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mailFromDomainStatusAsString}.
     * </p>
     * 
     * @return The status of the MAIL FROM domain. This status can have the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – Amazon SES hasn't started searching for the MX record yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – Amazon SES can't find the required MX record, or the record no longer exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from determining
     *         the status of the MAIL FROM domain.
     *         </p>
     *         </li>
     * @see MailFromDomainStatus
     */
    public String mailFromDomainStatusAsString() {
        return mailFromDomainStatus;
    }

    /**
     * <p>
     * The action that you want to take if the required MX record can't be found when you send an email. When you set
     * this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain.
     * When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
     * <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
     * </p>
     * <p>
     * These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
     * <code>Failed</code>, and <code>TemporaryFailure</code> states.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #behaviorOnMxFailure} will return {@link BehaviorOnMxFailure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #behaviorOnMxFailureAsString}.
     * </p>
     * 
     * @return The action that you want to take if the required MX record can't be found when you send an email. When
     *         you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the
     *         MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
     *         <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
     *         <p>
     *         These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
     *         <code>Failed</code>, and <code>TemporaryFailure</code> states.
     * @see BehaviorOnMxFailure
     */
    public BehaviorOnMxFailure behaviorOnMxFailure() {
        return BehaviorOnMxFailure.fromValue(behaviorOnMxFailure);
    }

    /**
     * <p>
     * The action that you want to take if the required MX record can't be found when you send an email. When you set
     * this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain.
     * When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
     * <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
     * </p>
     * <p>
     * These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
     * <code>Failed</code>, and <code>TemporaryFailure</code> states.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #behaviorOnMxFailure} will return {@link BehaviorOnMxFailure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #behaviorOnMxFailureAsString}.
     * </p>
     * 
     * @return The action that you want to take if the required MX record can't be found when you send an email. When
     *         you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the
     *         MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
     *         <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
     *         <p>
     *         These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
     *         <code>Failed</code>, and <code>TemporaryFailure</code> states.
     * @see BehaviorOnMxFailure
     */
    public String behaviorOnMxFailureAsString() {
        return behaviorOnMxFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mailFromDomain());
        hashCode = 31 * hashCode + Objects.hashCode(mailFromDomainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(behaviorOnMxFailureAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MailFromAttributes)) {
            return false;
        }
        MailFromAttributes other = (MailFromAttributes) obj;
        return Objects.equals(mailFromDomain(), other.mailFromDomain())
                && Objects.equals(mailFromDomainStatusAsString(), other.mailFromDomainStatusAsString())
                && Objects.equals(behaviorOnMxFailureAsString(), other.behaviorOnMxFailureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MailFromAttributes").add("MailFromDomain", mailFromDomain())
                .add("MailFromDomainStatus", mailFromDomainStatusAsString())
                .add("BehaviorOnMxFailure", behaviorOnMxFailureAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MailFromDomain":
            return Optional.ofNullable(clazz.cast(mailFromDomain()));
        case "MailFromDomainStatus":
            return Optional.ofNullable(clazz.cast(mailFromDomainStatusAsString()));
        case "BehaviorOnMxFailure":
            return Optional.ofNullable(clazz.cast(behaviorOnMxFailureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MailFromAttributes, T> g) {
        return obj -> g.apply((MailFromAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MailFromAttributes> {
        /**
         * <p>
         * The name of a domain that an email identity uses as a custom MAIL FROM domain.
         * </p>
         * 
         * @param mailFromDomain
         *        The name of a domain that an email identity uses as a custom MAIL FROM domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromDomain(String mailFromDomain);

        /**
         * <p>
         * The status of the MAIL FROM domain. This status can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – Amazon SES hasn't started searching for the MX record yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – Amazon SES can't find the required MX record, or the record no longer exists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from determining the
         * status of the MAIL FROM domain.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mailFromDomainStatus
         *        The status of the MAIL FROM domain. This status can have the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – Amazon SES hasn't started searching for the MX record yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – Amazon SES can't find the required MX record, or the record no longer exists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from
         *        determining the status of the MAIL FROM domain.
         *        </p>
         *        </li>
         * @see MailFromDomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailFromDomainStatus
         */
        Builder mailFromDomainStatus(String mailFromDomainStatus);

        /**
         * <p>
         * The status of the MAIL FROM domain. This status can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – Amazon SES hasn't started searching for the MX record yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – Amazon SES can't find the required MX record, or the record no longer exists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from determining the
         * status of the MAIL FROM domain.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mailFromDomainStatus
         *        The status of the MAIL FROM domain. This status can have the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – Amazon SES hasn't started searching for the MX record yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – Amazon SES can't find the required MX record, or the record no longer exists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from
         *        determining the status of the MAIL FROM domain.
         *        </p>
         *        </li>
         * @see MailFromDomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailFromDomainStatus
         */
        Builder mailFromDomainStatus(MailFromDomainStatus mailFromDomainStatus);

        /**
         * <p>
         * The action that you want to take if the required MX record can't be found when you send an email. When you
         * set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM
         * domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
         * <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
         * </p>
         * <p>
         * These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
         * <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * </p>
         * 
         * @param behaviorOnMxFailure
         *        The action that you want to take if the required MX record can't be found when you send an email. When
         *        you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the
         *        MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns
         *        a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
         *        <p>
         *        These behaviors are taken when the custom MAIL FROM domain configuration is in the
         *        <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * @see BehaviorOnMxFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMxFailure
         */
        Builder behaviorOnMxFailure(String behaviorOnMxFailure);

        /**
         * <p>
         * The action that you want to take if the required MX record can't be found when you send an email. When you
         * set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM
         * domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
         * <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
         * </p>
         * <p>
         * These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
         * <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * </p>
         * 
         * @param behaviorOnMxFailure
         *        The action that you want to take if the required MX record can't be found when you send an email. When
         *        you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the
         *        MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns
         *        a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
         *        <p>
         *        These behaviors are taken when the custom MAIL FROM domain configuration is in the
         *        <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * @see BehaviorOnMxFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMxFailure
         */
        Builder behaviorOnMxFailure(BehaviorOnMxFailure behaviorOnMxFailure);
    }

    static final class BuilderImpl implements Builder {
        private String mailFromDomain;

        private String mailFromDomainStatus;

        private String behaviorOnMxFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(MailFromAttributes model) {
            mailFromDomain(model.mailFromDomain);
            mailFromDomainStatus(model.mailFromDomainStatus);
            behaviorOnMxFailure(model.behaviorOnMxFailure);
        }

        public final String getMailFromDomain() {
            return mailFromDomain;
        }

        @Override
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        public final String getMailFromDomainStatusAsString() {
            return mailFromDomainStatus;
        }

        @Override
        public final Builder mailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
            return this;
        }

        @Override
        public final Builder mailFromDomainStatus(MailFromDomainStatus mailFromDomainStatus) {
            this.mailFromDomainStatus(mailFromDomainStatus == null ? null : mailFromDomainStatus.toString());
            return this;
        }

        public final void setMailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
        }

        public final String getBehaviorOnMxFailureAsString() {
            return behaviorOnMxFailure;
        }

        @Override
        public final Builder behaviorOnMxFailure(String behaviorOnMxFailure) {
            this.behaviorOnMxFailure = behaviorOnMxFailure;
            return this;
        }

        @Override
        public final Builder behaviorOnMxFailure(BehaviorOnMxFailure behaviorOnMxFailure) {
            this.behaviorOnMxFailure(behaviorOnMxFailure == null ? null : behaviorOnMxFailure.toString());
            return this;
        }

        public final void setBehaviorOnMxFailure(String behaviorOnMxFailure) {
            this.behaviorOnMxFailure = behaviorOnMxFailure;
        }

        @Override
        public MailFromAttributes build() {
            return new MailFromAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
