/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a dedicated IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDedicatedIpResponse extends SesV2Response implements
        ToCopyableBuilder<GetDedicatedIpResponse.Builder, GetDedicatedIpResponse> {
    private static final SdkField<DedicatedIp> DEDICATED_IP_FIELD = SdkField.<DedicatedIp> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetDedicatedIpResponse::dedicatedIp)).setter(setter(Builder::dedicatedIp))
            .constructor(DedicatedIp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEDICATED_IP_FIELD));

    private final DedicatedIp dedicatedIp;

    private GetDedicatedIpResponse(BuilderImpl builder) {
        super(builder);
        this.dedicatedIp = builder.dedicatedIp;
    }

    /**
     * <p>
     * An object that contains information about a dedicated IP address.
     * </p>
     * 
     * @return An object that contains information about a dedicated IP address.
     */
    public DedicatedIp dedicatedIp() {
        return dedicatedIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedIp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDedicatedIpResponse)) {
            return false;
        }
        GetDedicatedIpResponse other = (GetDedicatedIpResponse) obj;
        return Objects.equals(dedicatedIp(), other.dedicatedIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDedicatedIpResponse").add("DedicatedIp", dedicatedIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DedicatedIp":
            return Optional.ofNullable(clazz.cast(dedicatedIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDedicatedIpResponse, T> g) {
        return obj -> g.apply((GetDedicatedIpResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetDedicatedIpResponse> {
        /**
         * <p>
         * An object that contains information about a dedicated IP address.
         * </p>
         * 
         * @param dedicatedIp
         *        An object that contains information about a dedicated IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedIp(DedicatedIp dedicatedIp);

        /**
         * <p>
         * An object that contains information about a dedicated IP address.
         * </p>
         * This is a convenience that creates an instance of the {@link DedicatedIp.Builder} avoiding the need to create
         * one manually via {@link DedicatedIp#builder()}.
         *
         * When the {@link Consumer} completes, {@link DedicatedIp.Builder#build()} is called immediately and its result
         * is passed to {@link #dedicatedIp(DedicatedIp)}.
         * 
         * @param dedicatedIp
         *        a consumer that will call methods on {@link DedicatedIp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dedicatedIp(DedicatedIp)
         */
        default Builder dedicatedIp(Consumer<DedicatedIp.Builder> dedicatedIp) {
            return dedicatedIp(DedicatedIp.builder().applyMutation(dedicatedIp).build());
        }
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private DedicatedIp dedicatedIp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDedicatedIpResponse model) {
            super(model);
            dedicatedIp(model.dedicatedIp);
        }

        public final DedicatedIp.Builder getDedicatedIp() {
            return dedicatedIp != null ? dedicatedIp.toBuilder() : null;
        }

        @Override
        public final Builder dedicatedIp(DedicatedIp dedicatedIp) {
            this.dedicatedIp = dedicatedIp;
            return this;
        }

        public final void setDedicatedIp(DedicatedIp.BuilderImpl dedicatedIp) {
            this.dedicatedIp = dedicatedIp != null ? dedicatedIp.build() : null;
        }

        @Override
        public GetDedicatedIpResponse build() {
            return new GetDedicatedIpResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
