/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to obtain more information about a dedicated IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDedicatedIpRequest extends SesV2Request implements
        ToCopyableBuilder<GetDedicatedIpRequest.Builder, GetDedicatedIpRequest> {
    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDedicatedIpRequest::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IP").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD));

    private final String ip;

    private GetDedicatedIpRequest(BuilderImpl builder) {
        super(builder);
        this.ip = builder.ip;
    }

    /**
     * <p>
     * The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP
     * address that's assocaited with your AWS account.
     * </p>
     * 
     * @return The IP address that you want to obtain more information about. The value you specify has to be a
     *         dedicated IP address that's assocaited with your AWS account.
     */
    public String ip() {
        return ip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDedicatedIpRequest)) {
            return false;
        }
        GetDedicatedIpRequest other = (GetDedicatedIpRequest) obj;
        return Objects.equals(ip(), other.ip());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDedicatedIpRequest").add("Ip", ip()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDedicatedIpRequest, T> g) {
        return obj -> g.apply((GetDedicatedIpRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetDedicatedIpRequest> {
        /**
         * <p>
         * The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP
         * address that's assocaited with your AWS account.
         * </p>
         * 
         * @param ip
         *        The IP address that you want to obtain more information about. The value you specify has to be a
         *        dedicated IP address that's assocaited with your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String ip;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDedicatedIpRequest model) {
            super(model);
            ip(model.ip);
        }

        public final String getIp() {
            return ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDedicatedIpRequest build() {
            return new GetDedicatedIpRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
