/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes the recipients for an email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Destination implements SdkPojo, Serializable, ToCopyableBuilder<Destination.Builder, Destination> {
    private static final SdkField<List<String>> TO_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Destination::toAddresses))
            .setter(setter(Builder::toAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CC_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Destination::ccAddresses))
            .setter(setter(Builder::ccAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CcAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BCC_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Destination::bccAddresses))
            .setter(setter(Builder::bccAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BccAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_ADDRESSES_FIELD,
            CC_ADDRESSES_FIELD, BCC_ADDRESSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> toAddresses;

    private final List<String> ccAddresses;

    private final List<String> bccAddresses;

    private Destination(BuilderImpl builder) {
        this.toAddresses = builder.toAddresses;
        this.ccAddresses = builder.ccAddresses;
        this.bccAddresses = builder.bccAddresses;
    }

    /**
     * Returns true if the ToAddresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasToAddresses() {
        return toAddresses != null && !(toAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the email addresses of the "To" recipients for the email.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasToAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that contains the email addresses of the "To" recipients for the email.
     */
    public List<String> toAddresses() {
        return toAddresses;
    }

    /**
     * Returns true if the CcAddresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCcAddresses() {
        return ccAddresses != null && !(ccAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the email addresses of the "CC" (carbon copy) recipients for the email.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCcAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that contains the email addresses of the "CC" (carbon copy) recipients for the email.
     */
    public List<String> ccAddresses() {
        return ccAddresses;
    }

    /**
     * Returns true if the BccAddresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBccAddresses() {
        return bccAddresses != null && !(bccAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the email addresses of the "BCC" (blind carbon copy) recipients for the email.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBccAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that contains the email addresses of the "BCC" (blind carbon copy) recipients for the email.
     */
    public List<String> bccAddresses() {
        return bccAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(ccAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(bccAddresses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        return Objects.equals(toAddresses(), other.toAddresses()) && Objects.equals(ccAddresses(), other.ccAddresses())
                && Objects.equals(bccAddresses(), other.bccAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Destination").add("ToAddresses", toAddresses()).add("CcAddresses", ccAddresses())
                .add("BccAddresses", bccAddresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ToAddresses":
            return Optional.ofNullable(clazz.cast(toAddresses()));
        case "CcAddresses":
            return Optional.ofNullable(clazz.cast(ccAddresses()));
        case "BccAddresses":
            return Optional.ofNullable(clazz.cast(bccAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Destination> {
        /**
         * <p>
         * An array that contains the email addresses of the "To" recipients for the email.
         * </p>
         * 
         * @param toAddresses
         *        An array that contains the email addresses of the "To" recipients for the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toAddresses(Collection<String> toAddresses);

        /**
         * <p>
         * An array that contains the email addresses of the "To" recipients for the email.
         * </p>
         * 
         * @param toAddresses
         *        An array that contains the email addresses of the "To" recipients for the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toAddresses(String... toAddresses);

        /**
         * <p>
         * An array that contains the email addresses of the "CC" (carbon copy) recipients for the email.
         * </p>
         * 
         * @param ccAddresses
         *        An array that contains the email addresses of the "CC" (carbon copy) recipients for the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccAddresses(Collection<String> ccAddresses);

        /**
         * <p>
         * An array that contains the email addresses of the "CC" (carbon copy) recipients for the email.
         * </p>
         * 
         * @param ccAddresses
         *        An array that contains the email addresses of the "CC" (carbon copy) recipients for the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccAddresses(String... ccAddresses);

        /**
         * <p>
         * An array that contains the email addresses of the "BCC" (blind carbon copy) recipients for the email.
         * </p>
         * 
         * @param bccAddresses
         *        An array that contains the email addresses of the "BCC" (blind carbon copy) recipients for the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bccAddresses(Collection<String> bccAddresses);

        /**
         * <p>
         * An array that contains the email addresses of the "BCC" (blind carbon copy) recipients for the email.
         * </p>
         * 
         * @param bccAddresses
         *        An array that contains the email addresses of the "BCC" (blind carbon copy) recipients for the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bccAddresses(String... bccAddresses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> toAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> ccAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> bccAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            toAddresses(model.toAddresses);
            ccAddresses(model.ccAddresses);
            bccAddresses(model.bccAddresses);
        }

        public final Collection<String> getToAddresses() {
            return toAddresses;
        }

        @Override
        public final Builder toAddresses(Collection<String> toAddresses) {
            this.toAddresses = EmailAddressListCopier.copy(toAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toAddresses(String... toAddresses) {
            toAddresses(Arrays.asList(toAddresses));
            return this;
        }

        public final void setToAddresses(Collection<String> toAddresses) {
            this.toAddresses = EmailAddressListCopier.copy(toAddresses);
        }

        public final Collection<String> getCcAddresses() {
            return ccAddresses;
        }

        @Override
        public final Builder ccAddresses(Collection<String> ccAddresses) {
            this.ccAddresses = EmailAddressListCopier.copy(ccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccAddresses(String... ccAddresses) {
            ccAddresses(Arrays.asList(ccAddresses));
            return this;
        }

        public final void setCcAddresses(Collection<String> ccAddresses) {
            this.ccAddresses = EmailAddressListCopier.copy(ccAddresses);
        }

        public final Collection<String> getBccAddresses() {
            return bccAddresses;
        }

        @Override
        public final Builder bccAddresses(Collection<String> bccAddresses) {
            this.bccAddresses = EmailAddressListCopier.copy(bccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bccAddresses(String... bccAddresses) {
            bccAddresses(Arrays.asList(bccAddresses));
            return this;
        }

        public final void setBccAddresses(Collection<String> bccAddresses) {
            this.bccAddresses = EmailAddressListCopier.copy(bccAddresses);
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
