/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a receipt rule. You use receipt rules to receive email with Amazon SES. For more
 * information, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html">Amazon SES
 * Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReceiptRuleRequest extends SesRequest implements
        ToCopyableBuilder<CreateReceiptRuleRequest.Builder, CreateReceiptRuleRequest> {
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetName").getter(getter(CreateReceiptRuleRequest::ruleSetName)).setter(setter(Builder::ruleSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()).build();

    private static final SdkField<String> AFTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("After")
            .getter(getter(CreateReceiptRuleRequest::after)).setter(setter(Builder::after))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("After").build()).build();

    private static final SdkField<ReceiptRule> RULE_FIELD = SdkField.<ReceiptRule> builder(MarshallingType.SDK_POJO)
            .memberName("Rule").getter(getter(CreateReceiptRuleRequest::rule)).setter(setter(Builder::rule))
            .constructor(ReceiptRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_NAME_FIELD,
            AFTER_FIELD, RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleSetName;

    private final String after;

    private final ReceiptRule rule;

    private CreateReceiptRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.after = builder.after;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * The name of the rule set where the receipt rule is added.
     * </p>
     * 
     * @return The name of the rule set where the receipt rule is added.
     */
    public final String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * The name of an existing rule after which the new rule is placed. If this parameter is null, the new rule is
     * inserted at the beginning of the rule list.
     * </p>
     * 
     * @return The name of an existing rule after which the new rule is placed. If this parameter is null, the new rule
     *         is inserted at the beginning of the rule list.
     */
    public final String after() {
        return after;
    }

    /**
     * <p>
     * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan
     * status, and TLS policy.
     * </p>
     * 
     * @return A data structure that contains the specified rule's name, actions, recipients, domains, enabled status,
     *         scan status, and TLS policy.
     */
    public final ReceiptRule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(after());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReceiptRuleRequest)) {
            return false;
        }
        CreateReceiptRuleRequest other = (CreateReceiptRuleRequest) obj;
        return Objects.equals(ruleSetName(), other.ruleSetName()) && Objects.equals(after(), other.after())
                && Objects.equals(rule(), other.rule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReceiptRuleRequest").add("RuleSetName", ruleSetName()).add("After", after())
                .add("Rule", rule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetName":
            return Optional.ofNullable(clazz.cast(ruleSetName()));
        case "After":
            return Optional.ofNullable(clazz.cast(after()));
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleSetName", RULE_SET_NAME_FIELD);
        map.put("After", AFTER_FIELD);
        map.put("Rule", RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReceiptRuleRequest, T> g) {
        return obj -> g.apply((CreateReceiptRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReceiptRuleRequest> {
        /**
         * <p>
         * The name of the rule set where the receipt rule is added.
         * </p>
         * 
         * @param ruleSetName
         *        The name of the rule set where the receipt rule is added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * The name of an existing rule after which the new rule is placed. If this parameter is null, the new rule is
         * inserted at the beginning of the rule list.
         * </p>
         * 
         * @param after
         *        The name of an existing rule after which the new rule is placed. If this parameter is null, the new
         *        rule is inserted at the beginning of the rule list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder after(String after);

        /**
         * <p>
         * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan
         * status, and TLS policy.
         * </p>
         * 
         * @param rule
         *        A data structure that contains the specified rule's name, actions, recipients, domains, enabled
         *        status, scan status, and TLS policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(ReceiptRule rule);

        /**
         * <p>
         * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan
         * status, and TLS policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReceiptRule.Builder} avoiding the need to
         * create one manually via {@link ReceiptRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReceiptRule.Builder#build()} is called immediately and its result
         * is passed to {@link #rule(ReceiptRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link ReceiptRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(ReceiptRule)
         */
        default Builder rule(Consumer<ReceiptRule.Builder> rule) {
            return rule(ReceiptRule.builder().applyMutation(rule).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String ruleSetName;

        private String after;

        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReceiptRuleRequest model) {
            super(model);
            ruleSetName(model.ruleSetName);
            after(model.after);
            rule(model.rule);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final String getAfter() {
            return after;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        public final ReceiptRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(ReceiptRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReceiptRuleRequest build() {
            return new CreateReceiptRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
