/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAttributeListCopier;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationSetRequest
extends SesRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationSetRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(DescribeConfigurationSetRequest.getter(DescribeConfigurationSetRequest::configurationSetName)).setter(DescribeConfigurationSetRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<List<String>> CONFIGURATION_SET_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationSetAttributeNames").getter(DescribeConfigurationSetRequest.getter(DescribeConfigurationSetRequest::configurationSetAttributeNamesAsStrings)).setter(DescribeConfigurationSetRequest.setter(Builder::configurationSetAttributeNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetAttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD, CONFIGURATION_SET_ATTRIBUTE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConfigurationSetRequest.memberNameToFieldInitializer();
    private final String configurationSetName;
    private final List<String> configurationSetAttributeNames;

    private DescribeConfigurationSetRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.configurationSetAttributeNames = builder.configurationSetAttributeNames;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final List<ConfigurationSetAttribute> configurationSetAttributeNames() {
        return ConfigurationSetAttributeListCopier.copyStringToEnum(this.configurationSetAttributeNames);
    }

    public final boolean hasConfigurationSetAttributeNames() {
        return this.configurationSetAttributeNames != null && !(this.configurationSetAttributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> configurationSetAttributeNamesAsStrings() {
        return this.configurationSetAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationSetAttributeNames() ? this.configurationSetAttributeNamesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetRequest)) {
            return false;
        }
        DescribeConfigurationSetRequest other = (DescribeConfigurationSetRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && this.hasConfigurationSetAttributeNames() == other.hasConfigurationSetAttributeNames() && Objects.equals(this.configurationSetAttributeNamesAsStrings(), other.configurationSetAttributeNamesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationSetRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("ConfigurationSetAttributeNames", this.hasConfigurationSetAttributeNames() ? this.configurationSetAttributeNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "ConfigurationSetAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.configurationSetAttributeNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("ConfigurationSetAttributeNames", CONFIGURATION_SET_ATTRIBUTE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationSetRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private List<String> configurationSetAttributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.configurationSetAttributeNamesWithStrings(model.configurationSetAttributeNames);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final Collection<String> getConfigurationSetAttributeNames() {
            if (this.configurationSetAttributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configurationSetAttributeNames;
        }

        public final void setConfigurationSetAttributeNames(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
        }

        @Override
        public final Builder configurationSetAttributeNamesWithStrings(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSetAttributeNamesWithStrings(String ... configurationSetAttributeNames) {
            this.configurationSetAttributeNamesWithStrings(Arrays.asList(configurationSetAttributeNames));
            return this;
        }

        @Override
        public final Builder configurationSetAttributeNames(Collection<ConfigurationSetAttribute> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copyEnumToString(configurationSetAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSetAttributeNames(ConfigurationSetAttribute ... configurationSetAttributeNames) {
            this.configurationSetAttributeNames(Arrays.asList(configurationSetAttributeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationSetRequest build() {
            return new DescribeConfigurationSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationSetRequest> {
        public Builder configurationSetName(String var1);

        public Builder configurationSetAttributeNamesWithStrings(Collection<String> var1);

        public Builder configurationSetAttributeNamesWithStrings(String ... var1);

        public Builder configurationSetAttributeNames(Collection<ConfigurationSetAttribute> var1);

        public Builder configurationSetAttributeNames(ConfigurationSetAttribute ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

