/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DimensionValueSource {
    MESSAGE_TAG("messageTag"),
    EMAIL_HEADER("emailHeader"),
    LINK_TAG("linkTag"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DimensionValueSource> VALUE_MAP;
    private final String value;

    private DimensionValueSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DimensionValueSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DimensionValueSource> knownValues() {
        EnumSet<DimensionValueSource> knownValues = EnumSet.allOf(DimensionValueSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DimensionValueSource.class, DimensionValueSource::toString);
    }
}

