/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DsnAction {
    FAILED("failed"),
    DELAYED("delayed"),
    DELIVERED("delivered"),
    RELAYED("relayed"),
    EXPANDED("expanded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DsnAction> VALUE_MAP;
    private final String value;

    private DsnAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DsnAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DsnAction> knownValues() {
        EnumSet<DsnAction> knownValues = EnumSet.allOf(DsnAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DsnAction.class, DsnAction::toString);
    }
}

