/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.PolicyNameListCopier;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityPoliciesRequest
extends SesRequest
implements ToCopyableBuilder<Builder, GetIdentityPoliciesRequest> {
    private static final SdkField<String> IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identity").getter(GetIdentityPoliciesRequest.getter(GetIdentityPoliciesRequest::identity)).setter(GetIdentityPoliciesRequest.setter(Builder::identity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build()}).build();
    private static final SdkField<List<String>> POLICY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyNames").getter(GetIdentityPoliciesRequest.getter(GetIdentityPoliciesRequest::policyNames)).setter(GetIdentityPoliciesRequest.setter(Builder::policyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_FIELD, POLICY_NAMES_FIELD));
    private final String identity;
    private final List<String> policyNames;

    private GetIdentityPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.policyNames = builder.policyNames;
    }

    public final String identity() {
        return this.identity;
    }

    public final boolean hasPolicyNames() {
        return this.policyNames != null && !(this.policyNames instanceof SdkAutoConstructList);
    }

    public final List<String> policyNames() {
        return this.policyNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyNames() ? this.policyNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoliciesRequest)) {
            return false;
        }
        GetIdentityPoliciesRequest other = (GetIdentityPoliciesRequest)((Object)obj);
        return Objects.equals(this.identity(), other.identity()) && this.hasPolicyNames() == other.hasPolicyNames() && Objects.equals(this.policyNames(), other.policyNames());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdentityPoliciesRequest").add("Identity", (Object)this.identity()).add("PolicyNames", this.hasPolicyNames() ? this.policyNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
            case "PolicyNames": {
                return Optional.ofNullable(clazz.cast(this.policyNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityPoliciesRequest, T> g) {
        return obj -> g.apply((GetIdentityPoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String identity;
        private List<String> policyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoliciesRequest model) {
            super(model);
            this.identity(model.identity);
            this.policyNames(model.policyNames);
        }

        public final String getIdentity() {
            return this.identity;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        @Transient
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final Collection<String> getPolicyNames() {
            if (this.policyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policyNames;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNameListCopier.copy(policyNames);
        }

        @Override
        @Transient
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNameListCopier.copy(policyNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdentityPoliciesRequest build() {
            return new GetIdentityPoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentityPoliciesRequest> {
        public Builder identity(String var1);

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

