/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.StopScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StopAction> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(StopAction.getter(StopAction::scopeAsString)).setter(StopAction.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(StopAction.getter(StopAction::topicArn)).setter(StopAction.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, TOPIC_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String topicArn;

    private StopAction(BuilderImpl builder) {
        this.scope = builder.scope;
        this.topicArn = builder.topicArn;
    }

    public final StopScope scope() {
        return StopScope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopAction)) {
            return false;
        }
        StopAction other = (StopAction)obj;
        return Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.topicArn(), other.topicArn());
    }

    public final String toString() {
        return ToString.builder((String)"StopAction").add("Scope", (Object)this.scopeAsString()).add("TopicArn", (Object)this.topicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopAction, T> g) {
        return obj -> g.apply((StopAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scope;
        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StopAction model) {
            this.scope(model.scope);
            this.topicArn(model.topicArn);
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        @Transient
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        @Transient
        public final Builder scope(StopScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        @Transient
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public StopAction build() {
            return new StopAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StopAction> {
        public Builder scope(String var1);

        public Builder scope(StopScope var1);

        public Builder topicArn(String var1);
    }
}

