/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptFilterResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.CreateTemplateRequest;
import software.amazon.awssdk.services.ses.model.CreateTemplateResponse;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyResponse;
import software.amazon.awssdk.services.ses.model.DeleteIdentityRequest;
import software.amazon.awssdk.services.ses.model.DeleteIdentityResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptFilterRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptFilterResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.ses.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest;
import software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressResponse;
import software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityPoliciesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetSendQuotaRequest;
import software.amazon.awssdk.services.ses.model.GetSendQuotaResponse;
import software.amazon.awssdk.services.ses.model.GetSendStatisticsRequest;
import software.amazon.awssdk.services.ses.model.GetSendStatisticsResponse;
import software.amazon.awssdk.services.ses.model.GetTemplateRequest;
import software.amazon.awssdk.services.ses.model.GetTemplateResponse;
import software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.ses.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse;
import software.amazon.awssdk.services.ses.model.ListIdentitiesRequest;
import software.amazon.awssdk.services.ses.model.ListIdentitiesResponse;
import software.amazon.awssdk.services.ses.model.ListIdentityPoliciesRequest;
import software.amazon.awssdk.services.ses.model.ListIdentityPoliciesResponse;
import software.amazon.awssdk.services.ses.model.ListReceiptFiltersRequest;
import software.amazon.awssdk.services.ses.model.ListReceiptFiltersResponse;
import software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest;
import software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsResponse;
import software.amazon.awssdk.services.ses.model.ListTemplatesRequest;
import software.amazon.awssdk.services.ses.model.ListTemplatesResponse;
import software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesRequest;
import software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesResponse;
import software.amazon.awssdk.services.ses.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.ses.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest;
import software.amazon.awssdk.services.ses.model.PutIdentityPolicyResponse;
import software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.SendBounceRequest;
import software.amazon.awssdk.services.ses.model.SendBounceResponse;
import software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest;
import software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailResponse;
import software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest;
import software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailResponse;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;
import software.amazon.awssdk.services.ses.model.SendEmailResponse;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;
import software.amazon.awssdk.services.ses.model.SendRawEmailResponse;
import software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest;
import software.amazon.awssdk.services.ses.model.SendTemplatedEmailResponse;
import software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicResponse;
import software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest;
import software.amazon.awssdk.services.ses.model.SetReceiptRulePositionResponse;
import software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest;
import software.amazon.awssdk.services.ses.model.TestRenderTemplateResponse;
import software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.UpdateReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.ses.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.ses.model.VerifyDomainDkimRequest;
import software.amazon.awssdk.services.ses.model.VerifyDomainDkimResponse;
import software.amazon.awssdk.services.ses.model.VerifyDomainIdentityRequest;
import software.amazon.awssdk.services.ses.model.VerifyDomainIdentityResponse;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressResponse;
import software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest;
import software.amazon.awssdk.services.ses.model.VerifyEmailIdentityResponse;
import software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesPublisher;
import software.amazon.awssdk.services.ses.paginators.ListIdentitiesPublisher;
import software.amazon.awssdk.services.ses.waiters.SesAsyncWaiter;

/**
 * Service client for accessing Amazon SES asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon Simple Email Service</fullname>
 * <p>
 * This document contains reference information for the <a href="https://aws.amazon.com/ses/">Amazon Simple Email
 * Service</a> (Amazon SES) API, version 2010-12-01. This document is best used in conjunction with the <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/Welcome.html">Amazon SES Developer Guide</a>.
 * </p>
 * <note>
 * <p>
 * For a list of Amazon SES endpoints to use in service requests, see <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/regions.html">Regions and Amazon SES</a> in the <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/Welcome.html">Amazon SES Developer Guide</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SesAsyncClient extends SdkClient {
    String SERVICE_NAME = "ses";

    /**
     * Create a {@link SesAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SesAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SesAsyncClient}.
     */
    static SesAsyncClientBuilder builder() {
        return new DefaultSesAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a receipt rule set by cloning an existing one. All receipt rules and configurations are copied to the new
     * receipt rule set and are completely independent of the source rule set.
     * </p>
     * <p>
     * For information about setting up rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param cloneReceiptRuleSetRequest
     *        Represents a request to create a receipt rule set by cloning an existing one. You use receipt rule sets to
     *        receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CloneReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>AlreadyExistsException Indicates that a resource could not be created because of a naming conflict.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CloneReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloneReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CloneReceiptRuleSetResponse> cloneReceiptRuleSet(
            CloneReceiptRuleSetRequest cloneReceiptRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a receipt rule set by cloning an existing one. All receipt rules and configurations are copied to the new
     * receipt rule set and are completely independent of the source rule set.
     * </p>
     * <p>
     * For information about setting up rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloneReceiptRuleSetRequest.Builder} avoiding the
     * need to create one manually via {@link CloneReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param cloneReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link CloneReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to create a receipt rule set by cloning an existing one. You use receipt
     *        rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CloneReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>AlreadyExistsException Indicates that a resource could not be created because of a naming conflict.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CloneReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloneReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CloneReceiptRuleSetResponse> cloneReceiptRuleSet(
            Consumer<CloneReceiptRuleSetRequest.Builder> cloneReceiptRuleSetRequest) {
        return cloneReceiptRuleSet(CloneReceiptRuleSetRequest.builder().applyMutation(cloneReceiptRuleSetRequest).build());
    }

    /**
     * <p>
     * Creates a configuration set.
     * </p>
     * <p>
     * Configuration sets enable you to publish email sending events. For information about using configuration sets,
     * see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createConfigurationSetRequest
     *        Represents a request to create a configuration set. Configuration sets enable you to publish email sending
     *        events. For information about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetAlreadyExistsException Indicates that the configuration set could not be created
     *         because of a naming conflict.</li>
     *         <li>InvalidConfigurationSetException Indicates that the configuration set is invalid. See the error
     *         message for details.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(
            CreateConfigurationSetRequest createConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration set.
     * </p>
     * <p>
     * Configuration sets enable you to publish email sending events. For information about using configuration sets,
     * see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationSetRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationSetRequest.Builder} to create a
     *        request. Represents a request to create a configuration set. Configuration sets enable you to publish
     *        email sending events. For information about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetAlreadyExistsException Indicates that the configuration set could not be created
     *         because of a naming conflict.</li>
     *         <li>InvalidConfigurationSetException Indicates that the configuration set is invalid. See the error
     *         message for details.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(
            Consumer<CreateConfigurationSetRequest.Builder> createConfigurationSetRequest) {
        return createConfigurationSet(CreateConfigurationSetRequest.builder().applyMutation(createConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Creates a configuration set event destination.
     * </p>
     * <note>
     * <p>
     * When you create or update an event destination, you must provide one, and only one, destination. The destination
     * can be CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * </note>
     * <p>
     * An event destination is the AWS service to which Amazon SES publishes the email sending events associated with a
     * configuration set. For information about using configuration sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        Represents a request to create a configuration set event destination. A configuration set event
     *        destination, which can be either Amazon CloudWatch or Amazon Kinesis Firehose, describes an AWS service in
     *        which Amazon SES publishes the email sending events associated with a configuration set. For information
     *        about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>EventDestinationAlreadyExistsException Indicates that the event destination could not be created
     *         because of a naming conflict.</li>
     *         <li>InvalidCloudWatchDestinationException Indicates that the Amazon CloudWatch destination is invalid.
     *         See the error message for details.</li>
     *         <li>InvalidFirehoseDestinationException Indicates that the Amazon Kinesis Firehose destination is
     *         invalid. See the error message for details.</li>
     *         <li>InvalidSnsDestinationException Indicates that the Amazon Simple Notification Service (Amazon SNS)
     *         destination is invalid. See the error message for details.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetEventDestinationResponse> createConfigurationSetEventDestination(
            CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration set event destination.
     * </p>
     * <note>
     * <p>
     * When you create or update an event destination, you must provide one, and only one, destination. The destination
     * can be CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * </note>
     * <p>
     * An event destination is the AWS service to which Amazon SES publishes the email sending events associated with a
     * configuration set. For information about using configuration sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. Represents a request to create a configuration set event destination. A configuration
     *        set event destination, which can be either Amazon CloudWatch or Amazon Kinesis Firehose, describes an AWS
     *        service in which Amazon SES publishes the email sending events associated with a configuration set. For
     *        information about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>EventDestinationAlreadyExistsException Indicates that the event destination could not be created
     *         because of a naming conflict.</li>
     *         <li>InvalidCloudWatchDestinationException Indicates that the Amazon CloudWatch destination is invalid.
     *         See the error message for details.</li>
     *         <li>InvalidFirehoseDestinationException Indicates that the Amazon Kinesis Firehose destination is
     *         invalid. See the error message for details.</li>
     *         <li>InvalidSnsDestinationException Indicates that the Amazon Simple Notification Service (Amazon SNS)
     *         destination is invalid. See the error message for details.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetEventDestinationResponse> createConfigurationSetEventDestination(
            Consumer<CreateConfigurationSetEventDestinationRequest.Builder> createConfigurationSetEventDestinationRequest) {
        return createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(createConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Creates an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     *
     * @param createConfigurationSetTrackingOptionsRequest
     *        Represents a request to create an open and click tracking option object in a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSetTrackingOptions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>TrackingOptionsAlreadyExistsException Indicates that the configuration set you specified already
     *         contains a TrackingOptions object.</li>
     *         <li>InvalidTrackingOptionsException Indicates that the custom domain to be used for open and click
     *         tracking redirects is invalid. This error appears most often in the following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not verified in Amazon SES.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not a valid domain or subdomain.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetTrackingOptionsResponse> createConfigurationSetTrackingOptions(
            CreateConfigurationSetTrackingOptionsRequest createConfigurationSetTrackingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateConfigurationSetTrackingOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link CreateConfigurationSetTrackingOptionsRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetTrackingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationSetTrackingOptionsRequest.Builder}
     *        to create a request. Represents a request to create an open and click tracking option object in a
     *        configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSetTrackingOptions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>TrackingOptionsAlreadyExistsException Indicates that the configuration set you specified already
     *         contains a TrackingOptions object.</li>
     *         <li>InvalidTrackingOptionsException Indicates that the custom domain to be used for open and click
     *         tracking redirects is invalid. This error appears most often in the following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not verified in Amazon SES.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not a valid domain or subdomain.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetTrackingOptionsResponse> createConfigurationSetTrackingOptions(
            Consumer<CreateConfigurationSetTrackingOptionsRequest.Builder> createConfigurationSetTrackingOptionsRequest) {
        return createConfigurationSetTrackingOptions(CreateConfigurationSetTrackingOptionsRequest.builder()
                .applyMutation(createConfigurationSetTrackingOptionsRequest).build());
    }

    /**
     * <p>
     * Creates a new custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createCustomVerificationEmailTemplateRequest
     *        Represents a request to create a custom verification email template.
     * @return A Java Future containing the result of the CreateCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomVerificationEmailTemplateAlreadyExistsException Indicates that a custom verification email
     *         template with the name you specified already exists.</li>
     *         <li>FromEmailAddressNotVerifiedException Indicates that the sender address specified for a custom
     *         verification email is not verified, and is therefore not eligible to send the custom verification email.</li>
     *         <li>CustomVerificationEmailInvalidContentException Indicates that custom verification email template
     *         provided content is invalid.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomVerificationEmailTemplateResponse> createCustomVerificationEmailTemplate(
            CreateCustomVerificationEmailTemplateRequest createCustomVerificationEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link CreateCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param createCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to create a custom verification email template.
     * @return A Java Future containing the result of the CreateCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomVerificationEmailTemplateAlreadyExistsException Indicates that a custom verification email
     *         template with the name you specified already exists.</li>
     *         <li>FromEmailAddressNotVerifiedException Indicates that the sender address specified for a custom
     *         verification email is not verified, and is therefore not eligible to send the custom verification email.</li>
     *         <li>CustomVerificationEmailInvalidContentException Indicates that custom verification email template
     *         provided content is invalid.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomVerificationEmailTemplateResponse> createCustomVerificationEmailTemplate(
            Consumer<CreateCustomVerificationEmailTemplateRequest.Builder> createCustomVerificationEmailTemplateRequest) {
        return createCustomVerificationEmailTemplate(CreateCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(createCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new IP address filter.
     * </p>
     * <p>
     * For information about setting up IP address filters, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createReceiptFilterRequest
     *        Represents a request to create a new IP address filter. You use IP address filters when you receive email
     *        with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateReceiptFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>AlreadyExistsException Indicates that a resource could not be created because of a naming conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateReceiptFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReceiptFilterResponse> createReceiptFilter(
            CreateReceiptFilterRequest createReceiptFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new IP address filter.
     * </p>
     * <p>
     * For information about setting up IP address filters, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReceiptFilterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReceiptFilterRequest#builder()}
     * </p>
     *
     * @param createReceiptFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateReceiptFilterRequest.Builder} to create a
     *        request. Represents a request to create a new IP address filter. You use IP address filters when you
     *        receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateReceiptFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>AlreadyExistsException Indicates that a resource could not be created because of a naming conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateReceiptFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReceiptFilterResponse> createReceiptFilter(
            Consumer<CreateReceiptFilterRequest.Builder> createReceiptFilterRequest) {
        return createReceiptFilter(CreateReceiptFilterRequest.builder().applyMutation(createReceiptFilterRequest).build());
    }

    /**
     * <p>
     * Creates a receipt rule.
     * </p>
     * <p>
     * For information about setting up receipt rules, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createReceiptRuleRequest
     *        Represents a request to create a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateReceiptRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSnsTopicException Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES
     *         could not publish to the topic, possibly due to permissions issues. For information about giving
     *         permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>InvalidS3ConfigurationException Indicates that the provided Amazon S3 bucket or AWS KMS encryption
     *         key is invalid, or that Amazon SES could not publish to the bucket, possibly due to permissions issues.
     *         For information about giving permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>InvalidLambdaFunctionException Indicates that the provided AWS Lambda function is invalid, or that
     *         Amazon SES could not execute the provided function, possibly due to permissions issues. For information
     *         about giving permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>AlreadyExistsException Indicates that a resource could not be created because of a naming conflict.</li>
     *         <li>RuleDoesNotExistException Indicates that the provided receipt rule does not exist.</li>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReceiptRuleResponse> createReceiptRule(CreateReceiptRuleRequest createReceiptRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a receipt rule.
     * </p>
     * <p>
     * For information about setting up receipt rules, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReceiptRuleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateReceiptRuleRequest#builder()}
     * </p>
     *
     * @param createReceiptRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateReceiptRuleRequest.Builder} to create a request.
     *        Represents a request to create a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateReceiptRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSnsTopicException Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES
     *         could not publish to the topic, possibly due to permissions issues. For information about giving
     *         permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>InvalidS3ConfigurationException Indicates that the provided Amazon S3 bucket or AWS KMS encryption
     *         key is invalid, or that Amazon SES could not publish to the bucket, possibly due to permissions issues.
     *         For information about giving permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>InvalidLambdaFunctionException Indicates that the provided AWS Lambda function is invalid, or that
     *         Amazon SES could not execute the provided function, possibly due to permissions issues. For information
     *         about giving permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>AlreadyExistsException Indicates that a resource could not be created because of a naming conflict.</li>
     *         <li>RuleDoesNotExistException Indicates that the provided receipt rule does not exist.</li>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReceiptRuleResponse> createReceiptRule(
            Consumer<CreateReceiptRuleRequest.Builder> createReceiptRuleRequest) {
        return createReceiptRule(CreateReceiptRuleRequest.builder().applyMutation(createReceiptRuleRequest).build());
    }

    /**
     * <p>
     * Creates an empty receipt rule set.
     * </p>
     * <p>
     * For information about setting up receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createReceiptRuleSetRequest
     *        Represents a request to create an empty receipt rule set. You use receipt rule sets to receive email with
     *        Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException Indicates that a resource could not be created because of a naming conflict.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReceiptRuleSetResponse> createReceiptRuleSet(
            CreateReceiptRuleSetRequest createReceiptRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty receipt rule set.
     * </p>
     * <p>
     * For information about setting up receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReceiptRuleSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param createReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to create an empty receipt rule set. You use receipt rule sets to receive
     *        email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException Indicates that a resource could not be created because of a naming conflict.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReceiptRuleSetResponse> createReceiptRuleSet(
            Consumer<CreateReceiptRuleSetRequest.Builder> createReceiptRuleSetRequest) {
        return createReceiptRuleSet(CreateReceiptRuleSetRequest.builder().applyMutation(createReceiptRuleSetRequest).build());
    }

    /**
     * <p>
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param createTemplateRequest
     *        Represents a request to create an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException Indicates that a resource could not be created because of a naming conflict.</li>
     *         <li>InvalidTemplateException Indicates that the template that you specified could not be rendered. This
     *         issue may occur when a template refers to a partial that does not exist.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTemplateResponse> createTemplate(CreateTemplateRequest createTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTemplateRequest#builder()}
     * </p>
     *
     * @param createTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateTemplateRequest.Builder} to create a request.
     *        Represents a request to create an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the CreateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException Indicates that a resource could not be created because of a naming conflict.</li>
     *         <li>InvalidTemplateException Indicates that the template that you specified could not be rendered. This
     *         issue may occur when a template refers to a partial that does not exist.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.CreateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTemplateResponse> createTemplate(Consumer<CreateTemplateRequest.Builder> createTemplateRequest) {
        return createTemplate(CreateTemplateRequest.builder().applyMutation(createTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a configuration set. Configuration sets enable you to publish email sending events. For information about
     * using configuration sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        Represents a request to delete a configuration set. Configuration sets enable you to publish email sending
     *        events. For information about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(
            DeleteConfigurationSetRequest deleteConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration set. Configuration sets enable you to publish email sending events. For information about
     * using configuration sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfigurationSetRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationSetRequest.Builder} to create a
     *        request. Represents a request to delete a configuration set. Configuration sets enable you to publish
     *        email sending events. For information about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(
            Consumer<DeleteConfigurationSetRequest.Builder> deleteConfigurationSetRequest) {
        return deleteConfigurationSet(DeleteConfigurationSetRequest.builder().applyMutation(deleteConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a configuration set event destination. Configuration set event destinations are associated with
     * configuration sets, which enable you to publish email sending events. For information about using configuration
     * sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        Represents a request to delete a configuration set event destination. Configuration set event destinations
     *        are associated with configuration sets, which enable you to publish email sending events. For information
     *        about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>EventDestinationDoesNotExistException Indicates that the event destination does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetEventDestinationResponse> deleteConfigurationSetEventDestination(
            DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration set event destination. Configuration set event destinations are associated with
     * configuration sets, which enable you to publish email sending events. For information about using configuration
     * sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. Represents a request to delete a configuration set event destination. Configuration
     *        set event destinations are associated with configuration sets, which enable you to publish email sending
     *        events. For information about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>EventDestinationDoesNotExistException Indicates that the event destination does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetEventDestinationResponse> deleteConfigurationSetEventDestination(
            Consumer<DeleteConfigurationSetEventDestinationRequest.Builder> deleteConfigurationSetEventDestinationRequest) {
        return deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest.builder()
                .applyMutation(deleteConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <note>
     * <p>
     * Deleting this kind of association will result in emails sent using the specified configuration set to capture
     * open and click events using the standard, Amazon SES-operated domains.
     * </p>
     * </note>
     *
     * @param deleteConfigurationSetTrackingOptionsRequest
     *        Represents a request to delete open and click tracking options in a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSetTrackingOptions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>TrackingOptionsDoesNotExistException Indicates that the TrackingOptions object you specified does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetTrackingOptionsResponse> deleteConfigurationSetTrackingOptions(
            DeleteConfigurationSetTrackingOptionsRequest deleteConfigurationSetTrackingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <note>
     * <p>
     * Deleting this kind of association will result in emails sent using the specified configuration set to capture
     * open and click events using the standard, Amazon SES-operated domains.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConfigurationSetTrackingOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConfigurationSetTrackingOptionsRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetTrackingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationSetTrackingOptionsRequest.Builder}
     *        to create a request. Represents a request to delete open and click tracking options in a configuration
     *        set.
     * @return A Java Future containing the result of the DeleteConfigurationSetTrackingOptions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>TrackingOptionsDoesNotExistException Indicates that the TrackingOptions object you specified does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetTrackingOptionsResponse> deleteConfigurationSetTrackingOptions(
            Consumer<DeleteConfigurationSetTrackingOptionsRequest.Builder> deleteConfigurationSetTrackingOptionsRequest) {
        return deleteConfigurationSetTrackingOptions(DeleteConfigurationSetTrackingOptionsRequest.builder()
                .applyMutation(deleteConfigurationSetTrackingOptionsRequest).build());
    }

    /**
     * <p>
     * Deletes an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteCustomVerificationEmailTemplateRequest
     *        Represents a request to delete an existing custom verification email template.
     * @return A Java Future containing the result of the DeleteCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomVerificationEmailTemplateResponse> deleteCustomVerificationEmailTemplate(
            DeleteCustomVerificationEmailTemplateRequest deleteCustomVerificationEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param deleteCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to delete an existing custom verification email template.
     * @return A Java Future containing the result of the DeleteCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomVerificationEmailTemplateResponse> deleteCustomVerificationEmailTemplate(
            Consumer<DeleteCustomVerificationEmailTemplateRequest.Builder> deleteCustomVerificationEmailTemplateRequest) {
        return deleteCustomVerificationEmailTemplate(DeleteCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(deleteCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified identity (an email address or a domain) from the list of verified identities.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteIdentityRequest
     *        Represents a request to delete one of your Amazon SES identities (an email address or domain).
     * @return A Java Future containing the result of the DeleteIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIdentityResponse> deleteIdentity(DeleteIdentityRequest deleteIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified identity (an email address or a domain) from the list of verified identities.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentityRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIdentityRequest#builder()}
     * </p>
     *
     * @param deleteIdentityRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIdentityRequest.Builder} to create a request.
     *        Represents a request to delete one of your Amazon SES identities (an email address or domain).
     * @return A Java Future containing the result of the DeleteIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIdentityResponse> deleteIdentity(Consumer<DeleteIdentityRequest.Builder> deleteIdentityRequest) {
        return deleteIdentity(DeleteIdentityRequest.builder().applyMutation(deleteIdentityRequest).build());
    }

    /**
     * <p>
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteIdentityPolicyRequest
     *        Represents a request to delete a sending authorization policy for an identity. Sending authorization is an
     *        Amazon SES feature that enables you to authorize other senders to use your identities. For information,
     *        see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon
     *        SES Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteIdentityPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIdentityPolicyResponse> deleteIdentityPolicy(
            DeleteIdentityPolicyRequest deleteIdentityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This
     * API returns successfully even if a policy with the specified name does not exist.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentityPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIdentityPolicyRequest#builder()}
     * </p>
     *
     * @param deleteIdentityPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIdentityPolicyRequest.Builder} to create a
     *        request. Represents a request to delete a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteIdentityPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIdentityPolicyResponse> deleteIdentityPolicy(
            Consumer<DeleteIdentityPolicyRequest.Builder> deleteIdentityPolicyRequest) {
        return deleteIdentityPolicy(DeleteIdentityPolicyRequest.builder().applyMutation(deleteIdentityPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified IP address filter.
     * </p>
     * <p>
     * For information about managing IP address filters, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteReceiptFilterRequest
     *        Represents a request to delete an IP address filter. You use IP address filters when you receive email
     *        with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteReceiptFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteReceiptFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReceiptFilterResponse> deleteReceiptFilter(
            DeleteReceiptFilterRequest deleteReceiptFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified IP address filter.
     * </p>
     * <p>
     * For information about managing IP address filters, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReceiptFilterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReceiptFilterRequest#builder()}
     * </p>
     *
     * @param deleteReceiptFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReceiptFilterRequest.Builder} to create a
     *        request. Represents a request to delete an IP address filter. You use IP address filters when you receive
     *        email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteReceiptFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteReceiptFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReceiptFilterResponse> deleteReceiptFilter(
            Consumer<DeleteReceiptFilterRequest.Builder> deleteReceiptFilterRequest) {
        return deleteReceiptFilter(DeleteReceiptFilterRequest.builder().applyMutation(deleteReceiptFilterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified receipt rule.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteReceiptRuleRequest
     *        Represents a request to delete a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteReceiptRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReceiptRuleResponse> deleteReceiptRule(DeleteReceiptRuleRequest deleteReceiptRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified receipt rule.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReceiptRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReceiptRuleRequest#builder()}
     * </p>
     *
     * @param deleteReceiptRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReceiptRuleRequest.Builder} to create a request.
     *        Represents a request to delete a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteReceiptRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReceiptRuleResponse> deleteReceiptRule(
            Consumer<DeleteReceiptRuleRequest.Builder> deleteReceiptRuleRequest) {
        return deleteReceiptRule(DeleteReceiptRuleRequest.builder().applyMutation(deleteReceiptRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified receipt rule set and all of the receipt rules it contains.
     * </p>
     * <note>
     * <p>
     * The currently active rule set cannot be deleted.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteReceiptRuleSetRequest
     *        Represents a request to delete a receipt rule set and all of the receipt rules it contains. You use
     *        receipt rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CannotDeleteException Indicates that the delete operation could not be completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReceiptRuleSetResponse> deleteReceiptRuleSet(
            DeleteReceiptRuleSetRequest deleteReceiptRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified receipt rule set and all of the receipt rules it contains.
     * </p>
     * <note>
     * <p>
     * The currently active rule set cannot be deleted.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReceiptRuleSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param deleteReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to delete a receipt rule set and all of the receipt rules it contains. You
     *        use receipt rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CannotDeleteException Indicates that the delete operation could not be completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReceiptRuleSetResponse> deleteReceiptRuleSet(
            Consumer<DeleteReceiptRuleSetRequest.Builder> deleteReceiptRuleSetRequest) {
        return deleteReceiptRuleSet(DeleteReceiptRuleSetRequest.builder().applyMutation(deleteReceiptRuleSetRequest).build());
    }

    /**
     * <p>
     * Deletes an email template.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param deleteTemplateRequest
     *        Represents a request to delete an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTemplateResponse> deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an email template.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTemplateRequest#builder()}
     * </p>
     *
     * @param deleteTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTemplateRequest.Builder} to create a request.
     *        Represents a request to delete an email template. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DeleteTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTemplateResponse> deleteTemplate(Consumer<DeleteTemplateRequest.Builder> deleteTemplateRequest) {
        return deleteTemplate(DeleteTemplateRequest.builder().applyMutation(deleteTemplateRequest).build());
    }

    /**
     * <p>
     * Deprecated. Use the <code>DeleteIdentity</code> operation to delete email addresses and domains.
     * </p>
     *
     * @param deleteVerifiedEmailAddressRequest
     *        Represents a request to delete an email address from the list of email addresses you have attempted to
     *        verify under your AWS account.
     * @return A Java Future containing the result of the DeleteVerifiedEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteVerifiedEmailAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVerifiedEmailAddressResponse> deleteVerifiedEmailAddress(
            DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecated. Use the <code>DeleteIdentity</code> operation to delete email addresses and domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVerifiedEmailAddressRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVerifiedEmailAddressRequest#builder()}
     * </p>
     *
     * @param deleteVerifiedEmailAddressRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVerifiedEmailAddressRequest.Builder} to create a
     *        request. Represents a request to delete an email address from the list of email addresses you have
     *        attempted to verify under your AWS account.
     * @return A Java Future containing the result of the DeleteVerifiedEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DeleteVerifiedEmailAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVerifiedEmailAddressResponse> deleteVerifiedEmailAddress(
            Consumer<DeleteVerifiedEmailAddressRequest.Builder> deleteVerifiedEmailAddressRequest) {
        return deleteVerifiedEmailAddress(DeleteVerifiedEmailAddressRequest.builder()
                .applyMutation(deleteVerifiedEmailAddressRequest).build());
    }

    /**
     * <p>
     * Returns the metadata and receipt rules for the receipt rule set that is currently active.
     * </p>
     * <p>
     * For information about setting up receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param describeActiveReceiptRuleSetRequest
     *        Represents a request to return the metadata and receipt rules for the receipt rule set that is currently
     *        active. You use receipt rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DescribeActiveReceiptRuleSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DescribeActiveReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeActiveReceiptRuleSetResponse> describeActiveReceiptRuleSet(
            DescribeActiveReceiptRuleSetRequest describeActiveReceiptRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the metadata and receipt rules for the receipt rule set that is currently active.
     * </p>
     * <p>
     * For information about setting up receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActiveReceiptRuleSetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeActiveReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param describeActiveReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActiveReceiptRuleSetRequest.Builder} to create
     *        a request. Represents a request to return the metadata and receipt rules for the receipt rule set that is
     *        currently active. You use receipt rule sets to receive email with Amazon SES. For more information, see
     *        the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon
     *        SES Developer Guide</a>.
     * @return A Java Future containing the result of the DescribeActiveReceiptRuleSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DescribeActiveReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeActiveReceiptRuleSetResponse> describeActiveReceiptRuleSet(
            Consumer<DescribeActiveReceiptRuleSetRequest.Builder> describeActiveReceiptRuleSetRequest) {
        return describeActiveReceiptRuleSet(DescribeActiveReceiptRuleSetRequest.builder()
                .applyMutation(describeActiveReceiptRuleSetRequest).build());
    }

    /**
     * <p>
     * Returns the metadata and receipt rules for the receipt rule set that is currently active.
     * </p>
     * <p>
     * For information about setting up receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeActiveReceiptRuleSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DescribeActiveReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeActiveReceiptRuleSetResponse> describeActiveReceiptRuleSet() {
        return describeActiveReceiptRuleSet(DescribeActiveReceiptRuleSetRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details of the specified configuration set. For information about using configuration sets, see the
     * <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param describeConfigurationSetRequest
     *        Represents a request to return the details of a configuration set. Configuration sets enable you to
     *        publish email sending events. For information about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DescribeConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DescribeConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationSetResponse> describeConfigurationSet(
            DescribeConfigurationSetRequest describeConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the specified configuration set. For information about using configuration sets, see the
     * <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationSetRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConfigurationSetRequest#builder()}
     * </p>
     *
     * @param describeConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationSetRequest.Builder} to create a
     *        request. Represents a request to return the details of a configuration set. Configuration sets enable you
     *        to publish email sending events. For information about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DescribeConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DescribeConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationSetResponse> describeConfigurationSet(
            Consumer<DescribeConfigurationSetRequest.Builder> describeConfigurationSetRequest) {
        return describeConfigurationSet(DescribeConfigurationSetRequest.builder().applyMutation(describeConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Returns the details of the specified receipt rule.
     * </p>
     * <p>
     * For information about setting up receipt rules, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param describeReceiptRuleRequest
     *        Represents a request to return the details of a receipt rule. You use receipt rules to receive email with
     *        Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DescribeReceiptRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleDoesNotExistException Indicates that the provided receipt rule does not exist.</li>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DescribeReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeReceiptRuleResponse> describeReceiptRule(
            DescribeReceiptRuleRequest describeReceiptRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the specified receipt rule.
     * </p>
     * <p>
     * For information about setting up receipt rules, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReceiptRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReceiptRuleRequest#builder()}
     * </p>
     *
     * @param describeReceiptRuleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReceiptRuleRequest.Builder} to create a
     *        request. Represents a request to return the details of a receipt rule. You use receipt rules to receive
     *        email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DescribeReceiptRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleDoesNotExistException Indicates that the provided receipt rule does not exist.</li>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DescribeReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeReceiptRuleResponse> describeReceiptRule(
            Consumer<DescribeReceiptRuleRequest.Builder> describeReceiptRuleRequest) {
        return describeReceiptRule(DescribeReceiptRuleRequest.builder().applyMutation(describeReceiptRuleRequest).build());
    }

    /**
     * <p>
     * Returns the details of the specified receipt rule set.
     * </p>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param describeReceiptRuleSetRequest
     *        Represents a request to return the details of a receipt rule set. You use receipt rule sets to receive
     *        email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DescribeReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DescribeReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReceiptRuleSetResponse> describeReceiptRuleSet(
            DescribeReceiptRuleSetRequest describeReceiptRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the specified receipt rule set.
     * </p>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReceiptRuleSetRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param describeReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to return the details of a receipt rule set. You use receipt rule sets to
     *        receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the DescribeReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.DescribeReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReceiptRuleSetResponse> describeReceiptRuleSet(
            Consumer<DescribeReceiptRuleSetRequest.Builder> describeReceiptRuleSetRequest) {
        return describeReceiptRuleSet(DescribeReceiptRuleSetRequest.builder().applyMutation(describeReceiptRuleSetRequest)
                .build());
    }

    /**
     * <p>
     * Returns the email sending status of the Amazon SES account for the current region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getAccountSendingEnabledRequest
     * @return A Java Future containing the result of the GetAccountSendingEnabled operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetAccountSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetAccountSendingEnabled" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountSendingEnabledResponse> getAccountSendingEnabled(
            GetAccountSendingEnabledRequest getAccountSendingEnabledRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the email sending status of the Amazon SES account for the current region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSendingEnabledRequest.Builder} avoiding
     * the need to create one manually via {@link GetAccountSendingEnabledRequest#builder()}
     * </p>
     *
     * @param getAccountSendingEnabledRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountSendingEnabledRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccountSendingEnabled operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetAccountSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetAccountSendingEnabled" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountSendingEnabledResponse> getAccountSendingEnabled(
            Consumer<GetAccountSendingEnabledRequest.Builder> getAccountSendingEnabledRequest) {
        return getAccountSendingEnabled(GetAccountSendingEnabledRequest.builder().applyMutation(getAccountSendingEnabledRequest)
                .build());
    }

    /**
     * <p>
     * Returns the email sending status of the Amazon SES account for the current region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return A Java Future containing the result of the GetAccountSendingEnabled operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetAccountSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetAccountSendingEnabled" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountSendingEnabledResponse> getAccountSendingEnabled() {
        return getAccountSendingEnabled(GetAccountSendingEnabledRequest.builder().build());
    }

    /**
     * <p>
     * Returns the custom email verification template for the template name you specify.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getCustomVerificationEmailTemplateRequest
     *        Represents a request to retrieve an existing custom verification email template.
     * @return A Java Future containing the result of the GetCustomVerificationEmailTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomVerificationEmailTemplateDoesNotExistException Indicates that a custom verification email
     *         template with the name you specified does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomVerificationEmailTemplateResponse> getCustomVerificationEmailTemplate(
            GetCustomVerificationEmailTemplateRequest getCustomVerificationEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the custom email verification template for the template name you specify.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomVerificationEmailTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link GetCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param getCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetCustomVerificationEmailTemplateRequest.Builder} to
     *        create a request. Represents a request to retrieve an existing custom verification email template.
     * @return A Java Future containing the result of the GetCustomVerificationEmailTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomVerificationEmailTemplateDoesNotExistException Indicates that a custom verification email
     *         template with the name you specified does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomVerificationEmailTemplateResponse> getCustomVerificationEmailTemplate(
            Consumer<GetCustomVerificationEmailTemplateRequest.Builder> getCustomVerificationEmailTemplateRequest) {
        return getCustomVerificationEmailTemplate(GetCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(getCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Returns the current status of Easy DKIM signing for an entity. For domain name identities, this operation also
     * returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified
     * that these tokens have been published.
     * </p>
     * <p>
     * This operation takes a list of identities as input and returns the following information for each:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Whether Easy DKIM signing is enabled or disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * A set of DKIM tokens that represent the identity. If the identity is an email address, the tokens represent the
     * domain of that address.
     * </p>
     * </li>
     * <li>
     * <p>
     * Whether Amazon SES has successfully verified the DKIM tokens published in the domain's DNS. This information is
     * only returned for domain name identities, not for email addresses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is throttled at one request per second and can only get DKIM attributes for up to 100 identities
     * at a time.
     * </p>
     * <p>
     * For more information about creating DNS records using DKIM tokens, go to the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     *
     * @param getIdentityDkimAttributesRequest
     *        Represents a request for the status of Amazon SES Easy DKIM signing for an identity. For domain
     *        identities, this request also returns the DKIM tokens that are required for Easy DKIM signing, and whether
     *        Amazon SES successfully verified that these tokens were published. For more information about Easy DKIM,
     *        see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the GetIdentityDkimAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetIdentityDkimAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityDkimAttributesResponse> getIdentityDkimAttributes(
            GetIdentityDkimAttributesRequest getIdentityDkimAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of Easy DKIM signing for an entity. For domain name identities, this operation also
     * returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified
     * that these tokens have been published.
     * </p>
     * <p>
     * This operation takes a list of identities as input and returns the following information for each:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Whether Easy DKIM signing is enabled or disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * A set of DKIM tokens that represent the identity. If the identity is an email address, the tokens represent the
     * domain of that address.
     * </p>
     * </li>
     * <li>
     * <p>
     * Whether Amazon SES has successfully verified the DKIM tokens published in the domain's DNS. This information is
     * only returned for domain name identities, not for email addresses.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is throttled at one request per second and can only get DKIM attributes for up to 100 identities
     * at a time.
     * </p>
     * <p>
     * For more information about creating DNS records using DKIM tokens, go to the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityDkimAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link GetIdentityDkimAttributesRequest#builder()}
     * </p>
     *
     * @param getIdentityDkimAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityDkimAttributesRequest.Builder} to create a
     *        request. Represents a request for the status of Amazon SES Easy DKIM signing for an identity. For domain
     *        identities, this request also returns the DKIM tokens that are required for Easy DKIM signing, and whether
     *        Amazon SES successfully verified that these tokens were published. For more information about Easy DKIM,
     *        see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the GetIdentityDkimAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetIdentityDkimAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityDkimAttributesResponse> getIdentityDkimAttributes(
            Consumer<GetIdentityDkimAttributesRequest.Builder> getIdentityDkimAttributesRequest) {
        return getIdentityDkimAttributes(GetIdentityDkimAttributesRequest.builder()
                .applyMutation(getIdentityDkimAttributesRequest).build());
    }

    /**
     * <p>
     * Returns the custom MAIL FROM attributes for a list of identities (email addresses : domains).
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get custom MAIL FROM attributes for up to 100
     * identities at a time.
     * </p>
     *
     * @param getIdentityMailFromDomainAttributesRequest
     *        Represents a request to return the Amazon SES custom MAIL FROM attributes for a list of identities. For
     *        information about using a custom MAIL FROM domain, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the GetIdentityMailFromDomainAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetIdentityMailFromDomainAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityMailFromDomainAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityMailFromDomainAttributesResponse> getIdentityMailFromDomainAttributes(
            GetIdentityMailFromDomainAttributesRequest getIdentityMailFromDomainAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the custom MAIL FROM attributes for a list of identities (email addresses : domains).
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get custom MAIL FROM attributes for up to 100
     * identities at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityMailFromDomainAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link GetIdentityMailFromDomainAttributesRequest#builder()}
     * </p>
     *
     * @param getIdentityMailFromDomainAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityMailFromDomainAttributesRequest.Builder} to
     *        create a request. Represents a request to return the Amazon SES custom MAIL FROM attributes for a list of
     *        identities. For information about using a custom MAIL FROM domain, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the GetIdentityMailFromDomainAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetIdentityMailFromDomainAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityMailFromDomainAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityMailFromDomainAttributesResponse> getIdentityMailFromDomainAttributes(
            Consumer<GetIdentityMailFromDomainAttributesRequest.Builder> getIdentityMailFromDomainAttributesRequest) {
        return getIdentityMailFromDomainAttributes(GetIdentityMailFromDomainAttributesRequest.builder()
                .applyMutation(getIdentityMailFromDomainAttributesRequest).build());
    }

    /**
     * <p>
     * Given a list of verified identities (email addresses and/or domains), returns a structure describing identity
     * notification attributes.
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get notification attributes for up to 100
     * identities at a time.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     *
     * @param getIdentityNotificationAttributesRequest
     *        Represents a request to return the notification attributes for a list of identities you verified with
     *        Amazon SES. For information about Amazon SES notifications, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the GetIdentityNotificationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetIdentityNotificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityNotificationAttributesResponse> getIdentityNotificationAttributes(
            GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a list of verified identities (email addresses and/or domains), returns a structure describing identity
     * notification attributes.
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get notification attributes for up to 100
     * identities at a time.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityNotificationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link GetIdentityNotificationAttributesRequest#builder()}
     * </p>
     *
     * @param getIdentityNotificationAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityNotificationAttributesRequest.Builder} to
     *        create a request. Represents a request to return the notification attributes for a list of identities you
     *        verified with Amazon SES. For information about Amazon SES notifications, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the GetIdentityNotificationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetIdentityNotificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityNotificationAttributesResponse> getIdentityNotificationAttributes(
            Consumer<GetIdentityNotificationAttributesRequest.Builder> getIdentityNotificationAttributesRequest) {
        return getIdentityNotificationAttributes(GetIdentityNotificationAttributesRequest.builder()
                .applyMutation(getIdentityNotificationAttributesRequest).build());
    }

    /**
     * <p>
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The
     * policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a
     * time.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getIdentityPoliciesRequest
     *        Represents a request to return the requested sending authorization policies for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the GetIdentityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetIdentityPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIdentityPoliciesResponse> getIdentityPolicies(
            GetIdentityPoliciesRequest getIdentityPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The
     * policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a
     * time.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetIdentityPoliciesRequest#builder()}
     * </p>
     *
     * @param getIdentityPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityPoliciesRequest.Builder} to create a
     *        request. Represents a request to return the requested sending authorization policies for an identity.
     *        Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your
     *        identities. For information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the GetIdentityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetIdentityPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIdentityPoliciesResponse> getIdentityPolicies(
            Consumer<GetIdentityPoliciesRequest.Builder> getIdentityPoliciesRequest) {
        return getIdentityPolicies(GetIdentityPoliciesRequest.builder().applyMutation(getIdentityPoliciesRequest).build());
    }

    /**
     * <p>
     * Given a list of identities (email addresses and/or domains), returns the verification status and (for domain
     * identities) the verification token for each identity.
     * </p>
     * <p>
     * The verification status of an email address is "Pending" until the email address owner clicks the link within the
     * verification email that Amazon SES sent to that address. If the email address owner clicks the link within 24
     * hours, the verification status of the email address changes to "Success". If the link is not clicked within 24
     * hours, the verification status changes to "Failed." In that case, if you still want to verify the email address,
     * you must restart the verification process from the beginning.
     * </p>
     * <p>
     * For domain identities, the domain's verification status is "Pending" as Amazon SES searches for the required TXT
     * record in the DNS settings of the domain. When Amazon SES detects the record, the domain's verification status
     * changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification
     * status changes to "Failed." In that case, if you still want to verify the domain, you must restart the
     * verification process from the beginning.
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get verification attributes for up to 100
     * identities at a time.
     * </p>
     *
     * @param getIdentityVerificationAttributesRequest
     *        Represents a request to return the Amazon SES verification status of a list of identities. For domain
     *        identities, this request also returns the verification token. For information about verifying identities
     *        with Amazon SES, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the GetIdentityVerificationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetIdentityVerificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityVerificationAttributesResponse> getIdentityVerificationAttributes(
            GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a list of identities (email addresses and/or domains), returns the verification status and (for domain
     * identities) the verification token for each identity.
     * </p>
     * <p>
     * The verification status of an email address is "Pending" until the email address owner clicks the link within the
     * verification email that Amazon SES sent to that address. If the email address owner clicks the link within 24
     * hours, the verification status of the email address changes to "Success". If the link is not clicked within 24
     * hours, the verification status changes to "Failed." In that case, if you still want to verify the email address,
     * you must restart the verification process from the beginning.
     * </p>
     * <p>
     * For domain identities, the domain's verification status is "Pending" as Amazon SES searches for the required TXT
     * record in the DNS settings of the domain. When Amazon SES detects the record, the domain's verification status
     * changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification
     * status changes to "Failed." In that case, if you still want to verify the domain, you must restart the
     * verification process from the beginning.
     * </p>
     * <p>
     * This operation is throttled at one request per second and can only get verification attributes for up to 100
     * identities at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityVerificationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link GetIdentityVerificationAttributesRequest#builder()}
     * </p>
     *
     * @param getIdentityVerificationAttributesRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityVerificationAttributesRequest.Builder} to
     *        create a request. Represents a request to return the Amazon SES verification status of a list of
     *        identities. For domain identities, this request also returns the verification token. For information about
     *        verifying identities with Amazon SES, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the GetIdentityVerificationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetIdentityVerificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityVerificationAttributesResponse> getIdentityVerificationAttributes(
            Consumer<GetIdentityVerificationAttributesRequest.Builder> getIdentityVerificationAttributesRequest) {
        return getIdentityVerificationAttributes(GetIdentityVerificationAttributesRequest.builder()
                .applyMutation(getIdentityVerificationAttributesRequest).build());
    }

    /**
     * <p>
     * Provides the sending limits for the Amazon SES account.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getSendQuotaRequest
     * @return A Java Future containing the result of the GetSendQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetSendQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuota" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSendQuotaResponse> getSendQuota(GetSendQuotaRequest getSendQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the sending limits for the Amazon SES account.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSendQuotaRequest.Builder} avoiding the need to
     * create one manually via {@link GetSendQuotaRequest#builder()}
     * </p>
     *
     * @param getSendQuotaRequest
     *        A {@link Consumer} that will call methods on {@link GetSendQuotaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSendQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetSendQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuota" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSendQuotaResponse> getSendQuota(Consumer<GetSendQuotaRequest.Builder> getSendQuotaRequest) {
        return getSendQuota(GetSendQuotaRequest.builder().applyMutation(getSendQuotaRequest).build());
    }

    /**
     * <p>
     * Provides the sending limits for the Amazon SES account.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return A Java Future containing the result of the GetSendQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetSendQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuota" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSendQuotaResponse> getSendQuota() {
        return getSendQuota(GetSendQuotaRequest.builder().build());
    }

    /**
     * <p>
     * Provides sending statistics for the current AWS Region. The result is a list of data points, representing the
     * last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of
     * time.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getSendStatisticsRequest
     * @return A Java Future containing the result of the GetSendStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetSendStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSendStatisticsResponse> getSendStatistics(GetSendStatisticsRequest getSendStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides sending statistics for the current AWS Region. The result is a list of data points, representing the
     * last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of
     * time.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSendStatisticsRequest.Builder} avoiding the need
     * to create one manually via {@link GetSendStatisticsRequest#builder()}
     * </p>
     *
     * @param getSendStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetSendStatisticsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSendStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetSendStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSendStatisticsResponse> getSendStatistics(
            Consumer<GetSendStatisticsRequest.Builder> getSendStatisticsRequest) {
        return getSendStatistics(GetSendStatisticsRequest.builder().applyMutation(getSendStatisticsRequest).build());
    }

    /**
     * <p>
     * Provides sending statistics for the current AWS Region. The result is a list of data points, representing the
     * last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of
     * time.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return A Java Future containing the result of the GetSendStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetSendStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSendStatisticsResponse> getSendStatistics() {
        return getSendStatistics(GetSendStatisticsRequest.builder().build());
    }

    /**
     * <p>
     * Displays the template object (which includes the Subject line, HTML part and text part) for the template you
     * specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param getTemplateRequest
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TemplateDoesNotExistException Indicates that the Template object you specified does not exist in your
     *         Amazon SES account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTemplateResponse> getTemplate(GetTemplateRequest getTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the template object (which includes the Subject line, HTML part and text part) for the template you
     * specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetTemplateRequest#builder()}
     * </p>
     *
     * @param getTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TemplateDoesNotExistException Indicates that the Template object you specified does not exist in your
     *         Amazon SES account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.GetTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTemplateResponse> getTemplate(Consumer<GetTemplateRequest.Builder> getTemplateRequest) {
        return getTemplate(GetTemplateRequest.builder().applyMutation(getTemplateRequest).build());
    }

    /**
     * <p>
     * Provides a list of the configuration sets associated with your Amazon SES account in the current AWS Region. For
     * information about using configuration sets, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon
     * SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <p>
     * You can execute this operation no more than once per second. This operation will return up to 1,000 configuration
     * sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation will
     * also return a NextToken element. You can then execute the <code>ListConfigurationSets</code> operation again,
     * passing the <code>NextToken</code> parameter and the value of the NextToken element to retrieve additional
     * results.
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        Represents a request to list the configuration sets associated with your AWS account. Configuration sets
     *        enable you to publish email sending events. For information about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConfigurationSetsResponse> listConfigurationSets(
            ListConfigurationSetsRequest listConfigurationSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of the configuration sets associated with your Amazon SES account in the current AWS Region. For
     * information about using configuration sets, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon
     * SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <p>
     * You can execute this operation no more than once per second. This operation will return up to 1,000 configuration
     * sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation will
     * also return a NextToken element. You can then execute the <code>ListConfigurationSets</code> operation again,
     * passing the <code>NextToken</code> parameter and the value of the NextToken element to retrieve additional
     * results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigurationSetsRequest.Builder} to create a
     *        request. Represents a request to list the configuration sets associated with your AWS account.
     *        Configuration sets enable you to publish email sending events. For information about using configuration
     *        sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConfigurationSetsResponse> listConfigurationSets(
            Consumer<ListConfigurationSetsRequest.Builder> listConfigurationSetsRequest) {
        return listConfigurationSets(ListConfigurationSetsRequest.builder().applyMutation(listConfigurationSetsRequest).build());
    }

    /**
     * <p>
     * Provides a list of the configuration sets associated with your Amazon SES account in the current AWS Region. For
     * information about using configuration sets, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon
     * SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <p>
     * You can execute this operation no more than once per second. This operation will return up to 1,000 configuration
     * sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation will
     * also return a NextToken element. You can then execute the <code>ListConfigurationSets</code> operation again,
     * passing the <code>NextToken</code> parameter and the value of the NextToken element to retrieve additional
     * results.
     * </p>
     *
     * @return A Java Future containing the result of the ListConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConfigurationSetsResponse> listConfigurationSets() {
        return listConfigurationSets(ListConfigurationSetsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        Represents a request to list the existing custom verification email templates for your account.</p>
     *        <p>
     *        For more information about custom verification email templates, see <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     *        Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * @return A Java Future containing the result of the ListCustomVerificationEmailTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as
     *         an IO related failure, failure to get credentials, etc.</li> <li>SesException Base class for all service
     *         exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomVerificationEmailTemplatesResponse> listCustomVerificationEmailTemplates(
            ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomVerificationEmailTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomVerificationEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomVerificationEmailTemplatesRequest.Builder}
     *        to create a request. Represents a request to list the existing custom verification email templates for
     *        your account.</p>
     *        <p>
     *        For more information about custom verification email templates, see <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     *        Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * @return A Java Future containing the result of the ListCustomVerificationEmailTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as
     *         an IO related failure, failure to get credentials, etc.</li> <li>SesException Base class for all service
     *         exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomVerificationEmailTemplatesResponse> listCustomVerificationEmailTemplates(
            Consumer<ListCustomVerificationEmailTemplatesRequest.Builder> listCustomVerificationEmailTemplatesRequest) {
        return listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest.builder()
                .applyMutation(listCustomVerificationEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return A Java Future containing the result of the ListCustomVerificationEmailTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomVerificationEmailTemplatesResponse> listCustomVerificationEmailTemplates() {
        return listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesPublisher publisher = client.listCustomVerificationEmailTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesPublisher publisher = client.listCustomVerificationEmailTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesPublisher listCustomVerificationEmailTemplatesPaginator() {
        return listCustomVerificationEmailTemplatesPaginator(ListCustomVerificationEmailTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesPublisher publisher = client.listCustomVerificationEmailTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesPublisher publisher = client.listCustomVerificationEmailTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        Represents a request to list the existing custom verification email templates for your account.</p>
     *        <p>
     *        For more information about custom verification email templates, see <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     *        Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as
     *         an IO related failure, failure to get credentials, etc.</li> <li>SesException Base class for all service
     *         exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesPublisher listCustomVerificationEmailTemplatesPaginator(
            ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing custom verification email templates for your account in the current AWS Region.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesPublisher publisher = client.listCustomVerificationEmailTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesPublisher publisher = client.listCustomVerificationEmailTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomVerificationEmailTemplates(software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomVerificationEmailTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomVerificationEmailTemplatesRequest#builder()}
     * </p>
     *
     * @param listCustomVerificationEmailTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomVerificationEmailTemplatesRequest.Builder}
     *        to create a request. Represents a request to list the existing custom verification email templates for
     *        your account.</p>
     *        <p>
     *        For more information about custom verification email templates, see <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     *        Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as
     *         an IO related failure, failure to get credentials, etc.</li> <li>SesException Base class for all service
     *         exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListCustomVerificationEmailTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomVerificationEmailTemplatesPublisher listCustomVerificationEmailTemplatesPaginator(
            Consumer<ListCustomVerificationEmailTemplatesRequest.Builder> listCustomVerificationEmailTemplatesRequest) {
        return listCustomVerificationEmailTemplatesPaginator(ListCustomVerificationEmailTemplatesRequest.builder()
                .applyMutation(listCustomVerificationEmailTemplatesRequest).build());
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listIdentitiesRequest
     *        Represents a request to return a list of all identities (email addresses and domains) that you have
     *        attempted to verify under your AWS account, regardless of verification status.
     * @return A Java Future containing the result of the ListIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIdentitiesResponse> listIdentities(ListIdentitiesRequest listIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIdentitiesRequest#builder()}
     * </p>
     *
     * @param listIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentitiesRequest.Builder} to create a request.
     *        Represents a request to return a list of all identities (email addresses and domains) that you have
     *        attempted to verify under your AWS account, regardless of verification status.
     * @return A Java Future containing the result of the ListIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIdentitiesResponse> listIdentities(Consumer<ListIdentitiesRequest.Builder> listIdentitiesRequest) {
        return listIdentities(ListIdentitiesRequest.builder().applyMutation(listIdentitiesRequest).build());
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return A Java Future containing the result of the ListIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIdentitiesResponse> listIdentities() {
        return listIdentities(ListIdentitiesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesPublisher publisher = client.listIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesPublisher publisher = client.listIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ses.model.ListIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ses.model.ListIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitiesPublisher listIdentitiesPaginator() {
        return listIdentitiesPaginator(ListIdentitiesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesPublisher publisher = client.listIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesPublisher publisher = client.listIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ses.model.ListIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ses.model.ListIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)} operation.</b>
     * </p>
     *
     * @param listIdentitiesRequest
     *        Represents a request to return a list of all identities (email addresses and domains) that you have
     *        attempted to verify under your AWS account, regardless of verification status.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitiesPublisher listIdentitiesPaginator(ListIdentitiesRequest listIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current
     * AWS Region, regardless of verification status.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesPublisher publisher = client.listIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ses.paginators.ListIdentitiesPublisher publisher = client.listIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ses.model.ListIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ses.model.ListIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentities(software.amazon.awssdk.services.ses.model.ListIdentitiesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIdentitiesRequest#builder()}
     * </p>
     *
     * @param listIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentitiesRequest.Builder} to create a request.
     *        Represents a request to return a list of all identities (email addresses and domains) that you have
     *        attempted to verify under your AWS account, regardless of verification status.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIdentitiesPublisher listIdentitiesPaginator(Consumer<ListIdentitiesRequest.Builder> listIdentitiesRequest) {
        return listIdentitiesPaginator(ListIdentitiesRequest.builder().applyMutation(listIdentitiesRequest).build());
    }

    /**
     * <p>
     * Returns a list of sending authorization policies that are attached to the given identity (an email address or a
     * domain). This API returns only a list. If you want the actual policy content, you can use
     * <code>GetIdentityPolicies</code>.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listIdentityPoliciesRequest
     *        Represents a request to return a list of sending authorization policies that are attached to an identity.
     *        Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your
     *        identities. For information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListIdentityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListIdentityPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentityPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIdentityPoliciesResponse> listIdentityPolicies(
            ListIdentityPoliciesRequest listIdentityPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of sending authorization policies that are attached to the given identity (an email address or a
     * domain). This API returns only a list. If you want the actual policy content, you can use
     * <code>GetIdentityPolicies</code>.
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityPoliciesRequest#builder()}
     * </p>
     *
     * @param listIdentityPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentityPoliciesRequest.Builder} to create a
     *        request. Represents a request to return a list of sending authorization policies that are attached to an
     *        identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to
     *        use your identities. For information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListIdentityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListIdentityPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentityPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIdentityPoliciesResponse> listIdentityPolicies(
            Consumer<ListIdentityPoliciesRequest.Builder> listIdentityPoliciesRequest) {
        return listIdentityPolicies(ListIdentityPoliciesRequest.builder().applyMutation(listIdentityPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the IP address filters associated with your AWS account in the current AWS Region.
     * </p>
     * <p>
     * For information about managing IP address filters, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listReceiptFiltersRequest
     *        Represents a request to list the IP address filters that exist under your AWS account. You use IP address
     *        filters when you receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListReceiptFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListReceiptFilters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReceiptFiltersResponse> listReceiptFilters(ListReceiptFiltersRequest listReceiptFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IP address filters associated with your AWS account in the current AWS Region.
     * </p>
     * <p>
     * For information about managing IP address filters, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReceiptFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link ListReceiptFiltersRequest#builder()}
     * </p>
     *
     * @param listReceiptFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListReceiptFiltersRequest.Builder} to create a
     *        request. Represents a request to list the IP address filters that exist under your AWS account. You use IP
     *        address filters when you receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListReceiptFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListReceiptFilters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReceiptFiltersResponse> listReceiptFilters(
            Consumer<ListReceiptFiltersRequest.Builder> listReceiptFiltersRequest) {
        return listReceiptFilters(ListReceiptFiltersRequest.builder().applyMutation(listReceiptFiltersRequest).build());
    }

    /**
     * <p>
     * Lists the IP address filters associated with your AWS account in the current AWS Region.
     * </p>
     * <p>
     * For information about managing IP address filters, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return A Java Future containing the result of the ListReceiptFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListReceiptFilters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReceiptFiltersResponse> listReceiptFilters() {
        return listReceiptFilters(ListReceiptFiltersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the receipt rule sets that exist under your AWS account in the current AWS Region. If there are additional
     * receipt rule sets to be retrieved, you will receive a <code>NextToken</code> that you can provide to the next
     * call to <code>ListReceiptRuleSets</code> to retrieve the additional entries.
     * </p>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listReceiptRuleSetsRequest
     *        Represents a request to list the receipt rule sets that exist under your AWS account. You use receipt rule
     *        sets to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListReceiptRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListReceiptRuleSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReceiptRuleSetsResponse> listReceiptRuleSets(
            ListReceiptRuleSetsRequest listReceiptRuleSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the receipt rule sets that exist under your AWS account in the current AWS Region. If there are additional
     * receipt rule sets to be retrieved, you will receive a <code>NextToken</code> that you can provide to the next
     * call to <code>ListReceiptRuleSets</code> to retrieve the additional entries.
     * </p>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReceiptRuleSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReceiptRuleSetsRequest#builder()}
     * </p>
     *
     * @param listReceiptRuleSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListReceiptRuleSetsRequest.Builder} to create a
     *        request. Represents a request to list the receipt rule sets that exist under your AWS account. You use
     *        receipt rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ListReceiptRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListReceiptRuleSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReceiptRuleSetsResponse> listReceiptRuleSets(
            Consumer<ListReceiptRuleSetsRequest.Builder> listReceiptRuleSetsRequest) {
        return listReceiptRuleSets(ListReceiptRuleSetsRequest.builder().applyMutation(listReceiptRuleSetsRequest).build());
    }

    /**
     * <p>
     * Lists the receipt rule sets that exist under your AWS account in the current AWS Region. If there are additional
     * receipt rule sets to be retrieved, you will receive a <code>NextToken</code> that you can provide to the next
     * call to <code>ListReceiptRuleSets</code> to retrieve the additional entries.
     * </p>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return A Java Future containing the result of the ListReceiptRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListReceiptRuleSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReceiptRuleSetsResponse> listReceiptRuleSets() {
        return listReceiptRuleSets(ListReceiptRuleSetsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current AWS Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param listTemplatesRequest
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTemplatesResponse> listTemplates(ListTemplatesRequest listTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current AWS Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplatesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTemplatesResponse> listTemplates(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest) {
        return listTemplates(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists the email templates present in your Amazon SES account in the current AWS Region.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTemplatesResponse> listTemplates() {
        return listTemplates(ListTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Deprecated. Use the <code>ListIdentities</code> operation to list the email addresses and domains associated with
     * your account.
     * </p>
     *
     * @param listVerifiedEmailAddressesRequest
     * @return A Java Future containing the result of the ListVerifiedEmailAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListVerifiedEmailAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVerifiedEmailAddressesResponse> listVerifiedEmailAddresses(
            ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecated. Use the <code>ListIdentities</code> operation to list the email addresses and domains associated with
     * your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVerifiedEmailAddressesRequest.Builder} avoiding
     * the need to create one manually via {@link ListVerifiedEmailAddressesRequest#builder()}
     * </p>
     *
     * @param listVerifiedEmailAddressesRequest
     *        A {@link Consumer} that will call methods on {@link ListVerifiedEmailAddressesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVerifiedEmailAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListVerifiedEmailAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVerifiedEmailAddressesResponse> listVerifiedEmailAddresses(
            Consumer<ListVerifiedEmailAddressesRequest.Builder> listVerifiedEmailAddressesRequest) {
        return listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest.builder()
                .applyMutation(listVerifiedEmailAddressesRequest).build());
    }

    /**
     * <p>
     * Deprecated. Use the <code>ListIdentities</code> operation to list the email addresses and domains associated with
     * your account.
     * </p>
     *
     * @return A Java Future containing the result of the ListVerifiedEmailAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ListVerifiedEmailAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVerifiedEmailAddressesResponse> listVerifiedEmailAddresses() {
        return listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest.builder().build());
    }

    /**
     * <p>
     * Adds or updates the delivery options for a configuration set.
     * </p>
     *
     * @param putConfigurationSetDeliveryOptionsRequest
     *        A request to modify the delivery options for a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetDeliveryOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>InvalidDeliveryOptionsException Indicates that provided delivery option is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.PutConfigurationSetDeliveryOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutConfigurationSetDeliveryOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetDeliveryOptionsResponse> putConfigurationSetDeliveryOptions(
            PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates the delivery options for a configuration set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetDeliveryOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetDeliveryOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetDeliveryOptionsRequest
     *        A {@link Consumer} that will call methods on {@link PutConfigurationSetDeliveryOptionsRequest.Builder} to
     *        create a request. A request to modify the delivery options for a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetDeliveryOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>InvalidDeliveryOptionsException Indicates that provided delivery option is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.PutConfigurationSetDeliveryOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutConfigurationSetDeliveryOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetDeliveryOptionsResponse> putConfigurationSetDeliveryOptions(
            Consumer<PutConfigurationSetDeliveryOptionsRequest.Builder> putConfigurationSetDeliveryOptionsRequest) {
        return putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest.builder()
                .applyMutation(putConfigurationSetDeliveryOptionsRequest).build());
    }

    /**
     * <p>
     * Adds or updates a sending authorization policy for the specified identity (an email address or a domain).
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param putIdentityPolicyRequest
     *        Represents a request to add or update a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the PutIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPolicyException Indicates that the provided policy is invalid. Check the error stack for more
     *         information about what caused the error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.PutIdentityPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutIdentityPolicyResponse> putIdentityPolicy(PutIdentityPolicyRequest putIdentityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates a sending authorization policy for the specified identity (an email address or a domain).
     * </p>
     * <note>
     * <p>
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     * </p>
     * </note>
     * <p>
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its
     * identities. For information about using sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutIdentityPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutIdentityPolicyRequest#builder()}
     * </p>
     *
     * @param putIdentityPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutIdentityPolicyRequest.Builder} to create a request.
     *        Represents a request to add or update a sending authorization policy for an identity. Sending
     *        authorization is an Amazon SES feature that enables you to authorize other senders to use your identities.
     *        For information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the PutIdentityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPolicyException Indicates that the provided policy is invalid. Check the error stack for more
     *         information about what caused the error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.PutIdentityPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutIdentityPolicyResponse> putIdentityPolicy(
            Consumer<PutIdentityPolicyRequest.Builder> putIdentityPolicyRequest) {
        return putIdentityPolicy(PutIdentityPolicyRequest.builder().applyMutation(putIdentityPolicyRequest).build());
    }

    /**
     * <p>
     * Reorders the receipt rules within a receipt rule set.
     * </p>
     * <note>
     * <p>
     * All of the rules in the rule set must be represented in this request. That is, this API will return an error if
     * the reorder request doesn't explicitly position all of the rules.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param reorderReceiptRuleSetRequest
     *        Represents a request to reorder the receipt rules within a receipt rule set. You use receipt rule sets to
     *        receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ReorderReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>RuleDoesNotExistException Indicates that the provided receipt rule does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ReorderReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReorderReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ReorderReceiptRuleSetResponse> reorderReceiptRuleSet(
            ReorderReceiptRuleSetRequest reorderReceiptRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reorders the receipt rules within a receipt rule set.
     * </p>
     * <note>
     * <p>
     * All of the rules in the rule set must be represented in this request. That is, this API will return an error if
     * the reorder request doesn't explicitly position all of the rules.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReorderReceiptRuleSetRequest.Builder} avoiding the
     * need to create one manually via {@link ReorderReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param reorderReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link ReorderReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to reorder the receipt rules within a receipt rule set. You use receipt rule
     *        sets to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the ReorderReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>RuleDoesNotExistException Indicates that the provided receipt rule does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.ReorderReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReorderReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ReorderReceiptRuleSetResponse> reorderReceiptRuleSet(
            Consumer<ReorderReceiptRuleSetRequest.Builder> reorderReceiptRuleSetRequest) {
        return reorderReceiptRuleSet(ReorderReceiptRuleSetRequest.builder().applyMutation(reorderReceiptRuleSetRequest).build());
    }

    /**
     * <p>
     * Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use
     * this API on an email up to 24 hours after you receive it.
     * </p>
     * <note>
     * <p>
     * You cannot use this API to send generic bounces for mail that was not received by Amazon SES.
     * </p>
     * </note>
     * <p>
     * For information about receiving email through Amazon SES, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param sendBounceRequest
     *        Represents a request to send a bounce message to the sender of an email you received through Amazon SES.
     * @return A Java Future containing the result of the SendBounce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendBounce
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBounce" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendBounceResponse> sendBounce(SendBounceRequest sendBounceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use
     * this API on an email up to 24 hours after you receive it.
     * </p>
     * <note>
     * <p>
     * You cannot use this API to send generic bounces for mail that was not received by Amazon SES.
     * </p>
     * </note>
     * <p>
     * For information about receiving email through Amazon SES, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendBounceRequest.Builder} avoiding the need to
     * create one manually via {@link SendBounceRequest#builder()}
     * </p>
     *
     * @param sendBounceRequest
     *        A {@link Consumer} that will call methods on {@link SendBounceRequest.Builder} to create a request.
     *        Represents a request to send a bounce message to the sender of an email you received through Amazon SES.
     * @return A Java Future containing the result of the SendBounce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendBounce
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBounce" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendBounceResponse> sendBounce(Consumer<SendBounceRequest.Builder> sendBounceRequest) {
        return sendBounce(SendBounceRequest.builder().applyMutation(sendBounceRequest).build());
    }

    /**
     * <p>
     * Composes an email message to multiple destinations. The message body is created using an email template.
     * </p>
     * <p>
     * In order to send email using the <code>SendBulkTemplatedEmail</code> operation, your call to the API must meet
     * the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The call must refer to an existing email template. You can create email templates using the <a>CreateTemplate</a>
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each <code>Destination</code> parameter must include at least one recipient email address. The recipient address
     * can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is
     * not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even
     * if the message contains other recipients that are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an
     * email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call
     * the <code>SendBulkTemplatedEmail</code> operation several times to send the message to each group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of destinations you can contact in a single call to the API may be limited by your account's maximum
     * sending rate.
     * </p>
     * </li>
     * </ul>
     *
     * @param sendBulkTemplatedEmailRequest
     *        Represents a request to send a templated email to multiple destinations using Amazon SES. For more
     *        information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendBulkTemplatedEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>MailFromDomainNotVerifiedException Indicates that the message could not be sent because Amazon SES
     *         could not read the MX record required to use the specified MAIL FROM domain. For information about
     *         editing the custom MAIL FROM domain settings for an identity, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.</li>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>TemplateDoesNotExistException Indicates that the Template object you specified does not exist in your
     *         Amazon SES account.</li>
     *         <li>ConfigurationSetSendingPausedException Indicates that email sending is disabled for the configuration
     *         set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.</li>
     *         <li>AccountSendingPausedException Indicates that email sending is disabled for your entire Amazon SES
     *         account.</p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendBulkTemplatedEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBulkTemplatedEmail" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SendBulkTemplatedEmailResponse> sendBulkTemplatedEmail(
            SendBulkTemplatedEmailRequest sendBulkTemplatedEmailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Composes an email message to multiple destinations. The message body is created using an email template.
     * </p>
     * <p>
     * In order to send email using the <code>SendBulkTemplatedEmail</code> operation, your call to the API must meet
     * the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The call must refer to an existing email template. You can create email templates using the <a>CreateTemplate</a>
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each <code>Destination</code> parameter must include at least one recipient email address. The recipient address
     * can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is
     * not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even
     * if the message contains other recipients that are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an
     * email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call
     * the <code>SendBulkTemplatedEmail</code> operation several times to send the message to each group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of destinations you can contact in a single call to the API may be limited by your account's maximum
     * sending rate.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendBulkTemplatedEmailRequest.Builder} avoiding the
     * need to create one manually via {@link SendBulkTemplatedEmailRequest#builder()}
     * </p>
     *
     * @param sendBulkTemplatedEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendBulkTemplatedEmailRequest.Builder} to create a
     *        request. Represents a request to send a templated email to multiple destinations using Amazon SES. For
     *        more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendBulkTemplatedEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>MailFromDomainNotVerifiedException Indicates that the message could not be sent because Amazon SES
     *         could not read the MX record required to use the specified MAIL FROM domain. For information about
     *         editing the custom MAIL FROM domain settings for an identity, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.</li>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>TemplateDoesNotExistException Indicates that the Template object you specified does not exist in your
     *         Amazon SES account.</li>
     *         <li>ConfigurationSetSendingPausedException Indicates that email sending is disabled for the configuration
     *         set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.</li>
     *         <li>AccountSendingPausedException Indicates that email sending is disabled for your entire Amazon SES
     *         account.</p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendBulkTemplatedEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBulkTemplatedEmail" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SendBulkTemplatedEmailResponse> sendBulkTemplatedEmail(
            Consumer<SendBulkTemplatedEmailRequest.Builder> sendBulkTemplatedEmailRequest) {
        return sendBulkTemplatedEmail(SendBulkTemplatedEmailRequest.builder().applyMutation(sendBulkTemplatedEmailRequest)
                .build());
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current AWS Region and
     * attempts to verify it. As a result of executing this operation, a customized verification email is sent to the
     * specified address.
     * </p>
     * <p>
     * To use this operation, you must first create a custom verification email template. For more information about
     * creating and using custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param sendCustomVerificationEmailRequest
     *        Represents a request to send a custom verification email to a specified recipient.
     * @return A Java Future containing the result of the SendCustomVerificationEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>CustomVerificationEmailTemplateDoesNotExistException Indicates that a custom verification email
     *         template with the name you specified does not exist.</li>
     *         <li>FromEmailAddressNotVerifiedException Indicates that the sender address specified for a custom
     *         verification email is not verified, and is therefore not eligible to send the custom verification email.</li>
     *         <li>ProductionAccessNotGrantedException Indicates that the account has not been granted production
     *         access.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendCustomVerificationEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendCustomVerificationEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendCustomVerificationEmailResponse> sendCustomVerificationEmail(
            SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current AWS Region and
     * attempts to verify it. As a result of executing this operation, a customized verification email is sent to the
     * specified address.
     * </p>
     * <p>
     * To use this operation, you must first create a custom verification email template. For more information about
     * creating and using custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendCustomVerificationEmailRequest.Builder}
     * avoiding the need to create one manually via {@link SendCustomVerificationEmailRequest#builder()}
     * </p>
     *
     * @param sendCustomVerificationEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendCustomVerificationEmailRequest.Builder} to create
     *        a request. Represents a request to send a custom verification email to a specified recipient.
     * @return A Java Future containing the result of the SendCustomVerificationEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>CustomVerificationEmailTemplateDoesNotExistException Indicates that a custom verification email
     *         template with the name you specified does not exist.</li>
     *         <li>FromEmailAddressNotVerifiedException Indicates that the sender address specified for a custom
     *         verification email is not verified, and is therefore not eligible to send the custom verification email.</li>
     *         <li>ProductionAccessNotGrantedException Indicates that the account has not been granted production
     *         access.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendCustomVerificationEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendCustomVerificationEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendCustomVerificationEmailResponse> sendCustomVerificationEmail(
            Consumer<SendCustomVerificationEmailRequest.Builder> sendCustomVerificationEmailRequest) {
        return sendCustomVerificationEmail(SendCustomVerificationEmailRequest.builder()
                .applyMutation(sendCustomVerificationEmailRequest).build());
    }

    /**
     * <p>
     * Composes an email message and immediately queues it for sending. In order to send email using the
     * <code>SendEmail</code> operation, your message must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain. If you attempt to send email using a
     * non-verified address or domain, the operation will result in an "Email address not verified" error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must include at least one recipient email address. The recipient address can be a To: address, a CC:
     * address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format
     * <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even if the message
     * contains other recipients that are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an
     * email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call
     * the <code>SendEmail</code> operation several times to send the message to each group.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and
     * BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your <i>sending
     * quota</i>). For more information about sending quotas in Amazon SES, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES
     * Sending Limits</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </important>
     *
     * @param sendEmailRequest
     *        Represents a request to send a single formatted email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>MailFromDomainNotVerifiedException Indicates that the message could not be sent because Amazon SES
     *         could not read the MX record required to use the specified MAIL FROM domain. For information about
     *         editing the custom MAIL FROM domain settings for an identity, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.</li>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>ConfigurationSetSendingPausedException Indicates that email sending is disabled for the configuration
     *         set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.</li>
     *         <li>AccountSendingPausedException Indicates that email sending is disabled for your entire Amazon SES
     *         account.</p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendEmailResponse> sendEmail(SendEmailRequest sendEmailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Composes an email message and immediately queues it for sending. In order to send email using the
     * <code>SendEmail</code> operation, your message must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain. If you attempt to send email using a
     * non-verified address or domain, the operation will result in an "Email address not verified" error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must include at least one recipient email address. The recipient address can be a To: address, a CC:
     * address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format
     * <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even if the message
     * contains other recipients that are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an
     * email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call
     * the <code>SendEmail</code> operation several times to send the message to each group.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and
     * BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your <i>sending
     * quota</i>). For more information about sending quotas in Amazon SES, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES
     * Sending Limits</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendEmailRequest.Builder} avoiding the need to
     * create one manually via {@link SendEmailRequest#builder()}
     * </p>
     *
     * @param sendEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendEmailRequest.Builder} to create a request.
     *        Represents a request to send a single formatted email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>MailFromDomainNotVerifiedException Indicates that the message could not be sent because Amazon SES
     *         could not read the MX record required to use the specified MAIL FROM domain. For information about
     *         editing the custom MAIL FROM domain settings for an identity, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.</li>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>ConfigurationSetSendingPausedException Indicates that email sending is disabled for the configuration
     *         set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.</li>
     *         <li>AccountSendingPausedException Indicates that email sending is disabled for your entire Amazon SES
     *         account.</p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendEmailResponse> sendEmail(Consumer<SendEmailRequest.Builder> sendEmailRequest) {
        return sendEmail(SendEmailRequest.builder().applyMutation(sendEmailRequest).build());
    }

    /**
     * <p>
     * Composes an email message and immediately queues it for sending.
     * </p>
     * <p>
     * This operation is more flexible than the <code>SendEmail</code> API operation. When you use the
     * <code>SendRawEmail</code> operation, you can specify the headers of the message as well as its content. This
     * flexibility is useful, for example, when you want to send a multipart MIME email (such a message that contains
     * both a text and an HTML version). You can also use this operation to send messages that include attachments.
     * </p>
     * <p>
     * The <code>SendRawEmail</code> operation has the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can only send email from <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">verified email
     * addresses or domains</a>. If you try to send email from an address that isn't verified, the operation results in
     * an "Email address not verified" error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/request-production-access.html">Amazon SES
     * sandbox</a>, you can only send email to other verified addresses in your account, or to addresses that are
     * associated with the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mailbox-simulator.html">Amazon
     * SES mailbox simulator</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size, including attachments, is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each message has to include at least one recipient address. A recipient address includes any address on the To:,
     * CC:, or BCC: lines.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you send a single message to more than one recipient address, and one of the recipient addresses isn't in a
     * valid format (that is, it's not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), Amazon SES
     * rejects the entire message, even if the other addresses are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each message can include up to 50 recipient addresses across the To:, CC:, or BCC: lines. If you need to send a
     * single message to more than 50 recipients, you have to split the list of recipient addresses into groups of less
     * than 50 recipients, and send separate messages to each group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for MIME message parts. However, if Amazon SES
     * has to modify the contents of your message (for example, if you use open and click tracking), 8-bit content isn't
     * preserved. For this reason, we highly recommend that you encode all content that isn't 7-bit ASCII. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html#send-email-mime-encoding">MIME
     * Encoding</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Additionally, keep the following considerations in mind when using the <code>SendRawEmail</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Although you can customize the message headers when using the <code>SendRawEmail</code> operation, Amazon SES
     * will automatically apply its own <code>Message-ID</code> and <code>Date</code> headers; if you passed these
     * headers when creating the message, they will be overwritten by the values that Amazon SES provides.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are using sending authorization to send on behalf of another user, <code>SendRawEmail</code> enables you
     * to specify the cross-account identity for the email's Source, From, and Return-Path parameters in one of two
     * ways: you can pass optional parameters <code>SourceArn</code>, <code>FromArn</code>, and/or
     * <code>ReturnPathArn</code> to the API, or you can include the following X-headers in the header of your raw
     * email:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>X-SES-SOURCE-ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>X-SES-FROM-ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>X-SES-RETURN-PATH-ARN</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Don't include these X-headers in the DKIM signature. Amazon SES removes these before it sends the email.
     * </p>
     * </important>
     * <p>
     * If you only specify the <code>SourceIdentityArn</code> parameter, Amazon SES sets the From and Return-Path
     * addresses to the same identity that you specified.
     * </p>
     * <p>
     * For more information about sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Using Sending
     * Authorization with Amazon SES</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and
     * BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your <i>sending
     * quota</i>). For more information about sending quotas in Amazon SES, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES
     * Sending Limits</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param sendRawEmailRequest
     *        Represents a request to send a single raw email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the SendRawEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>MailFromDomainNotVerifiedException Indicates that the message could not be sent because Amazon SES
     *         could not read the MX record required to use the specified MAIL FROM domain. For information about
     *         editing the custom MAIL FROM domain settings for an identity, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.</li>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>ConfigurationSetSendingPausedException Indicates that email sending is disabled for the configuration
     *         set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.</li>
     *         <li>AccountSendingPausedException Indicates that email sending is disabled for your entire Amazon SES
     *         account.</p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendRawEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendRawEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendRawEmailResponse> sendRawEmail(SendRawEmailRequest sendRawEmailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Composes an email message and immediately queues it for sending.
     * </p>
     * <p>
     * This operation is more flexible than the <code>SendEmail</code> API operation. When you use the
     * <code>SendRawEmail</code> operation, you can specify the headers of the message as well as its content. This
     * flexibility is useful, for example, when you want to send a multipart MIME email (such a message that contains
     * both a text and an HTML version). You can also use this operation to send messages that include attachments.
     * </p>
     * <p>
     * The <code>SendRawEmail</code> operation has the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can only send email from <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">verified email
     * addresses or domains</a>. If you try to send email from an address that isn't verified, the operation results in
     * an "Email address not verified" error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/request-production-access.html">Amazon SES
     * sandbox</a>, you can only send email to other verified addresses in your account, or to addresses that are
     * associated with the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mailbox-simulator.html">Amazon
     * SES mailbox simulator</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size, including attachments, is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each message has to include at least one recipient address. A recipient address includes any address on the To:,
     * CC:, or BCC: lines.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you send a single message to more than one recipient address, and one of the recipient addresses isn't in a
     * valid format (that is, it's not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), Amazon SES
     * rejects the entire message, even if the other addresses are valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each message can include up to 50 recipient addresses across the To:, CC:, or BCC: lines. If you need to send a
     * single message to more than 50 recipients, you have to split the list of recipient addresses into groups of less
     * than 50 recipients, and send separate messages to each group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for MIME message parts. However, if Amazon SES
     * has to modify the contents of your message (for example, if you use open and click tracking), 8-bit content isn't
     * preserved. For this reason, we highly recommend that you encode all content that isn't 7-bit ASCII. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html#send-email-mime-encoding">MIME
     * Encoding</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Additionally, keep the following considerations in mind when using the <code>SendRawEmail</code> operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Although you can customize the message headers when using the <code>SendRawEmail</code> operation, Amazon SES
     * will automatically apply its own <code>Message-ID</code> and <code>Date</code> headers; if you passed these
     * headers when creating the message, they will be overwritten by the values that Amazon SES provides.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are using sending authorization to send on behalf of another user, <code>SendRawEmail</code> enables you
     * to specify the cross-account identity for the email's Source, From, and Return-Path parameters in one of two
     * ways: you can pass optional parameters <code>SourceArn</code>, <code>FromArn</code>, and/or
     * <code>ReturnPathArn</code> to the API, or you can include the following X-headers in the header of your raw
     * email:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>X-SES-SOURCE-ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>X-SES-FROM-ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>X-SES-RETURN-PATH-ARN</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Don't include these X-headers in the DKIM signature. Amazon SES removes these before it sends the email.
     * </p>
     * </important>
     * <p>
     * If you only specify the <code>SourceIdentityArn</code> parameter, Amazon SES sets the From and Return-Path
     * addresses to the same identity that you specified.
     * </p>
     * <p>
     * For more information about sending authorization, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Using Sending
     * Authorization with Amazon SES</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * For every message that you send, the total number of recipients (including each recipient in the To:, CC: and
     * BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your <i>sending
     * quota</i>). For more information about sending quotas in Amazon SES, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES
     * Sending Limits</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendRawEmailRequest.Builder} avoiding the need to
     * create one manually via {@link SendRawEmailRequest#builder()}
     * </p>
     *
     * @param sendRawEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendRawEmailRequest.Builder} to create a request.
     *        Represents a request to send a single raw email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the SendRawEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>MailFromDomainNotVerifiedException Indicates that the message could not be sent because Amazon SES
     *         could not read the MX record required to use the specified MAIL FROM domain. For information about
     *         editing the custom MAIL FROM domain settings for an identity, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.</li>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>ConfigurationSetSendingPausedException Indicates that email sending is disabled for the configuration
     *         set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.</li>
     *         <li>AccountSendingPausedException Indicates that email sending is disabled for your entire Amazon SES
     *         account.</p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendRawEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendRawEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendRawEmailResponse> sendRawEmail(Consumer<SendRawEmailRequest.Builder> sendRawEmailRequest) {
        return sendRawEmail(SendRawEmailRequest.builder().applyMutation(sendRawEmailRequest).build());
    }

    /**
     * <p>
     * Composes an email message using an email template and immediately queues it for sending.
     * </p>
     * <p>
     * In order to send email using the <code>SendTemplatedEmail</code> operation, your call to the API must meet the
     * following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The call must refer to an existing email template. You can create email templates using the <a>CreateTemplate</a>
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to the <code>SendTemplatedEmail</code> operation may only include one <code>Destination</code> parameter. A
     * destination is a set of recipients who will receive the same version of the email. The <code>Destination</code>
     * parameter can include up to 50 recipients, across the To:, CC: and BCC: fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>Destination</code> parameter must include at least one recipient email address. The recipient address
     * can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is
     * not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even
     * if the message contains other recipients that are valid.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * If your call to the <code>SendTemplatedEmail</code> operation includes all of the required parameters, Amazon SES
     * accepts it and returns a Message ID. However, if Amazon SES can't render the email because the template contains
     * errors, it doesn't send the email. Additionally, because it already accepted the message, Amazon SES doesn't
     * return a message stating that it was unable to send the email.
     * </p>
     * <p>
     * For these reasons, we highly recommend that you set up Amazon SES to send you notifications when Rendering
     * Failure events occur. For more information, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Sending
     * Personalized Email Using the Amazon SES API</a> in the <i>Amazon Simple Email Service Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param sendTemplatedEmailRequest
     *        Represents a request to send a templated email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendTemplatedEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>MailFromDomainNotVerifiedException Indicates that the message could not be sent because Amazon SES
     *         could not read the MX record required to use the specified MAIL FROM domain. For information about
     *         editing the custom MAIL FROM domain settings for an identity, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.</li>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>TemplateDoesNotExistException Indicates that the Template object you specified does not exist in your
     *         Amazon SES account.</li>
     *         <li>ConfigurationSetSendingPausedException Indicates that email sending is disabled for the configuration
     *         set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.</li>
     *         <li>AccountSendingPausedException Indicates that email sending is disabled for your entire Amazon SES
     *         account.</p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendTemplatedEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendTemplatedEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendTemplatedEmailResponse> sendTemplatedEmail(SendTemplatedEmailRequest sendTemplatedEmailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Composes an email message using an email template and immediately queues it for sending.
     * </p>
     * <p>
     * In order to send email using the <code>SendTemplatedEmail</code> operation, your call to the API must meet the
     * following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The call must refer to an existing email template. You can create email templates using the <a>CreateTemplate</a>
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The message must be sent from a verified email address or domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to
     * email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum message size is 10 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to the <code>SendTemplatedEmail</code> operation may only include one <code>Destination</code> parameter. A
     * destination is a set of recipients who will receive the same version of the email. The <code>Destination</code>
     * parameter can include up to 50 recipients, across the To:, CC: and BCC: fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>Destination</code> parameter must include at least one recipient email address. The recipient address
     * can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is
     * not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even
     * if the message contains other recipients that are valid.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * If your call to the <code>SendTemplatedEmail</code> operation includes all of the required parameters, Amazon SES
     * accepts it and returns a Message ID. However, if Amazon SES can't render the email because the template contains
     * errors, it doesn't send the email. Additionally, because it already accepted the message, Amazon SES doesn't
     * return a message stating that it was unable to send the email.
     * </p>
     * <p>
     * For these reasons, we highly recommend that you set up Amazon SES to send you notifications when Rendering
     * Failure events occur. For more information, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Sending
     * Personalized Email Using the Amazon SES API</a> in the <i>Amazon Simple Email Service Developer Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTemplatedEmailRequest.Builder} avoiding the
     * need to create one manually via {@link SendTemplatedEmailRequest#builder()}
     * </p>
     *
     * @param sendTemplatedEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendTemplatedEmailRequest.Builder} to create a
     *        request. Represents a request to send a templated email using Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SendTemplatedEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MessageRejectedException Indicates that the action failed, and the message could not be sent. Check
     *         the error stack for more information about what caused the error.</li>
     *         <li>MailFromDomainNotVerifiedException Indicates that the message could not be sent because Amazon SES
     *         could not read the MX record required to use the specified MAIL FROM domain. For information about
     *         editing the custom MAIL FROM domain settings for an identity, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
     *         Guide</a>.</li>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>TemplateDoesNotExistException Indicates that the Template object you specified does not exist in your
     *         Amazon SES account.</li>
     *         <li>ConfigurationSetSendingPausedException Indicates that email sending is disabled for the configuration
     *         set.</p>
     *         <p>
     *         You can enable or disable email sending for a configuration set using
     *         <a>UpdateConfigurationSetSendingEnabled</a>.</li>
     *         <li>AccountSendingPausedException Indicates that email sending is disabled for your entire Amazon SES
     *         account.</p>
     *         <p>
     *         You can enable or disable email sending for your Amazon SES account using
     *         <a>UpdateAccountSendingEnabled</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SendTemplatedEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendTemplatedEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendTemplatedEmailResponse> sendTemplatedEmail(
            Consumer<SendTemplatedEmailRequest.Builder> sendTemplatedEmailRequest) {
        return sendTemplatedEmail(SendTemplatedEmailRequest.builder().applyMutation(sendTemplatedEmailRequest).build());
    }

    /**
     * <p>
     * Sets the specified receipt rule set as the active receipt rule set.
     * </p>
     * <note>
     * <p>
     * To disable your email-receiving through Amazon SES completely, you can call this API with RuleSetName set to
     * null.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param setActiveReceiptRuleSetRequest
     *        Represents a request to set a receipt rule set as the active receipt rule set. You use receipt rule sets
     *        to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SetActiveReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetActiveReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetActiveReceiptRuleSetResponse> setActiveReceiptRuleSet(
            SetActiveReceiptRuleSetRequest setActiveReceiptRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the specified receipt rule set as the active receipt rule set.
     * </p>
     * <note>
     * <p>
     * To disable your email-receiving through Amazon SES completely, you can call this API with RuleSetName set to
     * null.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetActiveReceiptRuleSetRequest.Builder} avoiding
     * the need to create one manually via {@link SetActiveReceiptRuleSetRequest#builder()}
     * </p>
     *
     * @param setActiveReceiptRuleSetRequest
     *        A {@link Consumer} that will call methods on {@link SetActiveReceiptRuleSetRequest.Builder} to create a
     *        request. Represents a request to set a receipt rule set as the active receipt rule set. You use receipt
     *        rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SetActiveReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetActiveReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetActiveReceiptRuleSetResponse> setActiveReceiptRuleSet(
            Consumer<SetActiveReceiptRuleSetRequest.Builder> setActiveReceiptRuleSetRequest) {
        return setActiveReceiptRuleSet(SetActiveReceiptRuleSetRequest.builder().applyMutation(setActiveReceiptRuleSetRequest)
                .build());
    }

    /**
     * <p>
     * Sets the specified receipt rule set as the active receipt rule set.
     * </p>
     * <note>
     * <p>
     * To disable your email-receiving through Amazon SES completely, you can call this API with RuleSetName set to
     * null.
     * </p>
     * </note>
     * <p>
     * For information about managing receipt rule sets, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html"
     * >Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @return A Java Future containing the result of the SetActiveReceiptRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetActiveReceiptRuleSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetActiveReceiptRuleSetResponse> setActiveReceiptRuleSet() {
        return setActiveReceiptRuleSet(SetActiveReceiptRuleSetRequest.builder().build());
    }

    /**
     * <p>
     * Enables or disables Easy DKIM signing of email sent from an identity. If Easy DKIM signing is enabled for a
     * domain, then Amazon SES uses DKIM to sign all email that it sends from addresses on that domain. If Easy DKIM
     * signing is enabled for an email address, then Amazon SES uses DKIM to sign all email it sends from that address.
     * </p>
     * <note>
     * <p>
     * For email addresses (for example, <code>user@example.com</code>), you can only enable DKIM signing if the
     * corresponding domain (in this case, <code>example.com</code>) has been set up to use Easy DKIM.
     * </p>
     * </note>
     * <p>
     * You can enable DKIM signing for an identity at any time after you start the verification process for the
     * identity, even if the verification process isn't complete.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about Easy DKIM signing, go to the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
     * </p>
     *
     * @param setIdentityDkimEnabledRequest
     *        Represents a request to enable or disable Amazon SES Easy DKIM signing for an identity. For more
     *        information about setting up Easy DKIM, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the SetIdentityDkimEnabled operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetIdentityDkimEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabled" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetIdentityDkimEnabledResponse> setIdentityDkimEnabled(
            SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables Easy DKIM signing of email sent from an identity. If Easy DKIM signing is enabled for a
     * domain, then Amazon SES uses DKIM to sign all email that it sends from addresses on that domain. If Easy DKIM
     * signing is enabled for an email address, then Amazon SES uses DKIM to sign all email it sends from that address.
     * </p>
     * <note>
     * <p>
     * For email addresses (for example, <code>user@example.com</code>), you can only enable DKIM signing if the
     * corresponding domain (in this case, <code>example.com</code>) has been set up to use Easy DKIM.
     * </p>
     * </note>
     * <p>
     * You can enable DKIM signing for an identity at any time after you start the verification process for the
     * identity, even if the verification process isn't complete.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about Easy DKIM signing, go to the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIdentityDkimEnabledRequest.Builder} avoiding the
     * need to create one manually via {@link SetIdentityDkimEnabledRequest#builder()}
     * </p>
     *
     * @param setIdentityDkimEnabledRequest
     *        A {@link Consumer} that will call methods on {@link SetIdentityDkimEnabledRequest.Builder} to create a
     *        request. Represents a request to enable or disable Amazon SES Easy DKIM signing for an identity. For more
     *        information about setting up Easy DKIM, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the SetIdentityDkimEnabled operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetIdentityDkimEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabled" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetIdentityDkimEnabledResponse> setIdentityDkimEnabled(
            Consumer<SetIdentityDkimEnabledRequest.Builder> setIdentityDkimEnabledRequest) {
        return setIdentityDkimEnabled(SetIdentityDkimEnabledRequest.builder().applyMutation(setIdentityDkimEnabledRequest)
                .build());
    }

    /**
     * <p>
     * Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and
     * complaint notifications as email. Feedback forwarding can only be disabled when Amazon Simple Notification
     * Service (Amazon SNS) topics are specified for both bounces and complaints.
     * </p>
     * <note>
     * <p>
     * Feedback forwarding does not apply to delivery notifications. Delivery notifications are only available through
     * Amazon SNS.
     * </p>
     * </note>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     *
     * @param setIdentityFeedbackForwardingEnabledRequest
     *        Represents a request to enable or disable whether Amazon SES forwards you bounce and complaint
     *        notifications through email. For information about email feedback forwarding, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-email.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SetIdentityFeedbackForwardingEnabled operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetIdentityFeedbackForwardingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityFeedbackForwardingEnabledResponse> setIdentityFeedbackForwardingEnabled(
            SetIdentityFeedbackForwardingEnabledRequest setIdentityFeedbackForwardingEnabledRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and
     * complaint notifications as email. Feedback forwarding can only be disabled when Amazon Simple Notification
     * Service (Amazon SNS) topics are specified for both bounces and complaints.
     * </p>
     * <note>
     * <p>
     * Feedback forwarding does not apply to delivery notifications. Delivery notifications are only available through
     * Amazon SNS.
     * </p>
     * </note>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link SetIdentityFeedbackForwardingEnabledRequest.Builder} avoiding the need to create one manually via
     * {@link SetIdentityFeedbackForwardingEnabledRequest#builder()}
     * </p>
     *
     * @param setIdentityFeedbackForwardingEnabledRequest
     *        A {@link Consumer} that will call methods on {@link SetIdentityFeedbackForwardingEnabledRequest.Builder}
     *        to create a request. Represents a request to enable or disable whether Amazon SES forwards you bounce and
     *        complaint notifications through email. For information about email feedback forwarding, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-email.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SetIdentityFeedbackForwardingEnabled operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetIdentityFeedbackForwardingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityFeedbackForwardingEnabledResponse> setIdentityFeedbackForwardingEnabled(
            Consumer<SetIdentityFeedbackForwardingEnabledRequest.Builder> setIdentityFeedbackForwardingEnabledRequest) {
        return setIdentityFeedbackForwardingEnabled(SetIdentityFeedbackForwardingEnabledRequest.builder()
                .applyMutation(setIdentityFeedbackForwardingEnabledRequest).build());
    }

    /**
     * <p>
     * Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in
     * the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     *
     * @param setIdentityHeadersInNotificationsEnabledRequest
     *        Represents a request to set whether Amazon SES includes the original email headers in the Amazon SNS
     *        notifications of a specified type. For information about notifications, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SetIdentityHeadersInNotificationsEnabled operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetIdentityHeadersInNotificationsEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityHeadersInNotificationsEnabledResponse> setIdentityHeadersInNotificationsEnabled(
            SetIdentityHeadersInNotificationsEnabledRequest setIdentityHeadersInNotificationsEnabledRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in
     * the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about using notifications with Amazon SES, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link SetIdentityHeadersInNotificationsEnabledRequest.Builder} avoiding the need to create one manually via
     * {@link SetIdentityHeadersInNotificationsEnabledRequest#builder()}
     * </p>
     *
     * @param setIdentityHeadersInNotificationsEnabledRequest
     *        A {@link Consumer} that will call methods on
     *        {@link SetIdentityHeadersInNotificationsEnabledRequest.Builder} to create a request. Represents a request
     *        to set whether Amazon SES includes the original email headers in the Amazon SNS notifications of a
     *        specified type. For information about notifications, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SetIdentityHeadersInNotificationsEnabled operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetIdentityHeadersInNotificationsEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityHeadersInNotificationsEnabledResponse> setIdentityHeadersInNotificationsEnabled(
            Consumer<SetIdentityHeadersInNotificationsEnabledRequest.Builder> setIdentityHeadersInNotificationsEnabledRequest) {
        return setIdentityHeadersInNotificationsEnabled(SetIdentityHeadersInNotificationsEnabledRequest.builder()
                .applyMutation(setIdentityHeadersInNotificationsEnabledRequest).build());
    }

    /**
     * <p>
     * Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).
     * </p>
     * <important>
     * <p>
     * To send emails using the specified MAIL FROM domain, you must add an MX record to your MAIL FROM domain's DNS
     * settings. If you want your emails to pass Sender Policy Framework (SPF) checks, you must also add or update an
     * SPF record. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-set.html">Amazon SES Developer Guide</a>.
     * </p>
     * </important>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param setIdentityMailFromDomainRequest
     *        Represents a request to enable or disable the Amazon SES custom MAIL FROM domain setup for a verified
     *        identity. For information about using a custom MAIL FROM domain, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the SetIdentityMailFromDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetIdentityMailFromDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityMailFromDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityMailFromDomainResponse> setIdentityMailFromDomain(
            SetIdentityMailFromDomainRequest setIdentityMailFromDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).
     * </p>
     * <important>
     * <p>
     * To send emails using the specified MAIL FROM domain, you must add an MX record to your MAIL FROM domain's DNS
     * settings. If you want your emails to pass Sender Policy Framework (SPF) checks, you must also add or update an
     * SPF record. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-set.html">Amazon SES Developer Guide</a>.
     * </p>
     * </important>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIdentityMailFromDomainRequest.Builder} avoiding
     * the need to create one manually via {@link SetIdentityMailFromDomainRequest#builder()}
     * </p>
     *
     * @param setIdentityMailFromDomainRequest
     *        A {@link Consumer} that will call methods on {@link SetIdentityMailFromDomainRequest.Builder} to create a
     *        request. Represents a request to enable or disable the Amazon SES custom MAIL FROM domain setup for a
     *        verified identity. For information about using a custom MAIL FROM domain, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the SetIdentityMailFromDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetIdentityMailFromDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityMailFromDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityMailFromDomainResponse> setIdentityMailFromDomain(
            Consumer<SetIdentityMailFromDomainRequest.Builder> setIdentityMailFromDomainRequest) {
        return setIdentityMailFromDomain(SetIdentityMailFromDomainRequest.builder()
                .applyMutation(setIdentityMailFromDomainRequest).build());
    }

    /**
     * <p>
     * Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use
     * this operation, you specify a verified identity, such as an email address or domain. When you send an email that
     * uses the chosen identity in the Source field, Amazon SES sends notifications to the topic you specified. You can
     * send bounce, complaint, or delivery notifications (or any combination of the three) to the Amazon SNS topic that
     * you specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about feedback notification, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     *
     * @param setIdentityNotificationTopicRequest
     *        Represents a request to specify the Amazon SNS topic to which Amazon SES will publish bounce, complaint,
     *        or delivery notifications for emails sent with that identity as the Source. For information about Amazon
     *        SES notifications, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SetIdentityNotificationTopic operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetIdentityNotificationTopic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityNotificationTopic"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityNotificationTopicResponse> setIdentityNotificationTopic(
            SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use
     * this operation, you specify a verified identity, such as an email address or domain. When you send an email that
     * uses the chosen identity in the Source field, Amazon SES sends notifications to the topic you specified. You can
     * send bounce, complaint, or delivery notifications (or any combination of the three) to the Amazon SNS topic that
     * you specify.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <p>
     * For more information about feedback notification, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetIdentityNotificationTopicRequest.Builder}
     * avoiding the need to create one manually via {@link SetIdentityNotificationTopicRequest#builder()}
     * </p>
     *
     * @param setIdentityNotificationTopicRequest
     *        A {@link Consumer} that will call methods on {@link SetIdentityNotificationTopicRequest.Builder} to create
     *        a request. Represents a request to specify the Amazon SNS topic to which Amazon SES will publish bounce,
     *        complaint, or delivery notifications for emails sent with that identity as the Source. For information
     *        about Amazon SES notifications, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SetIdentityNotificationTopic operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetIdentityNotificationTopic
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityNotificationTopic"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetIdentityNotificationTopicResponse> setIdentityNotificationTopic(
            Consumer<SetIdentityNotificationTopicRequest.Builder> setIdentityNotificationTopicRequest) {
        return setIdentityNotificationTopic(SetIdentityNotificationTopicRequest.builder()
                .applyMutation(setIdentityNotificationTopicRequest).build());
    }

    /**
     * <p>
     * Sets the position of the specified receipt rule in the receipt rule set.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param setReceiptRulePositionRequest
     *        Represents a request to set the position of a receipt rule in a receipt rule set. You use receipt rule
     *        sets to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SetReceiptRulePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>RuleDoesNotExistException Indicates that the provided receipt rule does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetReceiptRulePosition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetReceiptRulePosition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetReceiptRulePositionResponse> setReceiptRulePosition(
            SetReceiptRulePositionRequest setReceiptRulePositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the position of the specified receipt rule in the receipt rule set.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetReceiptRulePositionRequest.Builder} avoiding the
     * need to create one manually via {@link SetReceiptRulePositionRequest#builder()}
     * </p>
     *
     * @param setReceiptRulePositionRequest
     *        A {@link Consumer} that will call methods on {@link SetReceiptRulePositionRequest.Builder} to create a
     *        request. Represents a request to set the position of a receipt rule in a receipt rule set. You use receipt
     *        rule sets to receive email with Amazon SES. For more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the SetReceiptRulePosition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>RuleDoesNotExistException Indicates that the provided receipt rule does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.SetReceiptRulePosition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetReceiptRulePosition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetReceiptRulePositionResponse> setReceiptRulePosition(
            Consumer<SetReceiptRulePositionRequest.Builder> setReceiptRulePositionRequest) {
        return setReceiptRulePosition(SetReceiptRulePositionRequest.builder().applyMutation(setReceiptRulePositionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param testRenderTemplateRequest
     * @return A Java Future containing the result of the TestRenderTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TemplateDoesNotExistException Indicates that the Template object you specified does not exist in your
     *         Amazon SES account.</li>
     *         <li>InvalidRenderingParameterException Indicates that one or more of the replacement values you provided
     *         is invalid. This error may occur when the TemplateData object contains invalid JSON.</li>
     *         <li>MissingRenderingAttributeException Indicates that one or more of the replacement values for the
     *         specified template was not specified. Ensure that the TemplateData object contains references to all of
     *         the replacement tags in the specified template.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.TestRenderTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TestRenderTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestRenderTemplateResponse> testRenderTemplate(TestRenderTemplateRequest testRenderTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestRenderTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link TestRenderTemplateRequest#builder()}
     * </p>
     *
     * @param testRenderTemplateRequest
     *        A {@link Consumer} that will call methods on {@link TestRenderTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TestRenderTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TemplateDoesNotExistException Indicates that the Template object you specified does not exist in your
     *         Amazon SES account.</li>
     *         <li>InvalidRenderingParameterException Indicates that one or more of the replacement values you provided
     *         is invalid. This error may occur when the TemplateData object contains invalid JSON.</li>
     *         <li>MissingRenderingAttributeException Indicates that one or more of the replacement values for the
     *         specified template was not specified. Ensure that the TemplateData object contains references to all of
     *         the replacement tags in the specified template.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.TestRenderTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TestRenderTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestRenderTemplateResponse> testRenderTemplate(
            Consumer<TestRenderTemplateRequest.Builder> testRenderTemplateRequest) {
        return testRenderTemplate(TestRenderTemplateRequest.builder().applyMutation(testRenderTemplateRequest).build());
    }

    /**
     * <p>
     * Enables or disables email sending across your entire Amazon SES account in the current AWS Region. You can use
     * this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending across your Amazon
     * SES account in a given AWS Region when reputation metrics (such as your bounce or complaint rates) reach certain
     * thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateAccountSendingEnabledRequest
     *        Represents a request to enable or disable the email sending capabilities for your entire Amazon SES
     *        account.
     * @return A Java Future containing the result of the UpdateAccountSendingEnabled operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateAccountSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateAccountSendingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccountSendingEnabledResponse> updateAccountSendingEnabled(
            UpdateAccountSendingEnabledRequest updateAccountSendingEnabledRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables email sending across your entire Amazon SES account in the current AWS Region. You can use
     * this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending across your Amazon
     * SES account in a given AWS Region when reputation metrics (such as your bounce or complaint rates) reach certain
     * thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountSendingEnabledRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAccountSendingEnabledRequest#builder()}
     * </p>
     *
     * @param updateAccountSendingEnabledRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccountSendingEnabledRequest.Builder} to create
     *        a request. Represents a request to enable or disable the email sending capabilities for your entire Amazon
     *        SES account.
     * @return A Java Future containing the result of the UpdateAccountSendingEnabled operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateAccountSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateAccountSendingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccountSendingEnabledResponse> updateAccountSendingEnabled(
            Consumer<UpdateAccountSendingEnabledRequest.Builder> updateAccountSendingEnabledRequest) {
        return updateAccountSendingEnabled(UpdateAccountSendingEnabledRequest.builder()
                .applyMutation(updateAccountSendingEnabledRequest).build());
    }

    /**
     * <p>
     * Updates the event destination of a configuration set. Event destinations are associated with configuration sets,
     * which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple
     * Notification Service (Amazon SNS). For information about using configuration sets, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon
     * SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <note>
     * <p>
     * When you create or update an event destination, you must provide one, and only one, destination. The destination
     * can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * </note>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        Represents a request to update the event destination of a configuration set. Configuration sets enable you
     *        to publish email sending events. For information about using configuration sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the UpdateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>EventDestinationDoesNotExistException Indicates that the event destination does not exist.</li>
     *         <li>InvalidCloudWatchDestinationException Indicates that the Amazon CloudWatch destination is invalid.
     *         See the error message for details.</li>
     *         <li>InvalidFirehoseDestinationException Indicates that the Amazon Kinesis Firehose destination is
     *         invalid. See the error message for details.</li>
     *         <li>InvalidSnsDestinationException Indicates that the Amazon Simple Notification Service (Amazon SNS)
     *         destination is invalid. See the error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetEventDestinationResponse> updateConfigurationSetEventDestination(
            UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the event destination of a configuration set. Event destinations are associated with configuration sets,
     * which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple
     * Notification Service (Amazon SNS). For information about using configuration sets, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon
     * SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <note>
     * <p>
     * When you create or update an event destination, you must provide one, and only one, destination. The destination
     * can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * </note>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. Represents a request to update the event destination of a configuration set.
     *        Configuration sets enable you to publish email sending events. For information about using configuration
     *        sets, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the UpdateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>EventDestinationDoesNotExistException Indicates that the event destination does not exist.</li>
     *         <li>InvalidCloudWatchDestinationException Indicates that the Amazon CloudWatch destination is invalid.
     *         See the error message for details.</li>
     *         <li>InvalidFirehoseDestinationException Indicates that the Amazon Kinesis Firehose destination is
     *         invalid. See the error message for details.</li>
     *         <li>InvalidSnsDestinationException Indicates that the Amazon Simple Notification Service (Amazon SNS)
     *         destination is invalid. See the error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetEventDestinationResponse> updateConfigurationSetEventDestination(
            Consumer<UpdateConfigurationSetEventDestinationRequest.Builder> updateConfigurationSetEventDestinationRequest) {
        return updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(updateConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a
     * given AWS Region. Reputation metrics include bounce and complaint rates. These metrics are published to Amazon
     * CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint rates exceed certain thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateConfigurationSetReputationMetricsEnabledRequest
     *        Represents a request to modify the reputation metric publishing settings for a configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetReputationMetricsEnabled operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateConfigurationSetReputationMetricsEnabled
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetReputationMetricsEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetReputationMetricsEnabledResponse> updateConfigurationSetReputationMetricsEnabled(
            UpdateConfigurationSetReputationMetricsEnabledRequest updateConfigurationSetReputationMetricsEnabledRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a
     * given AWS Region. Reputation metrics include bounce and complaint rates. These metrics are published to Amazon
     * CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint rates exceed certain thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetReputationMetricsEnabledRequest.Builder} avoiding the need to create one manually
     * via {@link UpdateConfigurationSetReputationMetricsEnabledRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetReputationMetricsEnabledRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateConfigurationSetReputationMetricsEnabledRequest.Builder} to create a request. Represents a
     *        request to modify the reputation metric publishing settings for a configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetReputationMetricsEnabled operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateConfigurationSetReputationMetricsEnabled
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetReputationMetricsEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetReputationMetricsEnabledResponse> updateConfigurationSetReputationMetricsEnabled(
            Consumer<UpdateConfigurationSetReputationMetricsEnabledRequest.Builder> updateConfigurationSetReputationMetricsEnabledRequest) {
        return updateConfigurationSetReputationMetricsEnabled(UpdateConfigurationSetReputationMetricsEnabledRequest.builder()
                .applyMutation(updateConfigurationSetReputationMetricsEnabledRequest).build());
    }

    /**
     * <p>
     * Enables or disables email sending for messages sent using a specific configuration set in a given AWS Region. You
     * can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending for a
     * configuration set when the reputation metrics for that configuration set (such as your bounce on complaint rate)
     * exceed certain thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateConfigurationSetSendingEnabledRequest
     *        Represents a request to enable or disable the email sending capabilities for a specific configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetSendingEnabled operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateConfigurationSetSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetSendingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetSendingEnabledResponse> updateConfigurationSetSendingEnabled(
            UpdateConfigurationSetSendingEnabledRequest updateConfigurationSetSendingEnabledRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables email sending for messages sent using a specific configuration set in a given AWS Region. You
     * can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending for a
     * configuration set when the reputation metrics for that configuration set (such as your bounce on complaint rate)
     * exceed certain thresholds.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetSendingEnabledRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConfigurationSetSendingEnabledRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetSendingEnabledRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationSetSendingEnabledRequest.Builder}
     *        to create a request. Represents a request to enable or disable the email sending capabilities for a
     *        specific configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetSendingEnabled operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateConfigurationSetSendingEnabled
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetSendingEnabled"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetSendingEnabledResponse> updateConfigurationSetSendingEnabled(
            Consumer<UpdateConfigurationSetSendingEnabledRequest.Builder> updateConfigurationSetSendingEnabledRequest) {
        return updateConfigurationSetSendingEnabled(UpdateConfigurationSetSendingEnabledRequest.builder()
                .applyMutation(updateConfigurationSetSendingEnabledRequest).build());
    }

    /**
     * <p>
     * Modifies an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     *
     * @param updateConfigurationSetTrackingOptionsRequest
     *        Represents a request to update the tracking options for a configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetTrackingOptions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>TrackingOptionsDoesNotExistException Indicates that the TrackingOptions object you specified does not
     *         exist.</li>
     *         <li>InvalidTrackingOptionsException Indicates that the custom domain to be used for open and click
     *         tracking redirects is invalid. This error appears most often in the following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not verified in Amazon SES.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not a valid domain or subdomain.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetTrackingOptionsResponse> updateConfigurationSetTrackingOptions(
            UpdateConfigurationSetTrackingOptionsRequest updateConfigurationSetTrackingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an association between a configuration set and a custom domain for open and click event tracking.
     * </p>
     * <p>
     * By default, images and links used for tracking open and click events are hosted on domains operated by Amazon
     * SES. You can configure a subdomain of your own to handle these events. For information about using custom
     * domains, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetTrackingOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConfigurationSetTrackingOptionsRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetTrackingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationSetTrackingOptionsRequest.Builder}
     *        to create a request. Represents a request to update the tracking options for a configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetTrackingOptions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConfigurationSetDoesNotExistException Indicates that the configuration set does not exist.</li>
     *         <li>TrackingOptionsDoesNotExistException Indicates that the TrackingOptions object you specified does not
     *         exist.</li>
     *         <li>InvalidTrackingOptionsException Indicates that the custom domain to be used for open and click
     *         tracking redirects is invalid. This error appears most often in the following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not verified in Amazon SES.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When the tracking domain you specified is not a valid domain or subdomain.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetTrackingOptionsResponse> updateConfigurationSetTrackingOptions(
            Consumer<UpdateConfigurationSetTrackingOptionsRequest.Builder> updateConfigurationSetTrackingOptionsRequest) {
        return updateConfigurationSetTrackingOptions(UpdateConfigurationSetTrackingOptionsRequest.builder()
                .applyMutation(updateConfigurationSetTrackingOptionsRequest).build());
    }

    /**
     * <p>
     * Updates an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateCustomVerificationEmailTemplateRequest
     *        Represents a request to update an existing custom verification email template.
     * @return A Java Future containing the result of the UpdateCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomVerificationEmailTemplateDoesNotExistException Indicates that a custom verification email
     *         template with the name you specified does not exist.</li>
     *         <li>FromEmailAddressNotVerifiedException Indicates that the sender address specified for a custom
     *         verification email is not verified, and is therefore not eligible to send the custom verification email.</li>
     *         <li>CustomVerificationEmailInvalidContentException Indicates that custom verification email template
     *         provided content is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomVerificationEmailTemplateResponse> updateCustomVerificationEmailTemplate(
            UpdateCustomVerificationEmailTemplateRequest updateCustomVerificationEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing custom verification email template.
     * </p>
     * <p>
     * For more information about custom verification email templates, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
     * Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateCustomVerificationEmailTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateCustomVerificationEmailTemplateRequest#builder()}
     * </p>
     *
     * @param updateCustomVerificationEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCustomVerificationEmailTemplateRequest.Builder}
     *        to create a request. Represents a request to update an existing custom verification email template.
     * @return A Java Future containing the result of the UpdateCustomVerificationEmailTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomVerificationEmailTemplateDoesNotExistException Indicates that a custom verification email
     *         template with the name you specified does not exist.</li>
     *         <li>FromEmailAddressNotVerifiedException Indicates that the sender address specified for a custom
     *         verification email is not verified, and is therefore not eligible to send the custom verification email.</li>
     *         <li>CustomVerificationEmailInvalidContentException Indicates that custom verification email template
     *         provided content is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateCustomVerificationEmailTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateCustomVerificationEmailTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomVerificationEmailTemplateResponse> updateCustomVerificationEmailTemplate(
            Consumer<UpdateCustomVerificationEmailTemplateRequest.Builder> updateCustomVerificationEmailTemplateRequest) {
        return updateCustomVerificationEmailTemplate(UpdateCustomVerificationEmailTemplateRequest.builder()
                .applyMutation(updateCustomVerificationEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Updates a receipt rule.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateReceiptRuleRequest
     *        Represents a request to update a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the UpdateReceiptRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSnsTopicException Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES
     *         could not publish to the topic, possibly due to permissions issues. For information about giving
     *         permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>InvalidS3ConfigurationException Indicates that the provided Amazon S3 bucket or AWS KMS encryption
     *         key is invalid, or that Amazon SES could not publish to the bucket, possibly due to permissions issues.
     *         For information about giving permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>InvalidLambdaFunctionException Indicates that the provided AWS Lambda function is invalid, or that
     *         Amazon SES could not execute the provided function, possibly due to permissions issues. For information
     *         about giving permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>RuleDoesNotExistException Indicates that the provided receipt rule does not exist.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateReceiptRuleResponse> updateReceiptRule(UpdateReceiptRuleRequest updateReceiptRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a receipt rule.
     * </p>
     * <p>
     * For information about managing receipt rules, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon
     * SES Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReceiptRuleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateReceiptRuleRequest#builder()}
     * </p>
     *
     * @param updateReceiptRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReceiptRuleRequest.Builder} to create a request.
     *        Represents a request to update a receipt rule. You use receipt rules to receive email with Amazon SES. For
     *        more information, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the UpdateReceiptRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSnsTopicException Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES
     *         could not publish to the topic, possibly due to permissions issues. For information about giving
     *         permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>InvalidS3ConfigurationException Indicates that the provided Amazon S3 bucket or AWS KMS encryption
     *         key is invalid, or that Amazon SES could not publish to the bucket, possibly due to permissions issues.
     *         For information about giving permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>InvalidLambdaFunctionException Indicates that the provided AWS Lambda function is invalid, or that
     *         Amazon SES could not execute the provided function, possibly due to permissions issues. For information
     *         about giving permissions, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
     *         Developer Guide</a>.</li>
     *         <li>RuleSetDoesNotExistException Indicates that the provided receipt rule set does not exist.</li>
     *         <li>RuleDoesNotExistException Indicates that the provided receipt rule does not exist.</li>
     *         <li>LimitExceededException Indicates that a resource could not be created because of service limits. For
     *         a list of Amazon SES limits, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer Guide</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateReceiptRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateReceiptRuleResponse> updateReceiptRule(
            Consumer<UpdateReceiptRuleRequest.Builder> updateReceiptRuleRequest) {
        return updateReceiptRule(UpdateReceiptRuleRequest.builder().applyMutation(updateReceiptRuleRequest).build());
    }

    /**
     * <p>
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param updateTemplateRequest
     * @return A Java Future containing the result of the UpdateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TemplateDoesNotExistException Indicates that the Template object you specified does not exist in your
     *         Amazon SES account.</li>
     *         <li>InvalidTemplateException Indicates that the template that you specified could not be rendered. This
     *         issue may occur when a template refers to a partial that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTemplateResponse> updateTemplate(UpdateTemplateRequest updateTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a
     * single API operation. For more information, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTemplateRequest#builder()}
     * </p>
     *
     * @param updateTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TemplateDoesNotExistException Indicates that the Template object you specified does not exist in your
     *         Amazon SES account.</li>
     *         <li>InvalidTemplateException Indicates that the template that you specified could not be rendered. This
     *         issue may occur when a template refers to a partial that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.UpdateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTemplateResponse> updateTemplate(Consumer<UpdateTemplateRequest.Builder> updateTemplateRequest) {
        return updateTemplate(UpdateTemplateRequest.builder().applyMutation(updateTemplateRequest).build());
    }

    /**
     * <p>
     * Returns a set of DKIM tokens for a domain identity.
     * </p>
     * <important>
     * <p>
     * When you execute the <code>VerifyDomainDkim</code> operation, the domain that you specify is added to the list of
     * identities that are associated with your account. This is true even if you haven't already associated the domain
     * with your account by using the <code>VerifyDomainIdentity</code> operation. However, you can't send email from
     * the domain until you either successfully <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">verify it</a> or you
     * successfully <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">set up DKIM for
     * it</a>.
     * </p>
     * </important>
     * <p>
     * You use the tokens that are generated by this operation to create CNAME records. When Amazon SES detects that
     * you've added these records to the DNS configuration for a domain, you can start sending email from that domain.
     * You can start sending email even if you haven't added the TXT record provided by the VerifyDomainIdentity
     * operation to the DNS configuration for your domain. All email that you send from the domain is authenticated
     * using DKIM.
     * </p>
     * <p>
     * To create the CNAME records for DKIM authentication, use the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Name</b>: <i>token</i>._domainkey.<i>example.com</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Type</b>: CNAME
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Value</b>: <i>token</i>.dkim.amazonses.com
     * </p>
     * </li>
     * </ul>
     * <p>
     * In the preceding example, replace <i>token</i> with one of the tokens that are generated when you execute this
     * operation. Replace <i>example.com</i> with your domain. Repeat this process for each token that's generated by
     * this operation.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param verifyDomainDkimRequest
     *        Represents a request to generate the CNAME records needed to set up Easy DKIM with Amazon SES. For more
     *        information about setting up Easy DKIM, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the VerifyDomainDkim operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.VerifyDomainDkim
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkim" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<VerifyDomainDkimResponse> verifyDomainDkim(VerifyDomainDkimRequest verifyDomainDkimRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a set of DKIM tokens for a domain identity.
     * </p>
     * <important>
     * <p>
     * When you execute the <code>VerifyDomainDkim</code> operation, the domain that you specify is added to the list of
     * identities that are associated with your account. This is true even if you haven't already associated the domain
     * with your account by using the <code>VerifyDomainIdentity</code> operation. However, you can't send email from
     * the domain until you either successfully <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">verify it</a> or you
     * successfully <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">set up DKIM for
     * it</a>.
     * </p>
     * </important>
     * <p>
     * You use the tokens that are generated by this operation to create CNAME records. When Amazon SES detects that
     * you've added these records to the DNS configuration for a domain, you can start sending email from that domain.
     * You can start sending email even if you haven't added the TXT record provided by the VerifyDomainIdentity
     * operation to the DNS configuration for your domain. All email that you send from the domain is authenticated
     * using DKIM.
     * </p>
     * <p>
     * To create the CNAME records for DKIM authentication, use the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Name</b>: <i>token</i>._domainkey.<i>example.com</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Type</b>: CNAME
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Value</b>: <i>token</i>.dkim.amazonses.com
     * </p>
     * </li>
     * </ul>
     * <p>
     * In the preceding example, replace <i>token</i> with one of the tokens that are generated when you execute this
     * operation. Replace <i>example.com</i> with your domain. Repeat this process for each token that's generated by
     * this operation.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyDomainDkimRequest.Builder} avoiding the need
     * to create one manually via {@link VerifyDomainDkimRequest#builder()}
     * </p>
     *
     * @param verifyDomainDkimRequest
     *        A {@link Consumer} that will call methods on {@link VerifyDomainDkimRequest.Builder} to create a request.
     *        Represents a request to generate the CNAME records needed to set up Easy DKIM with Amazon SES. For more
     *        information about setting up Easy DKIM, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the VerifyDomainDkim operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.VerifyDomainDkim
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkim" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<VerifyDomainDkimResponse> verifyDomainDkim(
            Consumer<VerifyDomainDkimRequest.Builder> verifyDomainDkimRequest) {
        return verifyDomainDkim(VerifyDomainDkimRequest.builder().applyMutation(verifyDomainDkimRequest).build());
    }

    /**
     * <p>
     * Adds a domain to the list of identities for your Amazon SES account in the current AWS Region and attempts to
     * verify it. For more information about verifying domains, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param verifyDomainIdentityRequest
     *        Represents a request to begin Amazon SES domain verification and to generate the TXT records that you must
     *        publish to the DNS server of your domain to complete the verification. For information about domain
     *        verification, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the VerifyDomainIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.VerifyDomainIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<VerifyDomainIdentityResponse> verifyDomainIdentity(
            VerifyDomainIdentityRequest verifyDomainIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a domain to the list of identities for your Amazon SES account in the current AWS Region and attempts to
     * verify it. For more information about verifying domains, see <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
     * Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i>
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyDomainIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link VerifyDomainIdentityRequest#builder()}
     * </p>
     *
     * @param verifyDomainIdentityRequest
     *        A {@link Consumer} that will call methods on {@link VerifyDomainIdentityRequest.Builder} to create a
     *        request. Represents a request to begin Amazon SES domain verification and to generate the TXT records that
     *        you must publish to the DNS server of your domain to complete the verification. For information about
     *        domain verification, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">Amazon SES Developer
     *        Guide</a>.
     * @return A Java Future containing the result of the VerifyDomainIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.VerifyDomainIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<VerifyDomainIdentityResponse> verifyDomainIdentity(
            Consumer<VerifyDomainIdentityRequest.Builder> verifyDomainIdentityRequest) {
        return verifyDomainIdentity(VerifyDomainIdentityRequest.builder().applyMutation(verifyDomainIdentityRequest).build());
    }

    /**
     * <p>
     * Deprecated. Use the <code>VerifyEmailIdentity</code> operation to verify a new email address.
     * </p>
     *
     * @param verifyEmailAddressRequest
     *        Represents a request to begin email address verification with Amazon SES. For information about email
     *        address verification, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the VerifyEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.VerifyEmailAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<VerifyEmailAddressResponse> verifyEmailAddress(VerifyEmailAddressRequest verifyEmailAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecated. Use the <code>VerifyEmailIdentity</code> operation to verify a new email address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyEmailAddressRequest.Builder} avoiding the
     * need to create one manually via {@link VerifyEmailAddressRequest#builder()}
     * </p>
     *
     * @param verifyEmailAddressRequest
     *        A {@link Consumer} that will call methods on {@link VerifyEmailAddressRequest.Builder} to create a
     *        request. Represents a request to begin email address verification with Amazon SES. For information about
     *        email address verification, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the VerifyEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.VerifyEmailAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<VerifyEmailAddressResponse> verifyEmailAddress(
            Consumer<VerifyEmailAddressRequest.Builder> verifyEmailAddressRequest) {
        return verifyEmailAddress(VerifyEmailAddressRequest.builder().applyMutation(verifyEmailAddressRequest).build());
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current AWS region and
     * attempts to verify it. As a result of executing this operation, a verification email is sent to the specified
     * address.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     *
     * @param verifyEmailIdentityRequest
     *        Represents a request to begin email address verification with Amazon SES. For information about email
     *        address verification, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the VerifyEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.VerifyEmailIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<VerifyEmailIdentityResponse> verifyEmailIdentity(
            VerifyEmailIdentityRequest verifyEmailIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an email address to the list of identities for your Amazon SES account in the current AWS region and
     * attempts to verify it. As a result of executing this operation, a verification email is sent to the specified
     * address.
     * </p>
     * <p>
     * You can execute this operation no more than once per second.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyEmailIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link VerifyEmailIdentityRequest#builder()}
     * </p>
     *
     * @param verifyEmailIdentityRequest
     *        A {@link Consumer} that will call methods on {@link VerifyEmailIdentityRequest.Builder} to create a
     *        request. Represents a request to begin email address verification with Amazon SES. For information about
     *        email address verification, see the <a
     *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES
     *        Developer Guide</a>.
     * @return A Java Future containing the result of the VerifyEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SesAsyncClient.VerifyEmailIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<VerifyEmailIdentityResponse> verifyEmailIdentity(
            Consumer<VerifyEmailIdentityRequest.Builder> verifyEmailIdentityRequest) {
        return verifyEmailIdentity(VerifyEmailIdentityRequest.builder().applyMutation(verifyEmailIdentityRequest).build());
    }

    /**
     * Create an instance of {@link SesAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link SesAsyncWaiter}
     */
    default SesAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
