/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BounceAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BounceAction> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(BounceAction.getter(BounceAction::topicArn)).setter(BounceAction.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<String> SMTP_REPLY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmtpReplyCode").getter(BounceAction.getter(BounceAction::smtpReplyCode)).setter(BounceAction.setter(Builder::smtpReplyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmtpReplyCode").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(BounceAction.getter(BounceAction::statusCode)).setter(BounceAction.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(BounceAction.getter(BounceAction::message)).setter(BounceAction.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> SENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sender").getter(BounceAction.getter(BounceAction::sender)).setter(BounceAction.setter(Builder::sender)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, SMTP_REPLY_CODE_FIELD, STATUS_CODE_FIELD, MESSAGE_FIELD, SENDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String topicArn;
    private final String smtpReplyCode;
    private final String statusCode;
    private final String message;
    private final String sender;

    private BounceAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.smtpReplyCode = builder.smtpReplyCode;
        this.statusCode = builder.statusCode;
        this.message = builder.message;
        this.sender = builder.sender;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final String smtpReplyCode() {
        return this.smtpReplyCode;
    }

    public final String statusCode() {
        return this.statusCode;
    }

    public final String message() {
        return this.message;
    }

    public final String sender() {
        return this.sender;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.smtpReplyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.sender());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BounceAction)) {
            return false;
        }
        BounceAction other = (BounceAction)obj;
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.smtpReplyCode(), other.smtpReplyCode()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.sender(), other.sender());
    }

    public final String toString() {
        return ToString.builder((String)"BounceAction").add("TopicArn", (Object)this.topicArn()).add("SmtpReplyCode", (Object)this.smtpReplyCode()).add("StatusCode", (Object)this.statusCode()).add("Message", (Object)this.message()).add("Sender", (Object)this.sender()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "SmtpReplyCode": {
                return Optional.ofNullable(clazz.cast(this.smtpReplyCode()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Sender": {
                return Optional.ofNullable(clazz.cast(this.sender()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BounceAction, T> g) {
        return obj -> g.apply((BounceAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String smtpReplyCode;
        private String statusCode;
        private String message;
        private String sender;

        private BuilderImpl() {
        }

        private BuilderImpl(BounceAction model) {
            this.topicArn(model.topicArn);
            this.smtpReplyCode(model.smtpReplyCode);
            this.statusCode(model.statusCode);
            this.message(model.message);
            this.sender(model.sender);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getSmtpReplyCode() {
            return this.smtpReplyCode;
        }

        @Override
        public final Builder smtpReplyCode(String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
            return this;
        }

        public final void setSmtpReplyCode(String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSender() {
            return this.sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        public BounceAction build() {
            return new BounceAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BounceAction> {
        public Builder topicArn(String var1);

        public Builder smtpReplyCode(String var1);

        public Builder statusCode(String var1);

        public Builder message(String var1);

        public Builder sender(String var1);
    }
}

