/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Template
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Template> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(Template.getter(Template::templateName)).setter(Template.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> SUBJECT_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubjectPart").getter(Template.getter(Template::subjectPart)).setter(Template.setter(Builder::subjectPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectPart").build()}).build();
    private static final SdkField<String> TEXT_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextPart").getter(Template.getter(Template::textPart)).setter(Template.setter(Builder::textPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextPart").build()}).build();
    private static final SdkField<String> HTML_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HtmlPart").getter(Template.getter(Template::htmlPart)).setter(Template.setter(Builder::htmlPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlPart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, SUBJECT_PART_FIELD, TEXT_PART_FIELD, HTML_PART_FIELD));
    private static final long serialVersionUID = 1L;
    private final String templateName;
    private final String subjectPart;
    private final String textPart;
    private final String htmlPart;

    private Template(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.subjectPart = builder.subjectPart;
        this.textPart = builder.textPart;
        this.htmlPart = builder.htmlPart;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String subjectPart() {
        return this.subjectPart;
    }

    public final String textPart() {
        return this.textPart;
    }

    public final String htmlPart() {
        return this.htmlPart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectPart());
        hashCode = 31 * hashCode + Objects.hashCode(this.textPart());
        hashCode = 31 * hashCode + Objects.hashCode(this.htmlPart());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template)obj;
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.subjectPart(), other.subjectPart()) && Objects.equals(this.textPart(), other.textPart()) && Objects.equals(this.htmlPart(), other.htmlPart());
    }

    public final String toString() {
        return ToString.builder((String)"Template").add("TemplateName", (Object)this.templateName()).add("SubjectPart", (Object)this.subjectPart()).add("TextPart", (Object)this.textPart()).add("HtmlPart", (Object)this.htmlPart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "SubjectPart": {
                return Optional.ofNullable(clazz.cast(this.subjectPart()));
            }
            case "TextPart": {
                return Optional.ofNullable(clazz.cast(this.textPart()));
            }
            case "HtmlPart": {
                return Optional.ofNullable(clazz.cast(this.htmlPart()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Template, T> g) {
        return obj -> g.apply((Template)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateName;
        private String subjectPart;
        private String textPart;
        private String htmlPart;

        private BuilderImpl() {
        }

        private BuilderImpl(Template model) {
            this.templateName(model.templateName);
            this.subjectPart(model.subjectPart);
            this.textPart(model.textPart);
            this.htmlPart(model.htmlPart);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getSubjectPart() {
            return this.subjectPart;
        }

        @Override
        public final Builder subjectPart(String subjectPart) {
            this.subjectPart = subjectPart;
            return this;
        }

        public final void setSubjectPart(String subjectPart) {
            this.subjectPart = subjectPart;
        }

        public final String getTextPart() {
            return this.textPart;
        }

        @Override
        public final Builder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        public final void setTextPart(String textPart) {
            this.textPart = textPart;
        }

        public final String getHtmlPart() {
            return this.htmlPart;
        }

        @Override
        public final Builder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final void setHtmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
        }

        public Template build() {
            return new Template(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Template> {
        public Builder templateName(String var1);

        public Builder subjectPart(String var1);

        public Builder textPart(String var1);

        public Builder htmlPart(String var1);
    }
}

