/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.MessageTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BulkEmailDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BulkEmailDestination> {
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(BulkEmailDestination.getter(BulkEmailDestination::destination)).setter(BulkEmailDestination.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<List<MessageTag>> REPLACEMENT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplacementTags").getter(BulkEmailDestination.getter(BulkEmailDestination::replacementTags)).setter(BulkEmailDestination.setter(Builder::replacementTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLACEMENT_TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplacementTemplateData").getter(BulkEmailDestination.getter(BulkEmailDestination::replacementTemplateData)).setter(BulkEmailDestination.setter(Builder::replacementTemplateData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementTemplateData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, REPLACEMENT_TAGS_FIELD, REPLACEMENT_TEMPLATE_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final Destination destination;
    private final List<MessageTag> replacementTags;
    private final String replacementTemplateData;

    private BulkEmailDestination(BuilderImpl builder) {
        this.destination = builder.destination;
        this.replacementTags = builder.replacementTags;
        this.replacementTemplateData = builder.replacementTemplateData;
    }

    public final Destination destination() {
        return this.destination;
    }

    public final boolean hasReplacementTags() {
        return this.replacementTags != null && !(this.replacementTags instanceof SdkAutoConstructList);
    }

    public final List<MessageTag> replacementTags() {
        return this.replacementTags;
    }

    public final String replacementTemplateData() {
        return this.replacementTemplateData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplacementTags() ? this.replacementTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementTemplateData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailDestination)) {
            return false;
        }
        BulkEmailDestination other = (BulkEmailDestination)obj;
        return Objects.equals(this.destination(), other.destination()) && this.hasReplacementTags() == other.hasReplacementTags() && Objects.equals(this.replacementTags(), other.replacementTags()) && Objects.equals(this.replacementTemplateData(), other.replacementTemplateData());
    }

    public final String toString() {
        return ToString.builder((String)"BulkEmailDestination").add("Destination", (Object)this.destination()).add("ReplacementTags", this.hasReplacementTags() ? this.replacementTags() : null).add("ReplacementTemplateData", (Object)this.replacementTemplateData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "ReplacementTags": {
                return Optional.ofNullable(clazz.cast(this.replacementTags()));
            }
            case "ReplacementTemplateData": {
                return Optional.ofNullable(clazz.cast(this.replacementTemplateData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkEmailDestination, T> g) {
        return obj -> g.apply((BulkEmailDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Destination destination;
        private List<MessageTag> replacementTags = DefaultSdkAutoConstructList.getInstance();
        private String replacementTemplateData;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkEmailDestination model) {
            this.destination(model.destination);
            this.replacementTags(model.replacementTags);
            this.replacementTemplateData(model.replacementTemplateData);
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Collection<MessageTag.Builder> getReplacementTags() {
            if (this.replacementTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replacementTags != null ? (Collection)this.replacementTags.stream().map(MessageTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replacementTags(Collection<MessageTag> replacementTags) {
            this.replacementTags = MessageTagListCopier.copy(replacementTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementTags(MessageTag ... replacementTags) {
            this.replacementTags(Arrays.asList(replacementTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementTags(Consumer<MessageTag.Builder> ... replacementTags) {
            this.replacementTags(Stream.of(replacementTags).map(c -> (MessageTag)((MessageTag.Builder)MessageTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplacementTags(Collection<MessageTag.BuilderImpl> replacementTags) {
            this.replacementTags = MessageTagListCopier.copyFromBuilder(replacementTags);
        }

        public final String getReplacementTemplateData() {
            return this.replacementTemplateData;
        }

        @Override
        public final Builder replacementTemplateData(String replacementTemplateData) {
            this.replacementTemplateData = replacementTemplateData;
            return this;
        }

        public final void setReplacementTemplateData(String replacementTemplateData) {
            this.replacementTemplateData = replacementTemplateData;
        }

        public BulkEmailDestination build() {
            return new BulkEmailDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BulkEmailDestination> {
        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }

        public Builder replacementTags(Collection<MessageTag> var1);

        public Builder replacementTags(MessageTag ... var1);

        public Builder replacementTags(Consumer<MessageTag.Builder> ... var1);

        public Builder replacementTemplateData(String var1);
    }
}

