/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.MessageTagListCopier;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendTemplatedEmailRequest
extends SesRequest
implements ToCopyableBuilder<Builder, SendTemplatedEmailRequest> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::source)).setter(SendTemplatedEmailRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::destination)).setter(SendTemplatedEmailRequest.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<List<String>> REPLY_TO_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplyToAddresses").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::replyToAddresses)).setter(SendTemplatedEmailRequest.setter(Builder::replyToAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnPath").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::returnPath)).setter(SendTemplatedEmailRequest.setter(Builder::returnPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnPath").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::sourceArn)).setter(SendTemplatedEmailRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> RETURN_PATH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnPathArn").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::returnPathArn)).setter(SendTemplatedEmailRequest.setter(Builder::returnPathArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnPathArn").build()}).build();
    private static final SdkField<List<MessageTag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::tags)).setter(SendTemplatedEmailRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::configurationSetName)).setter(SendTemplatedEmailRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Template").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::template)).setter(SendTemplatedEmailRequest.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Template").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::templateArn)).setter(SendTemplatedEmailRequest.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()}).build();
    private static final SdkField<String> TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateData").getter(SendTemplatedEmailRequest.getter(SendTemplatedEmailRequest::templateData)).setter(SendTemplatedEmailRequest.setter(Builder::templateData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, DESTINATION_FIELD, REPLY_TO_ADDRESSES_FIELD, RETURN_PATH_FIELD, SOURCE_ARN_FIELD, RETURN_PATH_ARN_FIELD, TAGS_FIELD, CONFIGURATION_SET_NAME_FIELD, TEMPLATE_FIELD, TEMPLATE_ARN_FIELD, TEMPLATE_DATA_FIELD));
    private final String source;
    private final Destination destination;
    private final List<String> replyToAddresses;
    private final String returnPath;
    private final String sourceArn;
    private final String returnPathArn;
    private final List<MessageTag> tags;
    private final String configurationSetName;
    private final String template;
    private final String templateArn;
    private final String templateData;

    private SendTemplatedEmailRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.destination = builder.destination;
        this.replyToAddresses = builder.replyToAddresses;
        this.returnPath = builder.returnPath;
        this.sourceArn = builder.sourceArn;
        this.returnPathArn = builder.returnPathArn;
        this.tags = builder.tags;
        this.configurationSetName = builder.configurationSetName;
        this.template = builder.template;
        this.templateArn = builder.templateArn;
        this.templateData = builder.templateData;
    }

    public String source() {
        return this.source;
    }

    public Destination destination() {
        return this.destination;
    }

    public boolean hasReplyToAddresses() {
        return this.replyToAddresses != null && !(this.replyToAddresses instanceof SdkAutoConstructList);
    }

    public List<String> replyToAddresses() {
        return this.replyToAddresses;
    }

    public String returnPath() {
        return this.returnPath;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String returnPathArn() {
        return this.returnPathArn;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<MessageTag> tags() {
        return this.tags;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public String template() {
        return this.template;
    }

    public String templateArn() {
        return this.templateArn;
    }

    public String templateData() {
        return this.templateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplyToAddresses() ? this.replyToAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnPathArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendTemplatedEmailRequest)) {
            return false;
        }
        SendTemplatedEmailRequest other = (SendTemplatedEmailRequest)((Object)obj);
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && this.hasReplyToAddresses() == other.hasReplyToAddresses() && Objects.equals(this.replyToAddresses(), other.replyToAddresses()) && Objects.equals(this.returnPath(), other.returnPath()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.returnPathArn(), other.returnPathArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.template(), other.template()) && Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.templateData(), other.templateData());
    }

    public String toString() {
        return ToString.builder((String)"SendTemplatedEmailRequest").add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("ReplyToAddresses", this.hasReplyToAddresses() ? this.replyToAddresses() : null).add("ReturnPath", (Object)this.returnPath()).add("SourceArn", (Object)this.sourceArn()).add("ReturnPathArn", (Object)this.returnPathArn()).add("Tags", this.hasTags() ? this.tags() : null).add("ConfigurationSetName", (Object)this.configurationSetName()).add("Template", (Object)this.template()).add("TemplateArn", (Object)this.templateArn()).add("TemplateData", (Object)this.templateData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "ReplyToAddresses": {
                return Optional.ofNullable(clazz.cast(this.replyToAddresses()));
            }
            case "ReturnPath": {
                return Optional.ofNullable(clazz.cast(this.returnPath()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "ReturnPathArn": {
                return Optional.ofNullable(clazz.cast(this.returnPathArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "Template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "TemplateData": {
                return Optional.ofNullable(clazz.cast(this.templateData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendTemplatedEmailRequest, T> g) {
        return obj -> g.apply((SendTemplatedEmailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String source;
        private Destination destination;
        private List<String> replyToAddresses = DefaultSdkAutoConstructList.getInstance();
        private String returnPath;
        private String sourceArn;
        private String returnPathArn;
        private List<MessageTag> tags = DefaultSdkAutoConstructList.getInstance();
        private String configurationSetName;
        private String template;
        private String templateArn;
        private String templateData;

        private BuilderImpl() {
        }

        private BuilderImpl(SendTemplatedEmailRequest model) {
            super(model);
            this.source(model.source);
            this.destination(model.destination);
            this.replyToAddresses(model.replyToAddresses);
            this.returnPath(model.returnPath);
            this.sourceArn(model.sourceArn);
            this.returnPathArn(model.returnPathArn);
            this.tags(model.tags);
            this.configurationSetName(model.configurationSetName);
            this.template(model.template);
            this.templateArn(model.templateArn);
            this.templateData(model.templateData);
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Collection<String> getReplyToAddresses() {
            if (this.replyToAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replyToAddresses;
        }

        @Override
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = AddressListCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replyToAddresses(String ... replyToAddresses) {
            this.replyToAddresses(Arrays.asList(replyToAddresses));
            return this;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = AddressListCopier.copy(replyToAddresses);
        }

        public final String getReturnPath() {
            return this.returnPath;
        }

        @Override
        public final Builder returnPath(String returnPath) {
            this.returnPath = returnPath;
            return this;
        }

        public final void setReturnPath(String returnPath) {
            this.returnPath = returnPath;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getReturnPathArn() {
            return this.returnPathArn;
        }

        @Override
        public final Builder returnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
            return this;
        }

        public final void setReturnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
        }

        public final Collection<MessageTag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(MessageTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<MessageTag> tags) {
            this.tags = MessageTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(MessageTag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<MessageTag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (MessageTag)((MessageTag.Builder)MessageTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<MessageTag.BuilderImpl> tags) {
            this.tags = MessageTagListCopier.copyFromBuilder(tags);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final String getTemplate() {
            return this.template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        public final String getTemplateData() {
            return this.templateData;
        }

        @Override
        public final Builder templateData(String templateData) {
            this.templateData = templateData;
            return this;
        }

        public final void setTemplateData(String templateData) {
            this.templateData = templateData;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendTemplatedEmailRequest build() {
            return new SendTemplatedEmailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendTemplatedEmailRequest> {
        public Builder source(String var1);

        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }

        public Builder replyToAddresses(Collection<String> var1);

        public Builder replyToAddresses(String ... var1);

        public Builder returnPath(String var1);

        public Builder sourceArn(String var1);

        public Builder returnPathArn(String var1);

        public Builder tags(Collection<MessageTag> var1);

        public Builder tags(MessageTag ... var1);

        public Builder tags(Consumer<MessageTag.Builder> ... var1);

        public Builder configurationSetName(String var1);

        public Builder template(String var1);

        public Builder templateArn(String var1);

        public Builder templateData(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

