/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action adds a header to the received email.
 * </p>
 * <p>
 * For information about adding a header using a receipt rule, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-add-header.html">Amazon SES
 * Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddHeaderAction implements SdkPojo, Serializable, ToCopyableBuilder<AddHeaderAction.Builder, AddHeaderAction> {
    private static final SdkField<String> HEADER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddHeaderAction::headerName)).setter(setter(Builder::headerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderName").build()).build();

    private static final SdkField<String> HEADER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddHeaderAction::headerValue)).setter(setter(Builder::headerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_NAME_FIELD,
            HEADER_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String headerName;

    private final String headerValue;

    private AddHeaderAction(BuilderImpl builder) {
        this.headerName = builder.headerName;
        this.headerValue = builder.headerValue;
    }

    /**
     * <p>
     * The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z,
     * A-Z, 0-9) characters and dashes only.
     * </p>
     * 
     * @return The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of
     *         alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
     */
    public String headerName() {
        return headerName;
    }

    /**
     * <p>
     * Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
     * </p>
     * 
     * @return Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
     */
    public String headerValue() {
        return headerValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(headerName());
        hashCode = 31 * hashCode + Objects.hashCode(headerValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddHeaderAction)) {
            return false;
        }
        AddHeaderAction other = (AddHeaderAction) obj;
        return Objects.equals(headerName(), other.headerName()) && Objects.equals(headerValue(), other.headerValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddHeaderAction").add("HeaderName", headerName()).add("HeaderValue", headerValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeaderName":
            return Optional.ofNullable(clazz.cast(headerName()));
        case "HeaderValue":
            return Optional.ofNullable(clazz.cast(headerValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddHeaderAction, T> g) {
        return obj -> g.apply((AddHeaderAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddHeaderAction> {
        /**
         * <p>
         * The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric
         * (a-z, A-Z, 0-9) characters and dashes only.
         * </p>
         * 
         * @param headerName
         *        The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of
         *        alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerName(String headerName);

        /**
         * <p>
         * Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
         * </p>
         * 
         * @param headerValue
         *        Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerValue(String headerValue);
    }

    static final class BuilderImpl implements Builder {
        private String headerName;

        private String headerValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AddHeaderAction model) {
            headerName(model.headerName);
            headerValue(model.headerValue);
        }

        public final String getHeaderName() {
            return headerName;
        }

        @Override
        public final Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public final void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        public final String getHeaderValue() {
            return headerValue;
        }

        @Override
        public final Builder headerValue(String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        public final void setHeaderValue(String headerValue) {
            this.headerValue = headerValue;
        }

        @Override
        public AddHeaderAction build() {
            return new AddHeaderAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
