/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityNotificationAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityNotificationAttributes> {
    private static final SdkField<String> BOUNCE_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IdentityNotificationAttributes.getter(IdentityNotificationAttributes::bounceTopic)).setter(IdentityNotificationAttributes.setter(Builder::bounceTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceTopic").build()}).build();
    private static final SdkField<String> COMPLAINT_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IdentityNotificationAttributes.getter(IdentityNotificationAttributes::complaintTopic)).setter(IdentityNotificationAttributes.setter(Builder::complaintTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplaintTopic").build()}).build();
    private static final SdkField<String> DELIVERY_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IdentityNotificationAttributes.getter(IdentityNotificationAttributes::deliveryTopic)).setter(IdentityNotificationAttributes.setter(Builder::deliveryTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryTopic").build()}).build();
    private static final SdkField<Boolean> FORWARDING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(IdentityNotificationAttributes.getter(IdentityNotificationAttributes::forwardingEnabled)).setter(IdentityNotificationAttributes.setter(Builder::forwardingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingEnabled").build()}).build();
    private static final SdkField<Boolean> HEADERS_IN_BOUNCE_NOTIFICATIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(IdentityNotificationAttributes.getter(IdentityNotificationAttributes::headersInBounceNotificationsEnabled)).setter(IdentityNotificationAttributes.setter(Builder::headersInBounceNotificationsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeadersInBounceNotificationsEnabled").build()}).build();
    private static final SdkField<Boolean> HEADERS_IN_COMPLAINT_NOTIFICATIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(IdentityNotificationAttributes.getter(IdentityNotificationAttributes::headersInComplaintNotificationsEnabled)).setter(IdentityNotificationAttributes.setter(Builder::headersInComplaintNotificationsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeadersInComplaintNotificationsEnabled").build()}).build();
    private static final SdkField<Boolean> HEADERS_IN_DELIVERY_NOTIFICATIONS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(IdentityNotificationAttributes.getter(IdentityNotificationAttributes::headersInDeliveryNotificationsEnabled)).setter(IdentityNotificationAttributes.setter(Builder::headersInDeliveryNotificationsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeadersInDeliveryNotificationsEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNCE_TOPIC_FIELD, COMPLAINT_TOPIC_FIELD, DELIVERY_TOPIC_FIELD, FORWARDING_ENABLED_FIELD, HEADERS_IN_BOUNCE_NOTIFICATIONS_ENABLED_FIELD, HEADERS_IN_COMPLAINT_NOTIFICATIONS_ENABLED_FIELD, HEADERS_IN_DELIVERY_NOTIFICATIONS_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bounceTopic;
    private final String complaintTopic;
    private final String deliveryTopic;
    private final Boolean forwardingEnabled;
    private final Boolean headersInBounceNotificationsEnabled;
    private final Boolean headersInComplaintNotificationsEnabled;
    private final Boolean headersInDeliveryNotificationsEnabled;

    private IdentityNotificationAttributes(BuilderImpl builder) {
        this.bounceTopic = builder.bounceTopic;
        this.complaintTopic = builder.complaintTopic;
        this.deliveryTopic = builder.deliveryTopic;
        this.forwardingEnabled = builder.forwardingEnabled;
        this.headersInBounceNotificationsEnabled = builder.headersInBounceNotificationsEnabled;
        this.headersInComplaintNotificationsEnabled = builder.headersInComplaintNotificationsEnabled;
        this.headersInDeliveryNotificationsEnabled = builder.headersInDeliveryNotificationsEnabled;
    }

    public String bounceTopic() {
        return this.bounceTopic;
    }

    public String complaintTopic() {
        return this.complaintTopic;
    }

    public String deliveryTopic() {
        return this.deliveryTopic;
    }

    public Boolean forwardingEnabled() {
        return this.forwardingEnabled;
    }

    public Boolean headersInBounceNotificationsEnabled() {
        return this.headersInBounceNotificationsEnabled;
    }

    public Boolean headersInComplaintNotificationsEnabled() {
        return this.headersInComplaintNotificationsEnabled;
    }

    public Boolean headersInDeliveryNotificationsEnabled() {
        return this.headersInDeliveryNotificationsEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bounceTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.complaintTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.headersInBounceNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.headersInComplaintNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.headersInDeliveryNotificationsEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityNotificationAttributes)) {
            return false;
        }
        IdentityNotificationAttributes other = (IdentityNotificationAttributes)obj;
        return Objects.equals(this.bounceTopic(), other.bounceTopic()) && Objects.equals(this.complaintTopic(), other.complaintTopic()) && Objects.equals(this.deliveryTopic(), other.deliveryTopic()) && Objects.equals(this.forwardingEnabled(), other.forwardingEnabled()) && Objects.equals(this.headersInBounceNotificationsEnabled(), other.headersInBounceNotificationsEnabled()) && Objects.equals(this.headersInComplaintNotificationsEnabled(), other.headersInComplaintNotificationsEnabled()) && Objects.equals(this.headersInDeliveryNotificationsEnabled(), other.headersInDeliveryNotificationsEnabled());
    }

    public String toString() {
        return ToString.builder((String)"IdentityNotificationAttributes").add("BounceTopic", (Object)this.bounceTopic()).add("ComplaintTopic", (Object)this.complaintTopic()).add("DeliveryTopic", (Object)this.deliveryTopic()).add("ForwardingEnabled", (Object)this.forwardingEnabled()).add("HeadersInBounceNotificationsEnabled", (Object)this.headersInBounceNotificationsEnabled()).add("HeadersInComplaintNotificationsEnabled", (Object)this.headersInComplaintNotificationsEnabled()).add("HeadersInDeliveryNotificationsEnabled", (Object)this.headersInDeliveryNotificationsEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BounceTopic": {
                return Optional.ofNullable(clazz.cast(this.bounceTopic()));
            }
            case "ComplaintTopic": {
                return Optional.ofNullable(clazz.cast(this.complaintTopic()));
            }
            case "DeliveryTopic": {
                return Optional.ofNullable(clazz.cast(this.deliveryTopic()));
            }
            case "ForwardingEnabled": {
                return Optional.ofNullable(clazz.cast(this.forwardingEnabled()));
            }
            case "HeadersInBounceNotificationsEnabled": {
                return Optional.ofNullable(clazz.cast(this.headersInBounceNotificationsEnabled()));
            }
            case "HeadersInComplaintNotificationsEnabled": {
                return Optional.ofNullable(clazz.cast(this.headersInComplaintNotificationsEnabled()));
            }
            case "HeadersInDeliveryNotificationsEnabled": {
                return Optional.ofNullable(clazz.cast(this.headersInDeliveryNotificationsEnabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityNotificationAttributes, T> g) {
        return obj -> g.apply((IdentityNotificationAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bounceTopic;
        private String complaintTopic;
        private String deliveryTopic;
        private Boolean forwardingEnabled;
        private Boolean headersInBounceNotificationsEnabled;
        private Boolean headersInComplaintNotificationsEnabled;
        private Boolean headersInDeliveryNotificationsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityNotificationAttributes model) {
            this.bounceTopic(model.bounceTopic);
            this.complaintTopic(model.complaintTopic);
            this.deliveryTopic(model.deliveryTopic);
            this.forwardingEnabled(model.forwardingEnabled);
            this.headersInBounceNotificationsEnabled(model.headersInBounceNotificationsEnabled);
            this.headersInComplaintNotificationsEnabled(model.headersInComplaintNotificationsEnabled);
            this.headersInDeliveryNotificationsEnabled(model.headersInDeliveryNotificationsEnabled);
        }

        public final String getBounceTopic() {
            return this.bounceTopic;
        }

        @Override
        public final Builder bounceTopic(String bounceTopic) {
            this.bounceTopic = bounceTopic;
            return this;
        }

        public final void setBounceTopic(String bounceTopic) {
            this.bounceTopic = bounceTopic;
        }

        public final String getComplaintTopic() {
            return this.complaintTopic;
        }

        @Override
        public final Builder complaintTopic(String complaintTopic) {
            this.complaintTopic = complaintTopic;
            return this;
        }

        public final void setComplaintTopic(String complaintTopic) {
            this.complaintTopic = complaintTopic;
        }

        public final String getDeliveryTopic() {
            return this.deliveryTopic;
        }

        @Override
        public final Builder deliveryTopic(String deliveryTopic) {
            this.deliveryTopic = deliveryTopic;
            return this;
        }

        public final void setDeliveryTopic(String deliveryTopic) {
            this.deliveryTopic = deliveryTopic;
        }

        public final Boolean getForwardingEnabled() {
            return this.forwardingEnabled;
        }

        @Override
        public final Builder forwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
            return this;
        }

        public final void setForwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
        }

        public final Boolean getHeadersInBounceNotificationsEnabled() {
            return this.headersInBounceNotificationsEnabled;
        }

        @Override
        public final Builder headersInBounceNotificationsEnabled(Boolean headersInBounceNotificationsEnabled) {
            this.headersInBounceNotificationsEnabled = headersInBounceNotificationsEnabled;
            return this;
        }

        public final void setHeadersInBounceNotificationsEnabled(Boolean headersInBounceNotificationsEnabled) {
            this.headersInBounceNotificationsEnabled = headersInBounceNotificationsEnabled;
        }

        public final Boolean getHeadersInComplaintNotificationsEnabled() {
            return this.headersInComplaintNotificationsEnabled;
        }

        @Override
        public final Builder headersInComplaintNotificationsEnabled(Boolean headersInComplaintNotificationsEnabled) {
            this.headersInComplaintNotificationsEnabled = headersInComplaintNotificationsEnabled;
            return this;
        }

        public final void setHeadersInComplaintNotificationsEnabled(Boolean headersInComplaintNotificationsEnabled) {
            this.headersInComplaintNotificationsEnabled = headersInComplaintNotificationsEnabled;
        }

        public final Boolean getHeadersInDeliveryNotificationsEnabled() {
            return this.headersInDeliveryNotificationsEnabled;
        }

        @Override
        public final Builder headersInDeliveryNotificationsEnabled(Boolean headersInDeliveryNotificationsEnabled) {
            this.headersInDeliveryNotificationsEnabled = headersInDeliveryNotificationsEnabled;
            return this;
        }

        public final void setHeadersInDeliveryNotificationsEnabled(Boolean headersInDeliveryNotificationsEnabled) {
            this.headersInDeliveryNotificationsEnabled = headersInDeliveryNotificationsEnabled;
        }

        public IdentityNotificationAttributes build() {
            return new IdentityNotificationAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityNotificationAttributes> {
        public Builder bounceTopic(String var1);

        public Builder complaintTopic(String var1);

        public Builder deliveryTopic(String var1);

        public Builder forwardingEnabled(Boolean var1);

        public Builder headersInBounceNotificationsEnabled(Boolean var1);

        public Builder headersInComplaintNotificationsEnabled(Boolean var1);

        public Builder headersInDeliveryNotificationsEnabled(Boolean var1);
    }
}

