/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.nio.ByteBuffer;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.RawMessage;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;

public class SendRawEmailRequestMarshaller
implements Marshaller<Request<SendRawEmailRequest>, SendRawEmailRequest> {
    public Request<SendRawEmailRequest> marshall(SendRawEmailRequest sendRawEmailRequest) {
        List<MessageTag> tagsList;
        RawMessage rawMessage;
        List<String> destinationsList;
        if (sendRawEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)sendRawEmailRequest, "SESClient");
        request.addParameter("Action", "SendRawEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendRawEmailRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString((String)sendRawEmailRequest.source()));
        }
        if ((destinationsList = sendRawEmailRequest.destinations()) != null) {
            if (!destinationsList.isEmpty()) {
                int destinationsListIndex = 1;
                for (String destinationsListValue : destinationsList) {
                    if (destinationsListValue != null) {
                        request.addParameter("Destinations.member." + destinationsListIndex, StringUtils.fromString((String)destinationsListValue));
                    }
                    ++destinationsListIndex;
                }
            } else {
                request.addParameter("Destinations", "");
            }
        }
        if ((rawMessage = sendRawEmailRequest.rawMessage()) != null && rawMessage.data() != null) {
            request.addParameter("RawMessage.Data", StringUtils.fromByteBuffer((ByteBuffer)rawMessage.data()));
        }
        if (sendRawEmailRequest.fromArn() != null) {
            request.addParameter("FromArn", StringUtils.fromString((String)sendRawEmailRequest.fromArn()));
        }
        if (sendRawEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)sendRawEmailRequest.sourceArn()));
        }
        if (sendRawEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString((String)sendRawEmailRequest.returnPathArn()));
        }
        if ((tagsList = sendRawEmailRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (MessageTag tagsListValue : tagsList) {
                    if (tagsListValue.name() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Name", StringUtils.fromString((String)tagsListValue.name()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (sendRawEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)sendRawEmailRequest.configurationSetName()));
        }
        return request;
    }
}

