/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest;

public class DescribeReceiptRuleRequestMarshaller
implements Marshaller<Request<DescribeReceiptRuleRequest>, DescribeReceiptRuleRequest> {
    public Request<DescribeReceiptRuleRequest> marshall(DescribeReceiptRuleRequest describeReceiptRuleRequest) {
        if (describeReceiptRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeReceiptRuleRequest, "SESClient");
        request.addParameter("Action", "DescribeReceiptRule");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReceiptRuleRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString((String)describeReceiptRuleRequest.ruleSetName()));
        }
        if (describeReceiptRuleRequest.ruleName() != null) {
            request.addParameter("RuleName", StringUtils.fromString((String)describeReceiptRuleRequest.ruleName()));
        }
        return request;
    }
}

