/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest;

public class DescribeConfigurationSetRequestMarshaller
implements Marshaller<Request<DescribeConfigurationSetRequest>, DescribeConfigurationSetRequest> {
    public Request<DescribeConfigurationSetRequest> marshall(DescribeConfigurationSetRequest describeConfigurationSetRequest) {
        List<String> configurationSetAttributeNamesList;
        if (describeConfigurationSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeConfigurationSetRequest, "SESClient");
        request.addParameter("Action", "DescribeConfigurationSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeConfigurationSetRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)describeConfigurationSetRequest.configurationSetName()));
        }
        if ((configurationSetAttributeNamesList = describeConfigurationSetRequest.configurationSetAttributeNamesStrings()) != null) {
            if (!configurationSetAttributeNamesList.isEmpty()) {
                int configurationSetAttributeNamesListIndex = 1;
                for (String configurationSetAttributeNamesListValue : configurationSetAttributeNamesList) {
                    if (configurationSetAttributeNamesListValue != null) {
                        request.addParameter("ConfigurationSetAttributeNames.member." + configurationSetAttributeNamesListIndex, StringUtils.fromString((String)configurationSetAttributeNamesListValue));
                    }
                    ++configurationSetAttributeNamesListIndex;
                }
            } else {
                request.addParameter("ConfigurationSetAttributeNames", "");
            }
        }
        return request;
    }
}

