/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.MessageTagListCopier;
import software.amazon.awssdk.services.ses.model.RawMessage;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendRawEmailRequest
extends SESRequest
implements ToCopyableBuilder<Builder, SendRawEmailRequest> {
    private final String source;
    private final List<String> destinations;
    private final RawMessage rawMessage;
    private final String fromArn;
    private final String sourceArn;
    private final String returnPathArn;
    private final List<MessageTag> tags;
    private final String configurationSetName;

    private SendRawEmailRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.destinations = builder.destinations;
        this.rawMessage = builder.rawMessage;
        this.fromArn = builder.fromArn;
        this.sourceArn = builder.sourceArn;
        this.returnPathArn = builder.returnPathArn;
        this.tags = builder.tags;
        this.configurationSetName = builder.configurationSetName;
    }

    public String source() {
        return this.source;
    }

    public List<String> destinations() {
        return this.destinations;
    }

    public RawMessage rawMessage() {
        return this.rawMessage;
    }

    public String fromArn() {
        return this.fromArn;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String returnPathArn() {
        return this.returnPathArn;
    }

    public List<MessageTag> tags() {
        return this.tags;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnPathArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendRawEmailRequest)) {
            return false;
        }
        SendRawEmailRequest other = (SendRawEmailRequest)((Object)obj);
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.rawMessage(), other.rawMessage()) && Objects.equals(this.fromArn(), other.fromArn()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.returnPathArn(), other.returnPathArn()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.configurationSetName(), other.configurationSetName());
    }

    public String toString() {
        return ToString.builder((String)"SendRawEmailRequest").add("Source", (Object)this.source()).add("Destinations", this.destinations()).add("RawMessage", (Object)this.rawMessage()).add("FromArn", (Object)this.fromArn()).add("SourceArn", (Object)this.sourceArn()).add("ReturnPathArn", (Object)this.returnPathArn()).add("Tags", this.tags()).add("ConfigurationSetName", (Object)this.configurationSetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "Destinations": {
                return Optional.of(clazz.cast(this.destinations()));
            }
            case "RawMessage": {
                return Optional.of(clazz.cast(this.rawMessage()));
            }
            case "FromArn": {
                return Optional.of(clazz.cast(this.fromArn()));
            }
            case "SourceArn": {
                return Optional.of(clazz.cast(this.sourceArn()));
            }
            case "ReturnPathArn": {
                return Optional.of(clazz.cast(this.returnPathArn()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "ConfigurationSetName": {
                return Optional.of(clazz.cast(this.configurationSetName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String source;
        private List<String> destinations;
        private RawMessage rawMessage;
        private String fromArn;
        private String sourceArn;
        private String returnPathArn;
        private List<MessageTag> tags;
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendRawEmailRequest model) {
            this.source(model.source);
            this.destinations(model.destinations);
            this.rawMessage(model.rawMessage);
            this.fromArn(model.fromArn);
            this.sourceArn(model.sourceArn);
            this.returnPathArn(model.returnPathArn);
            this.tags(model.tags);
            this.configurationSetName(model.configurationSetName);
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Collection<String> getDestinations() {
            return this.destinations;
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = AddressListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = AddressListCopier.copy(destinations);
        }

        public final RawMessage.Builder getRawMessage() {
            return this.rawMessage != null ? this.rawMessage.toBuilder() : null;
        }

        @Override
        public final Builder rawMessage(RawMessage rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        public final void setRawMessage(RawMessage.BuilderImpl rawMessage) {
            this.rawMessage = rawMessage != null ? rawMessage.build() : null;
        }

        public final String getFromArn() {
            return this.fromArn;
        }

        @Override
        public final Builder fromArn(String fromArn) {
            this.fromArn = fromArn;
            return this;
        }

        public final void setFromArn(String fromArn) {
            this.fromArn = fromArn;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getReturnPathArn() {
            return this.returnPathArn;
        }

        @Override
        public final Builder returnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
            return this;
        }

        public final void setReturnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
        }

        public final Collection<MessageTag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(MessageTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<MessageTag> tags) {
            this.tags = MessageTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(MessageTag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<MessageTag.BuilderImpl> tags) {
            this.tags = MessageTagListCopier.copyFromBuilder(tags);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SendRawEmailRequest build() {
            return new SendRawEmailRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, SendRawEmailRequest> {
        public Builder source(String var1);

        public Builder destinations(Collection<String> var1);

        public Builder destinations(String ... var1);

        public Builder rawMessage(RawMessage var1);

        default public Builder rawMessage(Consumer<RawMessage.Builder> rawMessage) {
            return this.rawMessage((RawMessage)((RawMessage.Builder)RawMessage.builder().apply(rawMessage)).build());
        }

        public Builder fromArn(String var1);

        public Builder sourceArn(String var1);

        public Builder returnPathArn(String var1);

        public Builder tags(Collection<MessageTag> var1);

        public Builder tags(MessageTag ... var1);

        public Builder configurationSetName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

