/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.SESResponse;
import software.amazon.awssdk.services.ses.model.TemplateMetadata;
import software.amazon.awssdk.services.ses.model.TemplateMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTemplatesResponse
extends SESResponse
implements ToCopyableBuilder<Builder, ListTemplatesResponse> {
    private final List<TemplateMetadata> templatesMetadata;
    private final String nextToken;

    private ListTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templatesMetadata = builder.templatesMetadata;
        this.nextToken = builder.nextToken;
    }

    public List<TemplateMetadata> templatesMetadata() {
        return this.templatesMetadata;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templatesMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplatesResponse)) {
            return false;
        }
        ListTemplatesResponse other = (ListTemplatesResponse)((Object)obj);
        return Objects.equals(this.templatesMetadata(), other.templatesMetadata()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTemplatesResponse").add("TemplatesMetadata", this.templatesMetadata()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplatesMetadata": {
                return Optional.of(clazz.cast(this.templatesMetadata()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESResponse.BuilderImpl
    implements Builder {
        private List<TemplateMetadata> templatesMetadata;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplatesResponse model) {
            this.templatesMetadata(model.templatesMetadata);
            this.nextToken(model.nextToken);
        }

        public final Collection<TemplateMetadata.Builder> getTemplatesMetadata() {
            return this.templatesMetadata != null ? (Collection)this.templatesMetadata.stream().map(TemplateMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder templatesMetadata(Collection<TemplateMetadata> templatesMetadata) {
            this.templatesMetadata = TemplateMetadataListCopier.copy(templatesMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatesMetadata(TemplateMetadata ... templatesMetadata) {
            this.templatesMetadata(Arrays.asList(templatesMetadata));
            return this;
        }

        public final void setTemplatesMetadata(Collection<TemplateMetadata.BuilderImpl> templatesMetadata) {
            this.templatesMetadata = TemplateMetadataListCopier.copyFromBuilder(templatesMetadata);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTemplatesResponse build() {
            return new ListTemplatesResponse(this);
        }
    }

    public static interface Builder
    extends SESResponse.Builder,
    CopyableBuilder<Builder, ListTemplatesResponse> {
        public Builder templatesMetadata(Collection<TemplateMetadata> var1);

        public Builder templatesMetadata(TemplateMetadata ... var1);

        public Builder nextToken(String var1);
    }
}

