/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReceiptRuleRequest
extends SESRequest
implements ToCopyableBuilder<Builder, DescribeReceiptRuleRequest> {
    private final String ruleSetName;
    private final String ruleName;

    private DescribeReceiptRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.ruleName = builder.ruleName;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String ruleName() {
        return this.ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReceiptRuleRequest)) {
            return false;
        }
        DescribeReceiptRuleRequest other = (DescribeReceiptRuleRequest)((Object)obj);
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.ruleName(), other.ruleName());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReceiptRuleRequest").add("RuleSetName", (Object)this.ruleSetName()).add("RuleName", (Object)this.ruleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.of(clazz.cast(this.ruleSetName()));
            }
            case "RuleName": {
                return Optional.of(clazz.cast(this.ruleName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReceiptRuleRequest model) {
            this.ruleSetName(model.ruleSetName);
            this.ruleName(model.ruleName);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeReceiptRuleRequest build() {
            return new DescribeReceiptRuleRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, DescribeReceiptRuleRequest> {
        public Builder ruleSetName(String var1);

        public Builder ruleName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

