/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAttributeListCopier;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConfigurationSetRequest
extends SESRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationSetRequest> {
    private final String configurationSetName;
    private final List<String> configurationSetAttributeNames;

    private DescribeConfigurationSetRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.configurationSetAttributeNames = builder.configurationSetAttributeNames;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public List<ConfigurationSetAttribute> configurationSetAttributeNames() {
        return TypeConverter.convert(this.configurationSetAttributeNames, ConfigurationSetAttribute::fromValue);
    }

    public List<String> configurationSetAttributeNamesStrings() {
        return this.configurationSetAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetAttributeNamesStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetRequest)) {
            return false;
        }
        DescribeConfigurationSetRequest other = (DescribeConfigurationSetRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.configurationSetAttributeNamesStrings(), other.configurationSetAttributeNamesStrings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationSetRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("ConfigurationSetAttributeNames", this.configurationSetAttributeNamesStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.of(clazz.cast(this.configurationSetName()));
            }
            case "ConfigurationSetAttributeNames": {
                return Optional.of(clazz.cast(this.configurationSetAttributeNamesStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private List<String> configurationSetAttributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetRequest model) {
            this.configurationSetName(model.configurationSetName);
            this.configurationSetAttributeNames(model.configurationSetAttributeNames);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final Collection<String> getConfigurationSetAttributeNames() {
            return this.configurationSetAttributeNames;
        }

        @Override
        public final Builder configurationSetAttributeNames(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSetAttributeNames(String ... configurationSetAttributeNames) {
            this.configurationSetAttributeNames(Arrays.asList(configurationSetAttributeNames));
            return this;
        }

        public final void setConfigurationSetAttributeNames(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationSetRequest build() {
            return new DescribeConfigurationSetRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, DescribeConfigurationSetRequest> {
        public Builder configurationSetName(String var1);

        public Builder configurationSetAttributeNames(Collection<String> var1);

        public Builder configurationSetAttributeNames(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

