/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteConfigurationSetEventDestinationRequest
extends SESRequest
implements ToCopyableBuilder<Builder, DeleteConfigurationSetEventDestinationRequest> {
    private final String configurationSetName;
    private final String eventDestinationName;

    private DeleteConfigurationSetEventDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinationName = builder.eventDestinationName;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public String eventDestinationName() {
        return this.eventDestinationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDestinationName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfigurationSetEventDestinationRequest)) {
            return false;
        }
        DeleteConfigurationSetEventDestinationRequest other = (DeleteConfigurationSetEventDestinationRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.eventDestinationName(), other.eventDestinationName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteConfigurationSetEventDestinationRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("EventDestinationName", (Object)this.eventDestinationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.of(clazz.cast(this.configurationSetName()));
            }
            case "EventDestinationName": {
                return Optional.of(clazz.cast(this.eventDestinationName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private String eventDestinationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfigurationSetEventDestinationRequest model) {
            this.configurationSetName(model.configurationSetName);
            this.eventDestinationName(model.eventDestinationName);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final String getEventDestinationName() {
            return this.eventDestinationName;
        }

        @Override
        public final Builder eventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
            return this;
        }

        public final void setEventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteConfigurationSetEventDestinationRequest build() {
            return new DeleteConfigurationSetEventDestinationRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, DeleteConfigurationSetEventDestinationRequest> {
        public Builder configurationSetName(String var1);

        public Builder eventDestinationName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

